/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1String;
import com.phaos.cert.GeneralName;
import com.phaos.cert.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class GeneralNames
implements ASN1Object {
    private Vector gns = new Vector();
    private ASN1Sequence contents;

    public GeneralNames() {
    }

    public GeneralNames(GeneralName generalName) {
        this.addGeneralName(generalName);
    }

    public GeneralNames(X500Name x500Name) {
        this(x500Name, null);
    }

    public GeneralNames(X500Name x500Name, String string) {
        if (x500Name != null) {
            this.addGeneralName(x500Name);
        }
        if (string != null) {
            this.addGeneralName(string);
        }
    }

    public GeneralNames(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public GeneralNames(String string) {
        this(null, string);
    }

    public GeneralNames(Vector vector) {
        this.addGeneralNames(vector);
    }

    public void addGeneralName(GeneralName generalName) {
        if (generalName != null) {
            this.gns.addElement(generalName);
            this.clearContents();
        }
    }

    public void addGeneralName(X500Name x500Name) {
        if (x500Name != null) {
            this.addGeneralName(new GeneralName(x500Name));
        }
    }

    public void addGeneralName(String string) {
        if (string != null) {
            this.addGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, string));
        }
    }

    public void addGeneralNames(Vector vector) {
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.gns.addElement(vector.elementAt(n));
                ++n;
            }
            this.clearContents();
        }
    }

    private void clearContents() {
        this.contents = null;
    }

    public boolean containsGeneralName(GeneralName generalName) {
        if (generalName == null || this.gns == null || this.gns.size() < 1) {
            return false;
        }
        return this.gns.contains(generalName);
    }

    public GeneralName generalNameAt(int n) {
        return (GeneralName)this.gns.elementAt(n);
    }

    public Enumeration generalNames() {
        if (this.gns == null) {
            return new Vector().elements();
        }
        return this.gns.elements();
    }

    public Vector getGeneralNames() {
        return this.gns;
    }

    public Vector getRFC822Names() {
        if (this.gns == null || this.gns.size() < 1) {
            return null;
        }
        Vector<String> vector = null;
        int n = 0;
        int n2 = this.gns.size();
        while (n < n2) {
            GeneralName generalName = (GeneralName)this.gns.elementAt(n);
            if (generalName.getType().equals(GeneralName.Type.RFC822_NAME)) {
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.addElement(((ASN1String)generalName.getValue()).getValue());
            }
            ++n;
        }
        return vector;
    }

    public void input(InputStream inputStream) throws IOException {
        this.clearContents();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        if (aSN1SequenceInputStream.hasMoreData()) {
            this.gns = new Vector();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.gns.addElement(new GeneralName(aSN1SequenceInputStream));
            }
        }
        aSN1SequenceInputStream.terminate();
        if (this.gns == null || this.gns.size() < 1) {
            throw new IOException("General Names can not be Empty");
        }
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        if (this.gns == null || this.gns.size() < 1) {
            throw new IOException("General Names is Empty");
        }
        this.toASN1Sequence().output(outputStream);
    }

    public GeneralName removeGeneralName(int n) {
        GeneralName generalName = (GeneralName)this.gns.elementAt(n);
        this.gns.removeElementAt(n);
        this.clearContents();
        return generalName;
    }

    public boolean removeGeneralName(GeneralName generalName) {
        boolean bl = false;
        if (generalName != null) {
            bl = this.gns.removeElement(generalName);
            this.clearContents();
        }
        return bl;
    }

    public boolean removeGeneralName(X500Name x500Name) {
        if (x500Name != null) {
            return this.removeGeneralName(new GeneralName(x500Name));
        }
        return false;
    }

    public boolean removeGeneralName(String string) {
        if (string != null) {
            return this.removeGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, string));
        }
        return false;
    }

    public boolean removeGeneralNames(Vector vector) {
        boolean bl = false;
        if (vector != null && vector.size() != 0) {
            boolean bl2 = false;
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                bl2 = this.gns.removeElement(vector.elementAt(n));
                if (!bl) {
                    bl = bl2;
                }
                ++n;
            }
        }
        if (bl) {
            this.clearContents();
        }
        return bl;
    }

    public int size() {
        return this.gns.size();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.gns);
        }
        return this.contents;
    }

    public String toString() {
        if (this.gns == null || this.gns.size() < 1) {
            return "General Names: 0 Elements\n";
        }
        StringBuffer stringBuffer = new StringBuffer("GeneralNames: " + this.gns.size() + " Elements\n");
        int n = 0;
        int n2 = this.gns.size();
        while (n < n2) {
            stringBuffer.append(String.valueOf(n) + ". " + (GeneralName)this.gns.elementAt(n) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

