/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public final class IssuerAndSerialNo
implements ASN1Object {
    private X500Name issuer;
    private BigInteger serialNo;
    private ASN1Sequence contents;

    public IssuerAndSerialNo(X500Name x500Name, BigInteger bigInteger) {
        this.issuer = x500Name;
        this.serialNo = bigInteger;
    }

    public IssuerAndSerialNo(X509 x509) {
        this(x509.getIssuer(), x509.getSerialNo());
    }

    public IssuerAndSerialNo(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IssuerAndSerialNo)) {
            return false;
        }
        IssuerAndSerialNo issuerAndSerialNo = (IssuerAndSerialNo)object;
        return Utils.areEqual(this.getEncoded(), issuerAndSerialNo.getEncoded());
    }

    public byte[] getEncoded() {
        return Utils.toBytes(this);
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public int hashCode() {
        return new String(this.getEncoded()).hashCode();
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.issuer = new X500Name(aSN1SequenceInputStream);
        this.serialNo = ASN1Integer.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        this.update();
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.issuer);
            aSN1Sequence.addElement(new ASN1Integer(this.serialNo));
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append("issuer = ");
        stringBuffer.append(this.issuer != null ? this.issuer.toString() : "null");
        stringBuffer.append(", serialNo = ");
        stringBuffer.append(this.serialNo != null ? this.serialNo.toString() : "null");
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private void update() {
        this.contents = null;
    }
}

