/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.cert.PKCS12;
import com.phaos.cert.PKCS12Bag;
import com.phaos.cert.PKCS12CertBag;
import com.phaos.cert.PKCS12Safe;
import com.phaos.cert.PKCS12ShroudedKeyBag;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PrivateKeyPKCS8;
import com.phaos.utils.InvalidInputException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class KeyPairPKCS12
extends PKCS12 {
    private Vector orderedCertChain = null;

    public KeyPairPKCS12() {
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 privateKeyPKCS8, Vector vector, int n) {
        this(privateKeyPKCS8, vector, n, null);
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 privateKeyPKCS8, Vector vector, int n, String string) {
        Object object;
        ASN1Object aSN1Object;
        byte[] byArray = null;
        if (vector != null && vector.size() > 0) {
            aSN1Object = (X509)vector.elementAt(0);
            object = null;
            try {
                object = MessageDigest.getInstance(AlgID.sha_1);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
            }
            byArray = ((MessageDigest)object).computeDigest(((X509)aSN1Object).getEncoded());
        }
        if (privateKeyPKCS8 != null) {
            aSN1Object = new PKCS12Safe((PKCS12)this, -2);
            object = new PKCS12ShroudedKeyBag((PKCS12Safe)aSN1Object, privateKeyPKCS8);
            if (byArray != null) {
                ((PKCS12Bag)object).setLocalKeyID(byArray);
            }
            if (string != null) {
                ((PKCS12Bag)object).setFriendlyName(string);
            }
            ((PKCS12Safe)aSN1Object).addBag((PKCS12Bag)object);
            this.addAuthSafe((PKCS12Safe)aSN1Object);
        }
        if (vector != null && vector.size() > 0) {
            aSN1Object = new PKCS12Safe((PKCS12)this, n);
            int n2 = vector.size() - 1;
            while (n2 > 0) {
                ((PKCS12Safe)aSN1Object).addBag(new PKCS12CertBag((PKCS12Safe)aSN1Object, (X509)vector.elementAt(n2)));
                --n2;
            }
            X509 x509 = (X509)vector.elementAt(0);
            PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, x509);
            if (byArray != null) {
                pKCS12CertBag.setLocalKeyID(byArray);
            }
            if (string != null) {
                pKCS12CertBag.setFriendlyName(string);
            }
            ((PKCS12Safe)aSN1Object).addBag(pKCS12CertBag);
            this.addAuthSafe((PKCS12Safe)aSN1Object);
        }
    }

    public KeyPairPKCS12(String string, ASN1Sequence aSN1Sequence) throws IOException {
        super(string, aSN1Sequence);
        this.orderCertificateChain();
    }

    public KeyPairPKCS12(String string, PrivateKeyPKCS8 privateKeyPKCS8, Vector vector, int n) {
        this(string, privateKeyPKCS8, vector, n, null);
    }

    public KeyPairPKCS12(String string, PrivateKeyPKCS8 privateKeyPKCS8, Vector vector, int n, String string2) {
        this(privateKeyPKCS8, vector, n, string2);
        this.setPassword(string);
    }

    public KeyPairPKCS12(String string, InputStream inputStream) throws IOException {
        super(string, inputStream);
        this.orderCertificateChain();
    }

    public X509 getBottomCert() {
        Vector vector = this.getCertificateChain();
        if (vector.size() == 0) {
            return null;
        }
        return (X509)vector.firstElement();
    }

    public Vector getCertificateChain() {
        return this.orderedCertChain;
    }

    public PrivateKey getPrivateKey() {
        PKCS12ShroudedKeyBag pKCS12ShroudedKeyBag = this.getShroudedKeyBag();
        if (pKCS12ShroudedKeyBag != null) {
            return pKCS12ShroudedKeyBag.getPrivateKey();
        }
        return null;
    }

    public PrivateKey getPrivateKey(String string) {
        PrivateKeyPKCS8 privateKeyPKCS8 = this.getPrivateKeyPKCS8();
        if (privateKeyPKCS8 != null) {
            privateKeyPKCS8.setPassword(string);
            return privateKeyPKCS8.getKey();
        }
        return null;
    }

    public PrivateKeyPKCS8 getPrivateKeyPKCS8() {
        PKCS12ShroudedKeyBag pKCS12ShroudedKeyBag = this.getShroudedKeyBag();
        if (pKCS12ShroudedKeyBag != null) {
            return pKCS12ShroudedKeyBag.getPKCS8();
        }
        return null;
    }

    private PKCS12ShroudedKeyBag getShroudedKeyBag() {
        Vector vector = this.getAuthSafes();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(n);
            Vector vector2 = pKCS12Safe.getBags();
            int n3 = 0;
            int n4 = vector2.size();
            while (n3 < n4) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector2.elementAt(n3);
                if (pKCS12Bag instanceof PKCS12ShroudedKeyBag) {
                    return (PKCS12ShroudedKeyBag)pKCS12Bag;
                }
                ++n3;
            }
            ++n;
        }
        return null;
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        super.input(aSN1Sequence);
        this.orderedCertChain = null;
        this.orderCertificateChain();
    }

    public void input(InputStream inputStream) throws IOException {
        super.input(inputStream);
        this.orderedCertChain = null;
        this.orderCertificateChain();
    }

    private void orderCertificateChain() throws InvalidInputException {
        Serializable serializable;
        ASN1Object aSN1Object;
        if (this.orderedCertChain != null) {
            return;
        }
        Hashtable<X500Name, X509> hashtable = new Hashtable<X500Name, X509>();
        Hashtable<X500Name, X509> hashtable2 = new Hashtable<X500Name, X509>();
        int n = 0;
        Vector<Object> vector = new Vector<Object>();
        Hashtable<Object, Object> hashtable3 = new Hashtable<Object, Object>();
        Vector vector2 = this.getAuthSafes();
        int n2 = 0;
        int n3 = vector2.size();
        while (n2 < n3) {
            aSN1Object = (PKCS12Safe)vector2.elementAt(n2);
            serializable = ((PKCS12Safe)aSN1Object).getBags();
            int n4 = 0;
            int n5 = ((Vector)serializable).size();
            while (n4 < n5) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)((Vector)serializable).elementAt(n4);
                if (pKCS12Bag instanceof PKCS12CertBag) {
                    X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                    if (x509.getIssuer().equals(x509.getSubject())) {
                        vector.addElement(x509);
                        hashtable3.put(x509, x509);
                    } else {
                        if (hashtable.put(x509.getIssuer(), x509) != null) {
                            throw new InvalidInputException("Multiple certificates with same issuer");
                        }
                        if (hashtable2.put(x509.getSubject(), x509) != null) {
                            throw new InvalidInputException("Multiple certificates with same subject");
                        }
                    }
                    ++n;
                }
                ++n4;
            }
            ++n2;
        }
        if (vector.size() == 0 && hashtable.size() > 0) {
            aSN1Object = (X509)hashtable.get((X500Name)hashtable.keys().nextElement());
            if (aSN1Object != null) {
                vector.addElement(aSN1Object);
                hashtable3.put(aSN1Object, aSN1Object);
            }
        } else if (vector.size() > 1) {
            throw new InvalidInputException("Certificate chain contains more than 1 self-signed cert");
        }
        if (vector.size() == 1) {
            aSN1Object = (X509)vector.elementAt(0);
            serializable = (X509)hashtable2.get(((X509)aSN1Object).getIssuer());
            X509 x509 = (X509)hashtable.get(((X509)aSN1Object).getSubject());
            while (serializable != null) {
                if (hashtable3.put(serializable, serializable) != null) {
                    throw new InvalidInputException("Certificate chain contains a cycle");
                }
                vector.addElement(serializable);
                serializable = (X509)hashtable2.get(((X509)serializable).getIssuer());
            }
            while (x509 != null) {
                if (hashtable3.put(x509, x509) != null) {
                    throw new InvalidInputException("Certificate chain contains a cycle");
                }
                vector.insertElementAt(x509, 0);
                x509 = (X509)hashtable.get(x509.getSubject());
            }
            if (vector.size() != n) {
                throw new InvalidInputException("Certificate chain cannot be ordered");
            }
        }
        this.orderedCertChain = vector;
    }
}

