/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKCS12Safe;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.DigestInfo;
import com.phaos.crypto.HMAC;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PKCS5;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class PKCS12
implements ASN1Object {
    private Vector authSafes = new Vector();
    private String passwd;
    private AlgorithmIdentifier macAlg;
    private byte[] macBytes;
    private byte[] macSalt;
    private BigInteger iterations;
    private ASN1Sequence contents;

    public PKCS12() {
    }

    public PKCS12(InputStream inputStream) throws IOException {
        this();
        this.input(inputStream);
    }

    public PKCS12(String string, ASN1Sequence aSN1Sequence) throws IOException {
        this();
        this.setPassword(string);
        this.input(aSN1Sequence);
    }

    public PKCS12(String string, InputStream inputStream) throws IOException {
        this();
        this.setPassword(string);
        this.input(inputStream);
    }

    public void addAuthSafe(PKCS12Safe pKCS12Safe) {
        this.authSafes.addElement(pKCS12Safe);
        this.contents = null;
        this.macBytes = null;
    }

    private void computeMAC() throws AlgorithmIdentifierException, CipherException {
        if (this.macAlg == null) {
            this.macAlg = AlgID.sha_1;
        }
        if (this.macSalt == null) {
            this.macSalt = RandomBitsSource.getDefault().randomBytes(new byte[8]);
        }
        if (this.iterations == null) {
            this.iterations = BigInteger.valueOf(1024L);
        }
        byte[] byArray = PKCS5.pkcs12PseudoRandomBytes((byte)3, MessageDigest.getInstance(this.macAlg).getDigestLength(), this.macAlg, this.passwd, this.macSalt, this.iterations.intValue());
        HMAC hMAC = new HMAC(this.macAlg, byArray);
        byte[] byArray2 = Utils.toBytes(new ASN1Sequence(this.authSafes));
        this.macBytes = hMAC.computeDigest(byArray2);
    }

    public Vector getAuthSafes() {
        return this.authSafes;
    }

    public String getPassword() {
        return this.passwd;
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public void input(InputStream inputStream) throws IOException {
        Object object;
        ASN1ConstructedInputStream aSN1ConstructedInputStream;
        this.contents = null;
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        int n = ASN1Integer.inputValue(aSN1SequenceInputStream).intValue();
        if (n != 3) {
            throw new ASN1FormatException("Expecting version 3, got version " + n);
        }
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream2);
        if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 7, 1)) {
            if (aSN1SequenceInputStream2.hasMoreData()) {
                aSN1ConstructedInputStream = new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream2, 0);
                object = ASN1OctetString.inputValue(aSN1ConstructedInputStream);
                aSN1ConstructedInputStream.terminate();
                ASN1SequenceInputStream aSN1SequenceInputStream3 = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream((byte[])object));
                while (aSN1SequenceInputStream3.hasMoreData()) {
                    this.addAuthSafe(new PKCS12Safe(this, new ASN1Sequence(aSN1SequenceInputStream3)));
                }
                aSN1SequenceInputStream3.terminate();
            }
        } else {
            if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 7, 2)) {
                throw new ASN1FormatException("Public-key integrity mode not supported");
            }
            throw new ASN1FormatException("Invalid integrity mode OID " + aSN1ObjectID.toStringCompact());
        }
        aSN1SequenceInputStream2.terminate();
        if (aSN1SequenceInputStream.hasMoreData()) {
            aSN1ConstructedInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            object = new DigestInfo(aSN1ConstructedInputStream);
            this.macAlg = ((DigestInfo)object).getDigestAlgID();
            this.macBytes = ((DigestInfo)object).getDigest();
            this.macSalt = ASN1OctetString.inputValue(aSN1ConstructedInputStream);
            this.iterations = aSN1ConstructedInputStream.hasMoreData() ? ASN1Integer.inputValue(aSN1ConstructedInputStream) : BigInteger.valueOf(1L);
            aSN1ConstructedInputStream.terminate();
        } else {
            this.macAlg = null;
            this.macBytes = null;
            this.macSalt = null;
            this.iterations = null;
        }
        aSN1SequenceInputStream.terminate();
    }

    public int length() {
        return this.toASN1().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1().output(outputStream);
    }

    public void setAuthSafes(Vector vector) {
        this.authSafes = vector;
        this.contents = null;
        this.macBytes = null;
    }

    public void setPassword(String string) {
        if (this.passwd != null && !this.passwd.equals(string)) {
            this.contents = null;
            this.macBytes = null;
        }
        this.passwd = string;
    }

    private ASN1Sequence toASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(3L));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 7, 1));
        byte[] byArray = Utils.toBytes(new ASN1Sequence(this.authSafes));
        aSN1Sequence2.addElement(new ASN1GenericConstructed(new ASN1OctetString(byArray), 0));
        aSN1Sequence.addElement(aSN1Sequence2);
        ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
        if (this.macBytes == null) {
            try {
                this.computeMAC();
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new StreamableOutputException(algorithmIdentifierException.toString());
            }
            catch (CipherException cipherException) {
                throw new StreamableOutputException(cipherException.toString());
            }
        }
        aSN1Sequence3.addElement(new DigestInfo(this.macAlg, this.macBytes));
        aSN1Sequence3.addElement(new ASN1OctetString(this.macSalt));
        if (this.iterations.intValue() != 1) {
            aSN1Sequence3.addElement(new ASN1Integer(this.iterations));
        }
        aSN1Sequence.addElement(aSN1Sequence3);
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        boolean bl = false;
        Enumeration enumeration = this.authSafes.elements();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[');
            stringBuffer.append(enumeration.nextElement().toString());
            stringBuffer.append(']');
            bl = true;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public boolean verify() throws AuthenticationException {
        try {
            if (this.macBytes == null) {
                this.computeMAC();
            }
            byte[] byArray = PKCS5.pkcs12PseudoRandomBytes((byte)3, MessageDigest.getInstance(this.macAlg).getDigestLength(), this.macAlg, this.passwd, this.macSalt, this.iterations.intValue());
            HMAC hMAC = new HMAC(this.macAlg, byArray);
            byte[] byArray2 = Utils.toBytes(new ASN1Sequence(this.authSafes));
            byte[] byArray3 = hMAC.computeDigest(byArray2);
            return Utils.areEqual(this.macBytes, byArray3);
        }
        catch (CipherException cipherException) {
            throw new AuthenticationException(cipherException.toString());
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AuthenticationException(algorithmIdentifierException.toString());
        }
    }
}

