/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.CRL;
import com.phaos.cert.PKCS12Bag;
import com.phaos.cert.PKCS12Safe;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PKCS12CRLBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private CRL crl;
    private ASN1Sequence contents;

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe) {
        this.parent = pKCS12Safe;
    }

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.input(aSN1Sequence);
    }

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe, CRL cRL) {
        this(pKCS12Safe);
        this.crl = cRL;
    }

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public CRL getCRL() {
        return this.crl;
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.contents = null;
        try {
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence2.elementAt(0);
            if (!aSN1ObjectID.equals(ASN1Utils.pkcsID, 9, 23, 1)) {
                throw new IOException("Unsupported CRL type " + aSN1ObjectID);
            }
            ASN1GenericConstructed aSN1GenericConstructed2 = (ASN1GenericConstructed)aSN1Sequence2.elementAt(1);
            this.crl = new CRL(new UnsyncByteArrayInputStream(((ASN1OctetString)aSN1GenericConstructed2.elementAt(0)).getValue()));
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public int length() {
        return this.outputASN1().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 4));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 23, 1));
        aSN1Sequence2.addElement(new ASN1GenericConstructed(new ASN1OctetString(Utils.toBytes(this.crl)), 0));
        aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Sequence2, 0));
        ASN1Set aSN1Set = this.outputAttrsASN1();
        if (aSN1Set != null) {
            aSN1Sequence.addElement(aSN1Set);
        }
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    public void setCRL(CRL cRL) {
        this.crl = cRL;
        this.contents = null;
    }

    public String toString() {
        String string = "";
        if (this.friendlyName != null) {
            string = String.valueOf(string) + "friendlyName = \"" + this.friendlyName + "\", ";
        }
        if (this.localKeyID != null) {
            string = String.valueOf(string) + "localKeyID = " + Utils.toHexString(this.localKeyID) + ", ";
        }
        return String.valueOf(string) + this.crl.toString();
    }
}

