/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKCS12Bag;
import com.phaos.cert.PKCS12Safe;
import com.phaos.cert.X509;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PKCS12CertBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private X509 cert;
    private ASN1Sequence contents;

    public PKCS12CertBag(PKCS12Safe pKCS12Safe) {
        this.parent = pKCS12Safe;
    }

    public PKCS12CertBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.input(aSN1Sequence);
    }

    public PKCS12CertBag(PKCS12Safe pKCS12Safe, X509 x509) {
        this(pKCS12Safe);
        this.cert = x509;
    }

    public PKCS12CertBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public X509 getCert() {
        return this.cert;
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.contents = null;
        try {
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence2.elementAt(0);
            if (!aSN1ObjectID.equals(ASN1Utils.pkcsID, 9, 22, 1)) {
                throw new IOException("Unsupported certificate type " + aSN1ObjectID);
            }
            ASN1GenericConstructed aSN1GenericConstructed2 = (ASN1GenericConstructed)aSN1Sequence2.elementAt(1);
            this.cert = new X509(new UnsyncByteArrayInputStream(((ASN1OctetString)aSN1GenericConstructed2.elementAt(0)).getValue()));
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public int length() {
        return this.outputASN1().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 3));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 22, 1));
        aSN1Sequence2.addElement(new ASN1GenericConstructed(new ASN1OctetString(Utils.toBytes(this.cert)), 0));
        aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Sequence2, 0));
        ASN1Set aSN1Set = this.outputAttrsASN1();
        if (aSN1Set != null) {
            aSN1Sequence.addElement(aSN1Set);
        }
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    public void setCert(X509 x509) {
        this.cert = x509;
        this.contents = null;
    }

    public String toString() {
        String string = "";
        if (this.friendlyName != null) {
            string = String.valueOf(string) + "friendlyName = \"" + this.friendlyName + "\", ";
        }
        if (this.localKeyID != null) {
            string = String.valueOf(string) + "localKeyID = " + Utils.toHexString(this.localKeyID) + ", ";
        }
        return String.valueOf(string) + this.cert.toString();
    }
}

