/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKCS12Bag;
import com.phaos.cert.PKCS12Safe;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class PKCS12SafeContentsBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private Vector bags;
    private ASN1Sequence contents;

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe) {
        this.parent = pKCS12Safe;
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.input(aSN1Sequence);
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, Vector vector) {
        this(pKCS12Safe);
        this.bags = vector;
    }

    public void addBag(PKCS12Bag pKCS12Bag) {
        if (this.bags == null) {
            this.bags = new Vector();
        }
        this.bags.addElement(pKCS12Bag);
        this.contents = null;
    }

    public Vector getBags() {
        return this.bags;
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        try {
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
            this.bags = new Vector();
            int n = 0;
            int n2 = aSN1Sequence2.size();
            while (n < n2) {
                this.bags.addElement(PKCS12Bag.inputBag(null, (ASN1Sequence)aSN1Sequence2.elementAt(n)));
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
        this.contents = null;
    }

    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public int length() {
        return this.outputASN1().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 6));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence(this.bags);
        aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Sequence2, 0));
        ASN1Set aSN1Set = this.outputAttrsASN1();
        if (aSN1Set != null) {
            aSN1Sequence.addElement(aSN1Set);
        }
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    public void setBags(Vector vector) {
        this.bags = vector;
        this.contents = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.friendlyName != null) {
            stringBuffer.append("friendlyName = \"" + this.friendlyName + "\", ");
        }
        if (this.localKeyID != null) {
            stringBuffer.append("localKeyID = " + Utils.toHexString(this.localKeyID) + ", ");
        }
        stringBuffer.append("bags = {");
        int n = 0;
        int n2 = this.bags.size();
        while (n < n2) {
            stringBuffer.append(this.bags.elementAt(n).toString());
            if (n != n2 - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

