/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Date;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509ExtensionSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class RevokedCertificate
implements ASN1Object {
    private BigInteger serialNo;
    private Date revocationDate;
    private X509ExtensionSet extensions = null;
    private ASN1Sequence seq = null;

    public RevokedCertificate(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public RevokedCertificate(BigInteger bigInteger, Date date) {
        this.serialNo = bigInteger;
        this.revocationDate = date;
    }

    public RevokedCertificate(BigInteger bigInteger, Date date, X509ExtensionSet x509ExtensionSet) {
        this(bigInteger, date);
        if (x509ExtensionSet != null && x509ExtensionSet.size() > 0) {
            this.extensions = x509ExtensionSet;
        }
    }

    public RevokedCertificate(BigInteger bigInteger, Date date, Vector vector) {
        this(bigInteger, date);
        if (vector != null && vector.size() > 0) {
            this.extensions = new X509ExtensionSet(vector);
        }
    }

    public void addExtension(X509Extension x509Extension) {
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(x509Extension);
    }

    public Enumeration extensionTypes() {
        return this.extensions != null ? this.extensions.types() : null;
    }

    public X509Extension getExtension(ASN1ObjectID aSN1ObjectID) {
        return this.extensions != null ? this.extensions.getExtension(aSN1ObjectID) : null;
    }

    public X509ExtensionSet getExtensionSet() {
        return this.extensions;
    }

    public Vector getExtensions() {
        return this.extensions != null ? this.extensions.getExtensions() : null;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public void input(InputStream inputStream) throws IOException {
        this.reset();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.serialNo = new ASN1Integer(aSN1SequenceInputStream).getValue();
        this.revocationDate = new ASN1Date(aSN1SequenceInputStream).getValue();
        this.extensions = aSN1SequenceInputStream.hasMoreData() ? new X509ExtensionSet(aSN1SequenceInputStream) : null;
        aSN1SequenceInputStream.terminate();
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(this.getSerialNo()));
            aSN1Sequence.addElement(new ASN1Date(this.getRevocationDate()));
            if (this.extensions != null && this.extensions.size() > 0) {
                aSN1Sequence.addElement(this.extensions);
            }
            this.seq = aSN1Sequence;
        }
        return this.seq;
    }

    public String toString() {
        String string = "serialNo = " + this.serialNo + ", revocationDate = " + this.revocationDate;
        if (this.extensions != null && this.extensions.size() > 0) {
            string = String.valueOf(string) + ", extensions = " + this.extensions;
        }
        return string;
    }
}

