/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.cert.CRL;
import com.phaos.cert.CertificateTrustPolicy;
import com.phaos.cert.CertificateVerifier;
import com.phaos.cert.IssuerAndSerialNo;
import com.phaos.cert.PKIX;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.cert.extension.BasicConstraintsExtension;
import com.phaos.crypto.AuthenticationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TrustedCAPolicy
implements CertificateTrustPolicy {
    private boolean requireCRL = false;
    private boolean requireCA = true;
    private Hashtable trustedTable = new Hashtable();

    public TrustedCAPolicy() {
    }

    public TrustedCAPolicy(Vector vector, boolean bl, boolean bl2) {
        this.setTrustedCAs(vector);
        this.requireCRL = bl;
        this.requireCA = bl2;
    }

    public void addTrustedCA(X509 x509) {
        this.trustedTable.put(x509.getSubject(), x509);
    }

    public boolean getRequireCAFlag() {
        return this.requireCA;
    }

    public boolean getRequireCRLs() {
        return this.requireCRL;
    }

    public CertificateVerifier makeCertificateVerifier(Vector vector, Vector vector2) {
        return new TrustedCACertificateVerifier(vector, vector2);
    }

    public void setRequireCAFlag(boolean bl) {
        this.requireCA = bl;
    }

    public void setRequireCRLs(boolean bl) {
        this.requireCRL = bl;
    }

    public void setTrustedCAs(Vector vector) {
        this.trustedTable.clear();
        if (vector == null) {
            return;
        }
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            X509 x509 = (X509)vector.elementAt(n);
            this.trustedTable.put(x509.getSubject(), x509);
            ++n;
        }
    }

    public Enumeration trustedCAs() {
        return this.trustedTable.elements();
    }

    class TrustedCACertificateVerifier
    implements CertificateVerifier {
        private Hashtable iasnTable = new Hashtable();
        private Hashtable subjectTable = new Hashtable();
        private Hashtable crlTable = new Hashtable();

        TrustedCACertificateVerifier(Vector vector, Vector vector2) {
            ASN1Object aSN1Object;
            int n;
            int n2;
            if (vector != null) {
                n2 = 0;
                n = vector.size();
                while (n2 < n) {
                    aSN1Object = (X509)vector.elementAt(n2);
                    IssuerAndSerialNo issuerAndSerialNo = new IssuerAndSerialNo((X509)aSN1Object);
                    this.iasnTable.put(issuerAndSerialNo, aSN1Object);
                    this.subjectTable.put(((X509)aSN1Object).getSubject(), aSN1Object);
                    ++n2;
                }
            }
            if (vector2 != null) {
                n2 = 0;
                n = vector2.size();
                while (n2 < n) {
                    aSN1Object = (CRL)vector2.elementAt(n2);
                    this.crlTable.put(((CRL)aSN1Object).getIssuer(), aSN1Object);
                    ++n2;
                }
            }
        }

        public X509 getValidCertificate(IssuerAndSerialNo issuerAndSerialNo) throws AuthenticationException {
            Object object;
            X509 x509 = (X509)this.iasnTable.get(issuerAndSerialNo);
            if (x509 == null) {
                return null;
            }
            if (TrustedCAPolicy.this.trustedTable.containsKey(x509.getSubject())) {
                return x509;
            }
            Vector<X509> vector = new Vector<X509>();
            X500Name x500Name = null;
            while (x509 != null) {
                object = this.subjectTable.get(x509.getIssuer());
                if (object != null && vector.contains(object)) {
                    throw new AuthenticationException("Chain does not terminate with a trusted CA");
                }
                vector.addElement(x509);
                x500Name = x509.getIssuer();
                x509 = (X509)this.subjectTable.get(x500Name);
                if (TrustedCAPolicy.this.trustedTable.containsKey(x500Name)) break;
                if (x509 != null) continue;
                throw new AuthenticationException("Chain does not terminate with a trusted CA");
            }
            object = (X509)TrustedCAPolicy.this.trustedTable.get(x500Name);
            boolean bl = false;
            while (!vector.isEmpty()) {
                BasicConstraintsExtension basicConstraintsExtension;
                x509 = (X509)vector.lastElement();
                CRL cRL = (CRL)this.crlTable.get(((X509)object).getSubject());
                x509.setIssuerCertificate((X509)object);
                if (cRL != null) {
                    x509.setIssuerCRL(cRL);
                } else if (TrustedCAPolicy.this.requireCRL) {
                    throw new AuthenticationException("CRL not found for certificate");
                }
                if (TrustedCAPolicy.this.requireCA && bl && ((basicConstraintsExtension = (BasicConstraintsExtension)((X509)object).getExtension(PKIX.id_ce_basicConstraints)) == null || !basicConstraintsExtension.getCA())) {
                    throw new AuthenticationException("Certificate is not a CA");
                }
                if (!x509.verify()) {
                    throw new AuthenticationException("Certificate invalid");
                }
                object = x509;
                vector.removeElementAt(vector.size() - 1);
                bl = true;
            }
            return x509;
        }
    }
}

