/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.GeneralName;
import com.phaos.cert.PKIX;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509ExtensionSet;
import com.phaos.cert.extension.AuthorityKeyIDExtension;
import com.phaos.cert.extension.BasicConstraintsExtension;
import com.phaos.cert.extension.CRLNumberExtension;
import com.phaos.cert.extension.CertificatePoliciesExtension;
import com.phaos.cert.extension.KeyUsageExtension;
import com.phaos.cert.extension.NetscapeCertTypeExtension;
import com.phaos.cert.extension.SubjectKeyIDExtension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class X509Attributes {
    public static final int CERTIFICATE = 0;
    public static final int CR_LIST = 1;
    public static final int OTHER = 2;
    private boolean CA;
    private boolean CACritical;
    private boolean CADefined;
    public static final int DIGITAL_SIGNATURE = 1;
    public static final int NON_REPUDIATION = 2;
    public static final int KEY_ENCIPHERMENT = 4;
    public static final int DATA_ENCIPHERMENT = 8;
    public static final int KEY_AGREEMENT = 16;
    public static final int KEY_CERT_SIGN = 32;
    public static final int CRL_SIGN = 64;
    public static final int ENCIPHER_ONLY = 128;
    public static final int DECIPHER_ONLY = 256;
    private int keyUsage;
    private boolean kuCritical;
    private boolean kuDefined;
    private Vector certificatePolicies;
    private boolean cpCritical;
    private boolean cpDefined;
    private byte[] authorityKeyID;
    private X500Name authorityKeyIssuer;
    private BigInteger authorityKeySerial;
    private boolean akidCritical;
    private boolean akidIsnDefined;
    private boolean akidIdDefined;
    private byte[] subjectKeyID;
    private boolean skidCritical;
    private boolean skidDefined;
    public static final int NETSCAPE_SSL_CLIENT = 1;
    public static final int NETSCAPE_SSL_SERVER = 2;
    public static final int NETSCAPE_EMAIL = 4;
    public static final int NETSCAPE_OBJECT_SIGNER = 8;
    public static final int NETSCAPE_SSL_CA = 32;
    public static final int NETSCAPE_EMAIL_CA = 64;
    public static final int NETSCAPE_CODE_SIGNING_CA = 128;
    private int netscapeCertType;
    private boolean nctCritical;
    private boolean nctDefined;
    public static final int SET_CARD = 1;
    public static final int SET_MER = 2;
    public static final int SET_PGWY = 4;
    public static final int SET_CCA = 8;
    public static final int SET_MCA = 16;
    public static final int SET_PCA = 32;
    public static final int SET_GCA = 64;
    public static final int SET_BCA = 128;
    public static final int SET_RCA = 256;
    public static final int SET_ACQ = 512;
    private int setCertType;
    private boolean sctCritical;
    private boolean sctDefined;
    private BigInteger CRLNumber;
    private boolean crlnCritical;
    private boolean crlnDefined;
    private Vector genericExts;

    public void addGenericExt(X509Extension x509Extension) {
        if (this.genericExts == null) {
            this.genericExts = new Vector();
        }
        this.genericExts.addElement(x509Extension);
    }

    private void check(boolean bl) throws IllegalStateException {
        if (!bl) {
            throw new IllegalStateException("Attempt to access an undefined attribute");
        }
    }

    public static X509Attributes fromExtensionSet(X509ExtensionSet x509ExtensionSet, int n) {
        X509Attributes x509Attributes = new X509Attributes();
        Enumeration enumeration = x509ExtensionSet.getExtensions().elements();
        while (enumeration.hasMoreElements()) {
            X509Extension x509Extension;
            X509Extension x509Extension2 = (X509Extension)enumeration.nextElement();
            ASN1ObjectID aSN1ObjectID = x509Extension2.getType();
            if (n == 0 && aSN1ObjectID.equals(PKIX.id_ce_basicConstraints)) {
                x509Attributes.CADefined = true;
                x509Attributes.CACritical = x509Extension2.getCritical();
                x509Attributes.CA = ((BasicConstraintsExtension)x509Extension2).getCA();
                continue;
            }
            if (n == 0 && aSN1ObjectID.equals(PKIX.id_ce_keyUsage)) {
                x509Attributes.kuDefined = true;
                x509Attributes.kuCritical = x509Extension2.getCritical();
                x509Extension = (KeyUsageExtension)x509Extension2;
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(0)) {
                    x509Attributes.keyUsage |= 1;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(1)) {
                    x509Attributes.keyUsage |= 2;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(2)) {
                    x509Attributes.keyUsage |= 4;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(3)) {
                    x509Attributes.keyUsage |= 8;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(4)) {
                    x509Attributes.keyUsage |= 0x10;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(5)) {
                    x509Attributes.keyUsage |= 0x20;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(6)) {
                    x509Attributes.keyUsage |= 0x40;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(7)) {
                    x509Attributes.keyUsage |= 0x80;
                }
                if (!((KeyUsageExtension)x509Extension).hasUsageFlag(8)) continue;
                x509Attributes.keyUsage |= 0x100;
                continue;
            }
            if (n == 0 && aSN1ObjectID.equals(PKIX.id_ce_certificatePolicies)) {
                x509Attributes.cpDefined = true;
                x509Attributes.cpCritical = x509Extension2.getCritical();
                x509Attributes.certificatePolicies = ((CertificatePoliciesExtension)x509Extension2).getCertificatePolicies();
                continue;
            }
            if ((n == 0 || n == 1) && aSN1ObjectID.equals(PKIX.id_ce_authorityKeyIdentifier)) {
                x509Attributes.akidCritical = x509Extension2.getCritical();
                x509Extension = (AuthorityKeyIDExtension)x509Extension2;
                x509Attributes.authorityKeyID = ((AuthorityKeyIDExtension)x509Extension).getAuthorityKeyID();
                Enumeration enumeration2 = ((AuthorityKeyIDExtension)x509Extension).authorityCertIssuer();
                while (enumeration2 != null && enumeration2.hasMoreElements()) {
                    Object e = enumeration2.nextElement();
                    if (!(e instanceof X500Name)) continue;
                    x509Attributes.authorityKeyIssuer = (X500Name)e;
                    break;
                }
                x509Attributes.authorityKeySerial = ((AuthorityKeyIDExtension)x509Extension).getAuthorityCertSerialNo();
                if (x509Attributes.authorityKeyID != null) {
                    x509Attributes.akidIdDefined = true;
                }
                if (x509Attributes.authorityKeyIssuer == null || x509Attributes.authorityKeySerial == null) continue;
                x509Attributes.akidIsnDefined = true;
                continue;
            }
            if (n == 0 && aSN1ObjectID.equals(PKIX.id_ce_subjectKeyIdentifier)) {
                x509Attributes.skidDefined = true;
                x509Attributes.skidCritical = x509Extension2.getCritical();
                x509Attributes.subjectKeyID = ((SubjectKeyIDExtension)x509Extension2).getSubjectKeyID();
                continue;
            }
            if (n == 0 && aSN1ObjectID.equals(X509Extension.id_netscape_ce_type)) {
                x509Attributes.nctDefined = true;
                x509Attributes.nctCritical = x509Extension2.getCritical();
                x509Extension = (NetscapeCertTypeExtension)x509Extension2;
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(0)) {
                    x509Attributes.netscapeCertType |= 1;
                }
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(1)) {
                    x509Attributes.netscapeCertType |= 2;
                }
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(2)) {
                    x509Attributes.netscapeCertType |= 4;
                }
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(3)) {
                    x509Attributes.netscapeCertType |= 8;
                }
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(5)) {
                    x509Attributes.netscapeCertType |= 0x20;
                }
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(6)) {
                    x509Attributes.netscapeCertType |= 0x40;
                }
                if (!((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(7)) continue;
                x509Attributes.netscapeCertType |= 0x80;
                continue;
            }
            if (n == 0 && aSN1ObjectID.equals(X509Extension.id_set_ce_type)) {
                x509Attributes.sctDefined = true;
                x509Attributes.sctCritical = x509Extension2.getCritical();
                try {
                    x509Attributes.setCertType = new ASN1BitString(new UnsyncByteArrayInputStream(x509Extension2.getValue())).intValue();
                }
                catch (IOException iOException) {
                    x509Attributes.setCertType = 0;
                }
                continue;
            }
            if (n == 1 && aSN1ObjectID.equals(PKIX.id_ce_cRLNumber)) {
                x509Attributes.crlnDefined = true;
                x509Attributes.crlnCritical = x509Extension2.getCritical();
                x509Attributes.CRLNumber = ((CRLNumberExtension)x509Extension2).getCRLNumber();
                continue;
            }
            x509Attributes.addGenericExt(x509Extension2);
        }
        return x509Attributes;
    }

    public byte[] getAuthorityKeyIdentifierID() {
        this.check(this.akidIdDefined);
        return this.authorityKeyID;
    }

    public X500Name getAuthorityKeyIdentifierIssuer() {
        this.check(this.akidIsnDefined);
        return this.authorityKeyIssuer;
    }

    public BigInteger getAuthorityKeyIdentifierSerialNo() {
        this.check(this.akidIsnDefined);
        return this.authorityKeySerial;
    }

    public boolean getCA() {
        this.check(this.CADefined);
        return this.CA;
    }

    public BigInteger getCRLNumber() {
        this.check(this.crlnDefined);
        return this.CRLNumber;
    }

    public Vector getCertificatePolicies() {
        this.check(this.cpDefined);
        return this.certificatePolicies;
    }

    public Vector getGenericExts() {
        return this.genericExts;
    }

    public int getKeyUsage() {
        this.check(this.kuDefined);
        return this.keyUsage;
    }

    public int getNetscapeCertType() {
        this.check(this.nctDefined);
        return this.netscapeCertType;
    }

    public int getSETCertType() {
        this.check(this.sctDefined);
        return this.setCertType;
    }

    public byte[] getSubjectKeyIdentifier() {
        this.check(this.skidDefined);
        return this.subjectKeyID;
    }

    public boolean isAuthorityKeyIdentifierCritical() {
        this.check(this.akidIsnDefined || this.akidIdDefined);
        return this.akidCritical;
    }

    public boolean isAuthorityKeyIdentifierDefined() {
        return this.akidIsnDefined || this.akidIdDefined;
    }

    public boolean isAuthorityKeyIdentifierIdDefined() {
        return this.akidIdDefined;
    }

    public boolean isAuthorityKeyIdentifierIsnDefined() {
        return this.akidIsnDefined;
    }

    public boolean isCACritical() {
        this.check(this.CADefined);
        return this.CACritical;
    }

    public boolean isCADefined() {
        return this.CADefined;
    }

    public boolean isCRLNumberCritical() {
        this.check(this.crlnDefined);
        return this.crlnCritical;
    }

    public boolean isCRLNumberDefined() {
        return this.crlnDefined;
    }

    public boolean isCertificatePoliciesCritical() {
        this.check(this.cpDefined);
        return this.cpCritical;
    }

    public boolean isCertificatePoliciesDefined() {
        return this.cpDefined;
    }

    public boolean isKeyUsageCritical() {
        this.check(this.kuDefined);
        return this.kuCritical;
    }

    public boolean isKeyUsageDefined() {
        return this.kuDefined;
    }

    public boolean isNetscapeCertTypeCritical() {
        this.check(this.nctDefined);
        return this.nctCritical;
    }

    public boolean isNetscapeCertTypeDefined() {
        return this.nctDefined;
    }

    public boolean isSETCertTypeCritical() {
        this.check(this.sctDefined);
        return this.sctCritical;
    }

    public boolean isSETCertTypeDefined() {
        return this.sctDefined;
    }

    public boolean isSubjectKeyIdentifierCritical() {
        this.check(this.skidDefined);
        return this.skidCritical;
    }

    public boolean isSubjectKeyIdentifierDefined() {
        return this.skidDefined;
    }

    public void setAuthorityKeyIdentifier(X500Name x500Name, BigInteger bigInteger) {
        this.setAuthorityKeyIdentifier(x500Name, bigInteger, false);
    }

    public void setAuthorityKeyIdentifier(X500Name x500Name, BigInteger bigInteger, boolean bl) {
        this.authorityKeyIssuer = x500Name;
        this.authorityKeySerial = bigInteger;
        this.akidCritical = bl;
        this.akidIsnDefined = true;
    }

    public void setAuthorityKeyIdentifier(X509 x509) {
        this.setAuthorityKeyIdentifier((X500Name)x509.getHolder(), x509.getSerialNo(), false);
    }

    public void setAuthorityKeyIdentifier(X509 x509, boolean bl) {
        this.setAuthorityKeyIdentifier((X500Name)x509.getHolder(), x509.getSerialNo(), bl);
    }

    public void setAuthorityKeyIdentifier(byte[] byArray) {
        this.setAuthorityKeyIdentifier(byArray, false);
    }

    public void setAuthorityKeyIdentifier(byte[] byArray, boolean bl) {
        this.authorityKeyID = byArray;
        this.akidCritical = bl;
        this.akidIdDefined = true;
    }

    public void setCA(boolean bl) {
        this.setCA(bl, true);
    }

    public void setCA(boolean bl, boolean bl2) {
        this.CA = bl;
        this.CACritical = bl2;
        this.CADefined = true;
    }

    public void setCRLNumber(BigInteger bigInteger) {
        this.setCRLNumber(bigInteger, false);
    }

    public void setCRLNumber(BigInteger bigInteger, boolean bl) {
        this.CRLNumber = bigInteger;
        this.crlnCritical = bl;
        this.crlnDefined = true;
    }

    public void setCertificatePolicies(Vector vector) {
        this.setCertificatePolicies(vector, false);
    }

    public void setCertificatePolicies(Vector vector, boolean bl) {
        this.certificatePolicies = vector;
        this.cpCritical = bl;
        this.cpDefined = true;
    }

    public void setGenericExts(Vector vector) {
        this.genericExts = vector;
    }

    public void setKeyUsage(int n) {
        this.setKeyUsage(n, true);
    }

    public void setKeyUsage(int n, boolean bl) {
        this.keyUsage = n;
        this.kuCritical = bl;
        this.kuDefined = true;
    }

    public void setNetscapeCertType(int n) {
        this.setNetscapeCertType(n, false);
    }

    public void setNetscapeCertType(int n, boolean bl) {
        this.netscapeCertType = n;
        this.nctCritical = bl;
        this.nctDefined = true;
    }

    public void setSETCertType(int n) {
        this.setSETCertType(n, true);
    }

    public void setSETCertType(int n, boolean bl) {
        this.setCertType = n;
        this.sctCritical = bl;
        this.sctDefined = true;
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        this.setSubjectKeyIdentifier(byArray, false);
    }

    public void setSubjectKeyIdentifier(byte[] byArray, boolean bl) {
        this.subjectKeyID = byArray;
        this.skidCritical = bl;
        this.skidDefined = true;
    }

    public static X509ExtensionSet toExtensionSet(X509Attributes x509Attributes) {
        Object object;
        X509ExtensionSet x509ExtensionSet = new X509ExtensionSet();
        if (x509Attributes.CADefined) {
            x509ExtensionSet.addExtension(new BasicConstraintsExtension(x509Attributes.CA, x509Attributes.CACritical));
        }
        if (x509Attributes.kuDefined) {
            object = new KeyUsageExtension(x509Attributes.kuCritical);
            if ((x509Attributes.keyUsage & 1) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(0);
            }
            if ((x509Attributes.keyUsage & 2) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(1);
            }
            if ((x509Attributes.keyUsage & 4) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(2);
            }
            if ((x509Attributes.keyUsage & 8) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(3);
            }
            if ((x509Attributes.keyUsage & 0x10) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(4);
            }
            if ((x509Attributes.keyUsage & 0x20) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(5);
            }
            if ((x509Attributes.keyUsage & 0x40) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(6);
            }
            if ((x509Attributes.keyUsage & 0x80) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(7);
            }
            if ((x509Attributes.keyUsage & 0x100) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(8);
            }
            x509ExtensionSet.addExtension((X509Extension)object);
        }
        if (x509Attributes.cpDefined) {
            x509ExtensionSet.addExtension(new CertificatePoliciesExtension(x509Attributes.certificatePolicies, x509Attributes.cpCritical));
        }
        if (x509Attributes.akidIdDefined) {
            x509ExtensionSet.addExtension(new AuthorityKeyIDExtension(x509Attributes.authorityKeyID, x509Attributes.akidCritical));
        } else if (x509Attributes.akidIsnDefined) {
            x509ExtensionSet.addExtension(new AuthorityKeyIDExtension(new GeneralName(x509Attributes.authorityKeyIssuer), x509Attributes.authorityKeySerial, x509Attributes.akidCritical));
        }
        if (x509Attributes.skidDefined) {
            x509ExtensionSet.addExtension(new SubjectKeyIDExtension(x509Attributes.subjectKeyID, x509Attributes.skidCritical));
        }
        if (x509Attributes.nctDefined) {
            object = new NetscapeCertTypeExtension(x509Attributes.nctCritical);
            if ((x509Attributes.netscapeCertType & 1) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(0);
            }
            if ((x509Attributes.netscapeCertType & 2) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(1);
            }
            if ((x509Attributes.netscapeCertType & 4) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(2);
            }
            if ((x509Attributes.netscapeCertType & 8) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(3);
            }
            if ((x509Attributes.netscapeCertType & 0x20) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(5);
            }
            if ((x509Attributes.netscapeCertType & 0x40) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(6);
            }
            if ((x509Attributes.netscapeCertType & 0x80) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(7);
            }
            x509ExtensionSet.addExtension((X509Extension)object);
        }
        if (x509Attributes.sctDefined) {
            x509ExtensionSet.addExtension(new X509Extension(X509Extension.id_set_ce_type, x509Attributes.sctCritical, new ASN1BitString(BigInteger.valueOf(x509Attributes.setCertType))));
        }
        if (x509Attributes.crlnDefined) {
            x509ExtensionSet.addExtension(new CRLNumberExtension(x509Attributes.CRLNumber, x509Attributes.crlnCritical));
        }
        if (x509Attributes.genericExts != null) {
            object = x509Attributes.genericExts.elements();
            while (object.hasMoreElements()) {
                x509ExtensionSet.addExtension((X509Extension)object.nextElement());
            }
        }
        return x509ExtensionSet;
    }

    public String toString() {
        int n;
        boolean bl;
        String[] stringArray;
        String string = "";
        if (this.CADefined) {
            string = String.valueOf(string) + ", CA = " + this.CA;
        }
        if (this.kuDefined) {
            stringArray = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};
            string = String.valueOf(string) + ", keyUsage = {";
            bl = false;
            n = 0;
            while (n < 7) {
                if ((this.keyUsage & 1 << n) != 0) {
                    if (bl) {
                        string = String.valueOf(string) + ", ";
                    }
                    bl = true;
                    string = String.valueOf(string) + stringArray[n];
                }
                ++n;
            }
            string = String.valueOf(string) + "}";
        }
        if (this.cpDefined) {
            string = String.valueOf(string) + ", certificatePolicies = " + this.certificatePolicies;
        }
        if (this.skidDefined) {
            string = String.valueOf(string) + ", subjectKeyIdentifier = " + Utils.toHexString(this.subjectKeyID);
        }
        if (this.akidIdDefined || this.akidIsnDefined) {
            string = String.valueOf(string) + ", authorityKeyIdentifier = ";
            string = this.akidIsnDefined ? String.valueOf(string) + "{issuer = " + this.authorityKeyIssuer + ", serialNo = " + this.authorityKeySerial + "}" : String.valueOf(string) + "{keyID = " + Utils.toHexString(this.authorityKeyID) + "}";
        }
        if (this.nctDefined) {
            stringArray = new String[]{"SSL-client", "SSL-server", "E-mail", "Object-Signer", "unknown4", "SSL-CA", "E-mail-CA", "Object-Signing-CA"};
            string = String.valueOf(string) + ", netscapeCertType = {";
            bl = false;
            n = 0;
            while (n < 8) {
                if ((this.netscapeCertType & 1 << n) != 0) {
                    if (bl) {
                        string = String.valueOf(string) + ", ";
                    }
                    bl = true;
                    string = String.valueOf(string) + stringArray[n];
                }
                ++n;
            }
            string = String.valueOf(string) + "}";
        }
        if (this.sctDefined) {
            stringArray = new String[]{"card", "mer", "pgwy", "cca", "mca", "pca", "gca", "bca", "rca", "acq"};
            string = String.valueOf(string) + ", setCertType = {";
            bl = false;
            n = 0;
            while (n < 10) {
                if ((this.setCertType & 1 << n) != 0) {
                    if (bl) {
                        string = String.valueOf(string) + ", ";
                    }
                    bl = true;
                    string = String.valueOf(string) + stringArray[n];
                }
                ++n;
            }
            string = String.valueOf(string) + "}";
        }
        if (this.crlnDefined) {
            string = String.valueOf(string) + ", CRLNumber = " + this.CRLNumber;
        }
        if (this.genericExts != null && this.genericExts.size() > 0) {
            string = String.valueOf(string) + ", genericExts = {";
            boolean bl2 = false;
            Enumeration enumeration = this.genericExts.elements();
            while (enumeration.hasMoreElements()) {
                if (bl2) {
                    string = String.valueOf(string) + ", ";
                } else {
                    bl2 = true;
                }
                string = String.valueOf(string) + "[" + (X509Extension)enumeration.nextElement() + "]";
            }
            string = String.valueOf(string) + "}";
        }
        if (string.length() > 0) {
            return string.substring(2);
        }
        return string;
    }
}

