/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.AuthorityInfoAccess;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public class AuthorityInfoAccessExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_pe_authorityInfoAccess;
    private AuthorityInfoAccess access;

    public AuthorityInfoAccessExtension() {
        super(TYPE);
    }

    public AuthorityInfoAccessExtension(AuthorityInfoAccess authorityInfoAccess) {
        this(authorityInfoAccess, false);
    }

    public AuthorityInfoAccessExtension(AuthorityInfoAccess authorityInfoAccess, boolean bl) {
        super(TYPE, bl);
        this.setAuthorityInfoAccess(authorityInfoAccess);
    }

    public AuthorityInfoAccessExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    private void decodeValue() {
        try {
            this.access = new AuthorityInfoAccess(new UnsyncByteArrayInputStream(this.getValue()));
            if (this.access.methodCount() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public AuthorityInfoAccess getAuthorityInfoAccess() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.access;
    }

    public void setAuthorityInfoAccess(AuthorityInfoAccess authorityInfoAccess) {
        this.access = authorityInfoAccess;
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(this.access);
        this.isDecoded = true;
        return byArray;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "authorityInfoAccessExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + this.getAuthorityInfoAccess() + "}";
    }
}

