/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1GenericPrimitive;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.GeneralName;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class AuthorityKeyIDExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_authorityKeyIdentifier;
    private byte[] keyID = null;
    private Vector issuer = null;
    private BigInteger serialNo = null;

    public AuthorityKeyIDExtension() {
        super(TYPE);
    }

    public AuthorityKeyIDExtension(GeneralName generalName, BigInteger bigInteger) {
        this(generalName, bigInteger, false);
    }

    public AuthorityKeyIDExtension(GeneralName generalName, BigInteger bigInteger, boolean bl) {
        super(TYPE, bl);
        this.issuer = new Vector();
        this.issuer.addElement(generalName);
        this.serialNo = bigInteger;
        this.setValue(this.toByteArray());
    }

    public AuthorityKeyIDExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public AuthorityKeyIDExtension(Vector vector, BigInteger bigInteger) {
        this(vector, bigInteger, false);
    }

    public AuthorityKeyIDExtension(Vector vector, BigInteger bigInteger, boolean bl) {
        super(TYPE, bl);
        this.issuer = vector;
        this.serialNo = bigInteger;
        this.setValue(this.toByteArray());
    }

    public AuthorityKeyIDExtension(byte[] byArray) {
        this(byArray, false);
    }

    public AuthorityKeyIDExtension(byte[] byArray, boolean bl) {
        super(TYPE, bl);
        this.keyID = byArray;
        this.setValue(this.toByteArray());
    }

    public Enumeration authorityCertIssuer() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuer != null ? this.issuer.elements() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (aSN1SequenceInputStream.getCurrentTag() == 0) {
                aSN1SequenceInputStream.setCurrentTag(4);
                this.keyID = ASN1OctetString.inputValue(aSN1SequenceInputStream);
            } else {
                this.keyID = null;
            }
            if (this.keyID == null || aSN1SequenceInputStream.hasMoreData()) {
                if (aSN1SequenceInputStream.getCurrentTag() != 1) throw new ASN1FormatException("Malformed extension contents");
                aSN1SequenceInputStream.setCurrentTag(16);
                ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
                this.issuer = new Vector();
                while (aSN1SequenceInputStream2.hasMoreData()) {
                    this.issuer.addElement(new GeneralName(aSN1SequenceInputStream2));
                }
                aSN1SequenceInputStream2.terminate();
                if (aSN1SequenceInputStream.getCurrentTag() != 2) throw new ASN1FormatException("Malformed extension contents");
                aSN1SequenceInputStream.setCurrentTag(2);
                this.serialNo = ASN1Integer.inputValue(aSN1SequenceInputStream);
            } else {
                this.issuer = null;
                this.serialNo = null;
            }
            aSN1SequenceInputStream.terminate();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public BigInteger getAuthorityCertSerialNo() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.serialNo;
    }

    public byte[] getAuthorityKeyID() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyID;
    }

    private byte[] toByteArray() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.keyID != null) {
            aSN1Sequence.addElement(new ASN1GenericPrimitive(this.keyID, 0));
        }
        if (this.issuer != null && this.serialNo != null) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(this.issuer, 1));
            aSN1Sequence.addElement(new ASN1GenericPrimitive(new ASN1Integer(this.serialNo), 2));
        }
        byte[] byArray = Utils.toBytes(aSN1Sequence);
        this.isDecoded = true;
        return byArray;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("authorityKeyIDExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl = false;
        if (this.getAuthorityKeyID() != null) {
            stringBuffer.append("keyID = " + Utils.toHexString(this.getAuthorityKeyID()));
            bl = true;
        }
        if (this.getAuthorityCertSerialNo() != null) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("serialNo = " + this.getAuthorityCertSerialNo());
            bl = true;
        }
        if (this.issuer != null) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("issuer = {");
            boolean bl2 = false;
            int n = 0;
            int n2 = this.issuer.size();
            while (n < n2) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((GeneralName)this.issuer.elementAt(n)).toString());
                bl2 = true;
                ++n;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

