/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.GeneralName;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class CRLCertificateIssuerExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_certificateIssuer;
    private Vector certificateIssuer = new Vector();

    public CRLCertificateIssuerExtension() {
        super(TYPE);
    }

    public CRLCertificateIssuerExtension(GeneralName generalName) {
        this(generalName, true);
    }

    public CRLCertificateIssuerExtension(GeneralName generalName, boolean bl) {
        super(TYPE, bl);
        this.certificateIssuer.addElement(generalName);
        this.setValue(this.toByteArray());
    }

    public CRLCertificateIssuerExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public CRLCertificateIssuerExtension(Vector vector) {
        this(vector, true);
    }

    public CRLCertificateIssuerExtension(Vector vector, boolean bl) {
        super(TYPE, bl);
        this.certificateIssuer = vector;
        this.setValue(this.toByteArray());
    }

    public void addIssuerName(GeneralName generalName) {
        this.certificateIssuer.addElement(generalName);
        this.setValue(this.toByteArray());
    }

    public Enumeration certificateIssuer() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certificateIssuer.elements();
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            this.certificateIssuer = new Vector();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.certificateIssuer.addElement(new GeneralName(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.certificateIssuer.size() == 0) {
                throw new ASN1FormatException("No GeneralName defined for extension");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence(this.certificateIssuer));
        this.isDecoded = true;
        return byArray;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("CRLCertificateIssuerExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.certificateIssuer != null) {
            stringBuffer.append("certificateIssuers = {");
            boolean bl = false;
            int n = 0;
            int n2 = this.certificateIssuer.size();
            while (n < n2) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((GeneralName)this.certificateIssuer.elementAt(n)).toString());
                bl = true;
                ++n;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

