/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.CRLDistPoint;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class CRLDistPointExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_cRLDistributionPoints;
    private Vector distPoint = new Vector();

    public CRLDistPointExtension() {
        super(TYPE);
    }

    public CRLDistPointExtension(CRLDistPoint cRLDistPoint) {
        this(cRLDistPoint, false);
    }

    public CRLDistPointExtension(CRLDistPoint cRLDistPoint, boolean bl) {
        super(TYPE, bl);
        this.addCRLDistPoint(cRLDistPoint);
    }

    public CRLDistPointExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public void addCRLDistPoint(CRLDistPoint cRLDistPoint) {
        this.distPoint.addElement(cRLDistPoint);
        this.setValue(this.toByteArray());
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (this.distPoint == null) {
                this.distPoint = new Vector();
            } else {
                this.distPoint.removeAllElements();
            }
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.distPoint.addElement(new CRLDistPoint(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.distPoint.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public Vector getCRLDistPoints() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.distPoint;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence(this.distPoint));
        this.isDecoded = true;
        return byArray;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("crlDistPointExtension { oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.getCRLDistPoints() != null) {
            stringBuffer.append("CRLDistributionPoints = { ");
            boolean bl = false;
            int n = 0;
            int n2 = this.getCRLDistPoints().size();
            while (n < n2) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((CRLDistPoint)this.getCRLDistPoints().elementAt(n)).toString());
                bl = true;
                ++n;
            }
            stringBuffer.append(" }");
        }
        stringBuffer.append("] }");
        return stringBuffer.toString();
    }
}

