/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public class CRLHoldInstructionExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_holdInstructionCode;
    private ASN1ObjectID holdInstruction = null;

    public CRLHoldInstructionExtension() {
        super(TYPE);
    }

    public CRLHoldInstructionExtension(ASN1ObjectID aSN1ObjectID) {
        this(aSN1ObjectID, false);
    }

    public CRLHoldInstructionExtension(ASN1ObjectID aSN1ObjectID, boolean bl) {
        super(TYPE, bl);
        this.holdInstruction = aSN1ObjectID;
        this.setValue(this.toByteArray());
    }

    public CRLHoldInstructionExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    private void decodeValue() {
        try {
            this.holdInstruction = new ASN1ObjectID(new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public ASN1ObjectID getHoldInstruction() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.holdInstruction;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(this.holdInstruction);
        this.isDecoded = true;
        return byArray;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "CRLHoldInstructionExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + this.getHoldInstruction() + "}";
    }
}

