/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1Date;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class CRLInvalidityDateExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_invalidityDate;
    private Date invalidityDate = null;

    public CRLInvalidityDateExtension() {
        super(TYPE);
    }

    public CRLInvalidityDateExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public CRLInvalidityDateExtension(Date date) {
        this(date, false);
    }

    public CRLInvalidityDateExtension(Date date, boolean bl) {
        super(TYPE, bl);
        this.invalidityDate = date;
        this.setValue(this.toByteArray());
    }

    private void decodeValue() {
        try {
            this.invalidityDate = ASN1Date.inputValue(new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public Date getInvalidityDate() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.invalidityDate;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Date(this.invalidityDate, true));
        this.isDecoded = true;
        return byArray;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "CRLInvalidityDateExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + this.getInvalidityDate() + "}";
    }
}

