/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.CRLReason;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public class CRLReasonExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_cRLReason;
    private CRLReason reason = null;

    public CRLReasonExtension() {
        super(TYPE);
    }

    public CRLReasonExtension(CRLReason cRLReason) {
        this(cRLReason, false);
    }

    public CRLReasonExtension(CRLReason cRLReason, boolean bl) {
        super(TYPE, bl);
        this.reason = cRLReason;
        this.setValue(this.toByteArray());
    }

    public CRLReasonExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    private void decodeValue() {
        try {
            this.reason = new CRLReason(new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public CRLReason getReason() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.reason;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(this.reason);
        this.isDecoded = true;
        return byArray;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "CRLReasonExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", reason = " + this.getReason() + "}";
    }
}

