/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509PolicyInformation;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class CertificatePoliciesExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_certificatePolicies;
    private Vector certPolicies;

    public CertificatePoliciesExtension() {
        super(TYPE);
    }

    public CertificatePoliciesExtension(X509PolicyInformation x509PolicyInformation) {
        this(x509PolicyInformation, false);
    }

    public CertificatePoliciesExtension(X509PolicyInformation x509PolicyInformation, boolean bl) {
        super(TYPE, bl);
        this.certPolicies = new Vector();
        this.certPolicies.addElement(x509PolicyInformation);
        this.setValue(this.toByteArray());
    }

    public CertificatePoliciesExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public CertificatePoliciesExtension(Vector vector) {
        this(vector, false);
    }

    public CertificatePoliciesExtension(Vector vector, boolean bl) {
        super(TYPE, bl);
        this.certPolicies = vector;
        this.setValue(this.toByteArray());
    }

    public void addCertificatePolicy(X509PolicyInformation x509PolicyInformation) {
        if (this.certPolicies == null) {
            this.certPolicies = new Vector();
        }
        this.certPolicies.addElement(x509PolicyInformation);
        this.setValue(this.toByteArray());
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            this.certPolicies = new Vector();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.certPolicies.addElement(new X509PolicyInformation(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.certPolicies.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public Vector getCertificatePolicies() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certPolicies;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence(this.certPolicies));
        this.isDecoded = true;
        return byArray;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("certificatePoliciesExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.getCertificatePolicies() != null) {
            stringBuffer.append("certificatePolicies = {");
            boolean bl = false;
            int n = 0;
            int n2 = this.getCertificatePolicies().size();
            while (n < n2) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((X509PolicyInformation)this.getCertificatePolicies().elementAt(n)).toString());
                bl = true;
                ++n;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

