/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public class NetscapeCertTypeExtension
extends X509Extension {
    public static final int SSL_CLIENT = 0;
    public static final int SSL_SERVER = 1;
    public static final int SMIME = 2;
    public static final int OBJECT_SIGNING = 3;
    public static final int SSL_CA = 5;
    public static final int SMIME_CA = 6;
    public static final int OBJECT_SIGNING_CA = 7;
    private static final int RESERVED = 4;
    private static final int[] LIST;
    private static final String[] description;
    private static final ASN1ObjectID TYPE;
    private boolean[] certUsage = new boolean[LIST.length];

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        LIST = nArray;
        description = new String[]{"SSL CLIENT", "SSL SERVER", "SMIME", "OBJECT SIGNING", "RESERVED", "SSL_CA", "SMIME CA", "OBJECT SIGNING_CA"};
        TYPE = X509Extension.id_netscape_ce_type;
    }

    public NetscapeCertTypeExtension() {
        super(TYPE);
    }

    public NetscapeCertTypeExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public NetscapeCertTypeExtension(boolean bl) {
        super(TYPE, bl);
        this.setValue(this.toByteArray());
    }

    public NetscapeCertTypeExtension(int[] nArray, boolean bl) {
        super(TYPE, bl);
        this.setUsageFlags(nArray);
    }

    public void clearAllUsageFlags() {
        if (this.certUsage != null) {
            int n = 0;
            int n2 = this.certUsage.length;
            while (n < n2) {
                this.certUsage[n] = false;
                ++n;
            }
            this.setValue(this.toByteArray());
        }
    }

    public void clearUsageFlag(int n) {
        if (this.certUsage != null && n < this.certUsage.length) {
            this.certUsage[n] = false;
        }
        this.setValue(this.toByteArray());
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1BitString aSN1BitString = new ASN1BitString(unsyncByteArrayInputStream);
            this.certUsage = new boolean[aSN1BitString.bitLength()];
            int n = 0;
            try {
                while (n < this.certUsage.length) {
                    this.certUsage[n] = aSN1BitString.testBit(n);
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ASN1FormatException("Unknown cert usage flag: " + n);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    private void doSetUsageFlag(int n) {
        if (this.certUsage == null || this.certUsage.length < LIST.length) {
            boolean[] blArray = new boolean[LIST.length];
            if (this.certUsage != null) {
                System.arraycopy(this.certUsage, 0, blArray, 0, this.certUsage.length);
            }
            this.certUsage = blArray;
        }
        this.certUsage[n] = true;
    }

    public boolean hasUsageFlag(int n) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certUsage != null && n < this.certUsage.length ? this.certUsage[n] : false;
    }

    public void setUsageFlag(int n) {
        this.doSetUsageFlag(n);
        this.setValue(this.toByteArray());
    }

    public void setUsageFlags(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            this.doSetUsageFlag(nArray[n]);
            ++n;
        }
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        ASN1BitString aSN1BitString = new ASN1BitString(this.certUsage.length);
        int n = 0;
        while (n < this.certUsage.length) {
            if (this.certUsage[n]) {
                aSN1BitString.setBit(n);
            }
            ++n;
        }
        byte[] byArray = Utils.toBytes(aSN1BitString);
        this.isDecoded = true;
        return byArray;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("netscapeCertTypeExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl = false;
        int n = 0;
        while (n < LIST.length) {
            if (this.hasUsageFlag(n)) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(description[n]);
                bl = true;
            }
            ++n;
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

