/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AlgorithmIdentifier
implements ASN1Object,
Cloneable {
    private ASN1ObjectID oid;
    private ASN1Object parameters;
    private ASN1Sequence contents;

    protected AlgorithmIdentifier() {
    }

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID) {
        this(aSN1ObjectID, true);
    }

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this.oid = aSN1ObjectID;
        this.parameters = aSN1Object;
    }

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, boolean bl) {
        this.oid = aSN1ObjectID;
        this.parameters = bl ? new ASN1Null() : null;
    }

    public AlgorithmIdentifier(ASN1Sequence aSN1Sequence) throws ASN1FormatException {
        this.input(aSN1Sequence);
    }

    public AlgorithmIdentifier(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public Object clone() {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier();
        if (this.oid != null) {
            int[] nArray = (int[])this.oid.getValue().clone();
            algorithmIdentifier.oid = new ASN1ObjectID(nArray);
        }
        try {
            if (this.parameters != null) {
                algorithmIdentifier.parameters = ASN1Utils.inputASN1Object(Utils.toStream(this.parameters));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier parameters to stream: " + iOException.getMessage());
        }
        try {
            if (this.contents != null) {
                algorithmIdentifier.contents = new ASN1Sequence(Utils.toStream(this.contents));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier contents to stream: " + iOException.getMessage());
        }
        return algorithmIdentifier;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AlgorithmIdentifier)) {
            return false;
        }
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)object;
        if (!this.oid.equals(algorithmIdentifier.getOID())) {
            return false;
        }
        if (this.parameters == null || this.parameters instanceof ASN1Null) {
            return algorithmIdentifier.getParameters() == null || algorithmIdentifier.getParameters() instanceof ASN1Null;
        }
        if (algorithmIdentifier.parameters == null || algorithmIdentifier.parameters instanceof ASN1Null) {
            return false;
        }
        return Utils.areEqual(Utils.toBytes(this.parameters), Utils.toBytes(algorithmIdentifier.getParameters()));
    }

    public ASN1ObjectID getOID() {
        return this.oid;
    }

    public ASN1Object getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return this.oid.hashCode() + (this.parameters == null || this.parameters instanceof ASN1Null ? 0 : Utils.hashBytes(this.parameters));
    }

    private void input(ASN1Sequence aSN1Sequence) throws ASN1FormatException {
        try {
            this.oid = (ASN1ObjectID)aSN1Sequence.elementAt(0);
            this.parameters = aSN1Sequence.size() == 1 ? null : aSN1Sequence.elementAt(1);
            this.contents = null;
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ASN1FormatException(arrayIndexOutOfBoundsException.toString());
        }
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        this.input(aSN1Sequence);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.oid);
            if (this.parameters != null) {
                aSN1Sequence.addElement(this.parameters);
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    public String toString() {
        return "{ oid = " + this.oid.toStringCompact() + ", parameters = " + this.parameters + " }";
    }
}

