/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Padding;
import com.phaos.crypto.SymmetricKey;

public abstract class BlockCipher
extends Cipher {
    protected byte[] iv;
    private byte[] lastCipherBlock;
    protected int blockSize;
    protected Padding.ID paddingID;

    protected BlockCipher() {
        this.blockSize = 0;
        this.mode = 0;
        this.paddingID = Padding.NONE;
    }

    protected BlockCipher(int n) {
        this.blockSize = n;
        this.mode = 0;
        this.paddingID = Padding.NONE;
    }

    public final int blockSize() {
        return this.blockSize;
    }

    public byte[] decrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        this.assertDecryption();
        if (n2 % this.blockSize != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        byte[] byArray2 = new byte[n2];
        this.decrypt(byArray, n, n2, byArray2, 0);
        if (bl) {
            return BlockCipher.unpad(this.paddingID, this.blockSize, byArray2);
        }
        return byArray2;
    }

    public void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.assertDecryption();
        if (n2 % this.blockSize != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        if (this.mode == 0) {
            int n4 = n;
            int n5 = n3;
            while (n4 < n + n2) {
                this.decryptBlock(byArray, n4, byArray2, n5);
                n4 += this.blockSize;
                n5 += this.blockSize;
            }
        } else {
            int n6 = n;
            int n7 = n3;
            while (n6 < n + n2) {
                this.decryptBlock(byArray, n6, byArray2, n7);
                int n8 = 0;
                while (n8 < this.blockSize) {
                    int n9 = n7 + n8;
                    byArray2[n9] = (byte)(byArray2[n9] ^ this.lastCipherBlock[n8]);
                    ++n8;
                }
                System.arraycopy(byArray, n6, this.lastCipherBlock, 0, this.blockSize);
                n6 += this.blockSize;
                n7 += this.blockSize;
            }
        }
    }

    protected abstract void decryptBlock(byte[] var1, int var2, byte[] var3, int var4) throws CipherException;

    public byte[] encrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        this.assertEncryption();
        if (bl) {
            byArray = BlockCipher.pad(this.paddingID, this.blockSize, byArray, n, n2);
            n = 0;
            n2 = byArray.length;
        } else if (n2 % this.blockSize != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        byte[] byArray2 = new byte[n2];
        this.encrypt(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    public void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.assertEncryption();
        if (n2 % this.blockSize != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        if (this.mode == 0) {
            int n4 = n;
            int n5 = n3;
            while (n4 < n + n2) {
                this.encryptBlock(byArray, n4, byArray2, n5);
                n4 += this.blockSize;
                n5 += this.blockSize;
            }
        } else {
            int n6 = n;
            int n7 = n3;
            while (n6 < n + n2) {
                int n8 = 0;
                while (n8 < this.blockSize) {
                    int n9 = n8;
                    this.lastCipherBlock[n9] = (byte)(this.lastCipherBlock[n9] ^ byArray[n6 + n8]);
                    ++n8;
                }
                this.encryptBlock(this.lastCipherBlock, 0, byArray2, n7);
                System.arraycopy(byArray2, n7, this.lastCipherBlock, 0, this.blockSize);
                n6 += this.blockSize;
                n7 += this.blockSize;
            }
        }
    }

    protected abstract void encryptBlock(byte[] var1, int var2, byte[] var3, int var4) throws CipherException;

    public void erase() {
        super.erase();
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final byte[] getIV() {
        if (this.iv == null) {
            return null;
        }
        return (byte[])this.iv.clone();
    }

    public int getPadding() {
        return this.paddingID.getValue();
    }

    public final Padding.ID getPaddingID() {
        return this.paddingID;
    }

    public abstract void initialize(AlgorithmIdentifier var1, SymmetricKey var2, Padding.ID var3) throws AlgorithmIdentifierException, InvalidKeyException, CipherException;

    static byte[] pad(Padding.ID iD, int n, byte[] byArray, int n2, int n3) throws CipherException {
        if (iD == Padding.PKCS5) {
            if (n < 0 || n > 255) {
                throw new CipherException("Block size must be between 0 and 255");
            }
            byte by = (byte)(n - n3 % n);
            int n4 = n3 + by;
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            int n5 = n3;
            while (n5 < n4) {
                byArray2[n5] = by;
                ++n5;
            }
            return byArray2;
        }
        if (n3 % n == 0) {
            if (n2 == 0 && n3 == byArray.length) {
                return byArray;
            }
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n2, byArray3, 0, n3);
            return byArray3;
        }
        throw new CipherException("Data size is not a multiple of block size");
    }

    final void resetLastCipherBlock() {
        if (this.iv != null && this.lastCipherBlock != null) {
            System.arraycopy(this.iv, 0, this.lastCipherBlock, 0, this.iv.length);
        }
    }

    public void setIV(byte[] byArray) throws CipherException {
        if (byArray != null) {
            if (byArray.length != this.blockSize) {
                throw new CipherException("IV length is not equal to block size");
            }
            this.iv = (byte[])byArray.clone();
            if (this.lastCipherBlock != null && this.lastCipherBlock.length == this.blockSize) {
                System.arraycopy(this.iv, 0, this.lastCipherBlock, 0, this.iv.length);
            } else {
                this.lastCipherBlock = (byte[])byArray.clone();
            }
        } else {
            this.iv = null;
            this.lastCipherBlock = null;
        }
        this.releaseOp();
    }

    public void setPadding(int n) {
        if (n == Padding.NONE.getValue()) {
            this.paddingID = Padding.NONE;
        } else if (n == Padding.PKCS5.getValue()) {
            this.paddingID = Padding.PKCS5;
        } else {
            throw new IllegalArgumentException("The value, " + n + ", is not recognized " + "as a valid padding option.");
        }
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    static byte[] unpad(Padding.ID iD, int n, byte[] byArray) throws CipherException {
        if (iD == Padding.PKCS5) {
            int n2 = byArray[byArray.length - 1] & 0xFF;
            if (n2 > n) {
                throw new CipherException("Invalid padding string (or incorrect password)");
            }
            int n3 = byArray.length - n2;
            int n4 = byArray.length;
            while (n3 < n4) {
                if (byArray[n3] != n2) {
                    throw new CipherException("Invalid padding string (or incorrect password)");
                }
                ++n3;
            }
            byte[] byArray2 = new byte[byArray.length - n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
        if (byArray.length % n == 0) {
            return byArray;
        }
        throw new CipherException("Data size is not a multiple of block size");
    }
}

