/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.BlockCipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.Coder;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.Padding;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.IntConstant;
import com.phaos.utils.OIDManager;

public abstract class Cipher
extends Coder {
    private Op op;
    private int padding;
    protected int mode;
    protected Key encryptionKey;
    protected Key decryptionKey;
    protected Key key;
    protected RandomBitsSource rbs;
    public static final int NULL_PADDING = 0;
    public static final int PKCS5_PADDING = 1;
    public static final int ECB = 0;
    public static final int CBC = 1;

    protected Cipher() {
    }

    protected final void assertDecryption() throws CipherException {
        if (this.op == Op.DECRYPTION) {
            return;
        }
        if (this.op == null) {
            this.op = Op.DECRYPTION;
            return;
        }
        throw new CipherException("A Cipher may not be used for decryption after it has been been used for encryption without being re-initialized");
    }

    protected final void assertEncryption() throws CipherException {
        if (this.op == Op.ENCRYPTION) {
            return;
        }
        if (this.op == null) {
            this.op = Op.ENCRYPTION;
            return;
        }
        throw new CipherException("A Cipher may not be used for encryption after it has been been used for decryption without being re-initialized");
    }

    public abstract int blockSize();

    public Key cloneKey() {
        return (Key)this.key.clone();
    }

    public final byte[] decodeOp(byte[] byArray) throws CipherException {
        return this.decrypt(byArray);
    }

    public byte[] decrypt(byte[] byArray) throws CipherException {
        return this.decrypt(byArray, 0, byArray.length);
    }

    public byte[] decrypt(byte[] byArray, int n, int n2) throws CipherException {
        return this.decrypt(byArray, n, n2, false);
    }

    public abstract byte[] decrypt(byte[] var1, int var2, int var3, boolean var4) throws CipherException;

    public abstract void decrypt(byte[] var1, int var2, int var3, byte[] var4, int var5) throws CipherException;

    public byte[] decrypt(byte[] byArray, boolean bl) throws CipherException {
        return this.decrypt(byArray, 0, byArray.length, bl);
    }

    public byte[] decryptOp(byte[] byArray) throws CipherException {
        byte[] byArray2 = new byte[byArray.length];
        this.decryptOp(byArray, 0, byArray2, 0);
        return byArray2;
    }

    public abstract void decryptOp(byte[] var1, int var2, byte[] var3, int var4) throws CipherException;

    public final byte[] encodeOp(byte[] byArray) throws CipherException {
        return this.encrypt(byArray);
    }

    public byte[] encrypt(byte[] byArray) throws CipherException {
        return this.encrypt(byArray, 0, byArray.length);
    }

    public byte[] encrypt(byte[] byArray, int n, int n2) throws CipherException {
        return this.encrypt(byArray, n, n2, false);
    }

    public abstract byte[] encrypt(byte[] var1, int var2, int var3, boolean var4) throws CipherException;

    public abstract void encrypt(byte[] var1, int var2, int var3, byte[] var4, int var5) throws CipherException;

    public byte[] encrypt(byte[] byArray, boolean bl) throws CipherException {
        return this.encrypt(byArray, 0, byArray.length, bl);
    }

    public byte[] encryptOp(byte[] byArray) throws CipherException {
        byte[] byArray2 = new byte[byArray.length];
        this.encryptOp(byArray, 0, byArray2, 0);
        return byArray2;
    }

    public abstract void encryptOp(byte[] var1, int var2, byte[] var3, int var4) throws CipherException;

    public void erase() {
        this.eraseKeys();
        this.releaseOp();
    }

    final void eraseKeys() {
        if (this.key != null) {
            this.key.erase();
        }
        if (this.decryptionKey != null) {
            this.decryptionKey.erase();
        }
        if (this.encryptionKey != null) {
            this.encryptionKey.erase();
        }
    }

    public abstract AlgorithmIdentifier getAlgID();

    public abstract int getBlockSize();

    public Key getDecryptionKey() {
        if (this.decryptionKey != null) {
            return (Key)this.decryptionKey.clone();
        }
        return null;
    }

    public Key getEncryptionKey() {
        if (this.encryptionKey != null) {
            return (Key)this.encryptionKey.clone();
        }
        return null;
    }

    public byte[] getIV() {
        return null;
    }

    public static Cipher getInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.instantiate(clazz);
        cipher.setAlgID(algorithmIdentifier);
        return cipher;
    }

    public static Cipher getInstance(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.instantiate(clazz);
        cipher.initialize(algorithmIdentifier, key);
        return cipher;
    }

    public static Cipher getInstance(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.instantiate(clazz);
        cipher.initialize(algorithmIdentifier, symmetricKey, iD);
        return cipher;
    }

    public static Cipher getInstance(PrivateKey privateKey) throws AlgorithmIdentifierException, InvalidKeyException {
        AlgorithmIdentifier algorithmIdentifier = privateKey.getAlgID();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for the private key with AlgorithmIdentifier: " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.instantiate(clazz);
        try {
            cipher.initialize(algorithmIdentifier, privateKey);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.getMessage());
        }
        return cipher;
    }

    public static Cipher getInstance(PublicKey publicKey) throws AlgorithmIdentifierException, InvalidKeyException {
        AlgorithmIdentifier algorithmIdentifier = publicKey.getAlgID();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for the public key with AlgorithmIdentifier: " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.instantiate(clazz);
        try {
            cipher.initialize(algorithmIdentifier, publicKey);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.getMessage());
        }
        return cipher;
    }

    public SymmetricKey getKey() {
        if (this.decryptionKey instanceof SymmetricKey && this.encryptionKey instanceof SymmetricKey && this.decryptionKey.equals(this.encryptionKey)) {
            return (SymmetricKey)this.cloneKey();
        }
        return null;
    }

    public int getMode() {
        return this.mode;
    }

    public int getPadding() {
        return this.padding;
    }

    public Padding.ID getPaddingID() {
        return null;
    }

    RandomBitsSource getRBS() {
        if (this.rbs != null) {
            return this.rbs;
        }
        return RandomBitsSource.getDefault();
    }

    public abstract void initialize(AlgorithmIdentifier var1, Key var2) throws AlgorithmIdentifierException, InvalidKeyException, CipherException;

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        throw new AlgorithmIdentifierException("This Cipher instance is not a block Cipher");
    }

    private static Cipher instantiate(Class clazz) throws AlgorithmIdentifierException {
        Cipher cipher;
        try {
            cipher = (Cipher)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement Cipher.");
        }
        return cipher;
    }

    public byte[] pad(byte[] byArray) throws CipherException {
        int n = this.getBlockSize();
        Padding.ID iD = null;
        if (this.getPaddingID() != null) {
            iD = this.getPaddingID();
        } else if (this.padding == 1) {
            iD = Padding.PKCS5;
        } else if (this.padding == 0) {
            iD = Padding.NONE;
        } else {
            throw new CipherException("Unknown padding method requested: " + this.padding);
        }
        return BlockCipher.pad(iD, n, byArray, 0, byArray.length);
    }

    protected final void releaseOp() {
        this.op = null;
    }

    public abstract void setAlgID(AlgorithmIdentifier var1) throws AlgorithmIdentifierException;

    public void setDecryptionKey(Key key) throws InvalidKeyException {
        if (this.decryptionKey != null && this.decryptionKey != this.encryptionKey) {
            this.decryptionKey.erase();
        }
        this.decryptionKey = key != null ? (Key)key.clone() : null;
        this.key = this.decryptionKey;
        this.releaseOp();
    }

    public void setEncryptionKey(Key key) throws InvalidKeyException {
        if (this.encryptionKey != null && this.encryptionKey != this.decryptionKey) {
            this.encryptionKey.erase();
        }
        this.encryptionKey = key != null ? (Key)key.clone() : null;
        this.key = this.encryptionKey;
        this.releaseOp();
    }

    public void setIV(byte[] byArray) throws CipherException {
        this.releaseOp();
    }

    public void setKey(SymmetricKey symmetricKey) throws InvalidKeyException {
        if (this.key != null) {
            this.key.erase();
        }
        if (this.decryptionKey != null) {
            this.decryptionKey.erase();
        }
        if (this.encryptionKey != null) {
            this.encryptionKey.erase();
        }
        this.key = symmetricKey != null ? (Key)symmetricKey.clone() : null;
        this.decryptionKey = this.key;
        this.encryptionKey = this.key;
        this.releaseOp();
    }

    public void setMode(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("The value, " + n + ", is not recognized " + "as a valid block mode");
        }
        this.mode = n;
        this.releaseOp();
    }

    public void setPadding(int n) {
        if (n == Padding.NONE.getValue()) {
            this.padding = Padding.NONE.getValue();
        } else if (n == Padding.PKCS5.getValue()) {
            this.padding = Padding.PKCS5.getValue();
        } else {
            throw new IllegalArgumentException("The value, " + n + ", is not recognized " + "as a valid padding option.");
        }
        this.releaseOp();
    }

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        this.rbs = randomBitsSource;
        this.releaseOp();
    }

    public byte[] unpad(byte[] byArray) throws CipherException {
        int n = this.getBlockSize();
        Padding.ID iD = null;
        if (this.getPaddingID() != null) {
            iD = this.getPaddingID();
        } else if (this.padding == 1) {
            iD = Padding.PKCS5;
        } else if (this.padding == 0) {
            iD = Padding.NONE;
        } else {
            throw new CipherException("Unknown padding method requested: " + this.padding);
        }
        return BlockCipher.unpad(iD, n, byArray);
    }

    private static final class Op
    extends IntConstant {
        static final Op ENCRYPTION = new Op(0);
        static final Op DECRYPTION = new Op(1);

        private Op(int n) {
            super(n);
        }

        public String toString() {
            switch (this.getValue()) {
                case 0: {
                    return "ENCRYPTION";
                }
                case 1: {
                    return "DECRYPTION";
                }
            }
            return "UNKNOWN OPERATION";
        }
    }
}

