/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.CoderException;

public abstract class Coder {
    protected Coder() {
    }

    public abstract String algName();

    public abstract int blockSize();

    public byte[] decode(byte[] byArray) throws CoderException {
        return this.decode(byArray, 0, byArray.length);
    }

    public byte[] decode(byte[] byArray, int n, int n2) throws CoderException {
        byte[] byArray2 = new byte[n2];
        int n3 = this.blockSize();
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (byArray2.length % n3 != 0) {
            throw new CoderException("Data size is not a multiple of block size");
        }
        byte[] byArray5 = new byte[byArray2.length];
        int n4 = 0;
        int n5 = byArray2.length;
        while (n4 < n5) {
            System.arraycopy(byArray2, n4, byArray3, 0, n3);
            byArray4 = this.decodeOp(byArray3);
            System.arraycopy(byArray4, 0, byArray5, n4, n3);
            n4 += n3;
        }
        return byArray5;
    }

    public abstract byte[] decodeOp(byte[] var1) throws CoderException;

    public byte[] encode(byte[] byArray) throws CoderException {
        return this.encode(byArray, 0, byArray.length);
    }

    public byte[] encode(byte[] byArray, int n, int n2) throws CoderException {
        byte[] byArray2 = new byte[n2];
        int n3 = this.blockSize();
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (byArray2.length % n3 != 0) {
            throw new CoderException("Data size is not a multiple of block size");
        }
        byte[] byArray5 = new byte[byArray2.length];
        int n4 = 0;
        int n5 = byArray2.length;
        while (n4 < n5) {
            System.arraycopy(byArray2, n4, byArray3, 0, n3);
            byArray4 = this.encodeOp(byArray3);
            System.arraycopy(byArray4, 0, byArray5, n4, n3);
            n4 += n3;
        }
        return byArray5;
    }

    public abstract byte[] encodeOp(byte[] var1) throws CoderException;

    public abstract int getBlockSize();

    public void initialize() {
    }
}

