/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.Coder;
import com.phaos.crypto.CoderException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CoderInputStream
extends FilterInputStream {
    public static final int DECODE_MODE = 0;
    public static final int ENCODE_MODE = 1;
    protected int mode = 0;
    protected Coder coder;
    protected byte[] buf;
    protected int count;

    public CoderInputStream(InputStream inputStream, Coder coder) {
        super(inputStream);
        this.coder = coder;
        this.buf = new byte[this.coder.blockSize()];
        this.count = this.coder.blockSize();
    }

    public synchronized int available() throws IOException {
        int n = this.coder.blockSize();
        return n - this.count + this.in.available() / n * n;
    }

    public Coder getCoder() {
        return this.coder;
    }

    public int getMode() {
        return this.mode;
    }

    public synchronized int read() throws IOException {
        if (this.count < this.coder.blockSize()) {
            return this.buf[this.count++] & 0xFF;
        }
        byte[] byArray = new byte[this.coder.blockSize()];
        int n = 0;
        int n2 = this.coder.blockSize();
        while (n < n2) {
            int n3 = this.in.read();
            if (n3 == -1) {
                return -1;
            }
            byArray[n] = (byte)n3;
            ++n;
        }
        try {
            this.buf = this.mode == 1 ? this.coder.encodeOp(byArray) : this.coder.decodeOp(byArray);
            this.count = 0;
        }
        catch (CoderException coderException) {
            throw new IOException(coderException.toString());
        }
        return this.buf[this.count++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) break;
            byArray[n + n3] = (byte)n4;
            ++n3;
        }
        return n3 != 0 ? n3 : -1;
    }

    public void setMode(int n) {
        this.mode = n;
    }
}

