/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.BlockCipher;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.Padding;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.Utils;

public final class DES
extends BlockCipher {
    private static final int BLOCK_SIZE = 8;
    private int[] kEnc;
    private int[] kDec;
    private int[] halves;
    private static final int[] pc1 = new int[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
    private static final int[] totrot = new int[]{1, 2, 4, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 25, 27, 28};
    private static final int[] pc2 = new int[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
    private static final int[] bytebit = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private static final int[][] Spbox;

    static {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[64];
        nArray[0] = 0x1010400;
        nArray[2] = 65536;
        nArray[3] = 0x1010404;
        nArray[4] = 0x1010004;
        nArray[5] = 66564;
        nArray[6] = 4;
        nArray[7] = 65536;
        nArray[8] = 1024;
        nArray[9] = 0x1010400;
        nArray[10] = 0x1010404;
        nArray[11] = 1024;
        nArray[12] = 0x1000404;
        nArray[13] = 0x1010004;
        nArray[14] = 0x1000000;
        nArray[15] = 4;
        nArray[16] = 1028;
        nArray[17] = 0x1000400;
        nArray[18] = 0x1000400;
        nArray[19] = 66560;
        nArray[20] = 66560;
        nArray[21] = 0x1010000;
        nArray[22] = 0x1010000;
        nArray[23] = 0x1000404;
        nArray[24] = 65540;
        nArray[25] = 0x1000004;
        nArray[26] = 0x1000004;
        nArray[27] = 65540;
        nArray[29] = 1028;
        nArray[30] = 66564;
        nArray[31] = 0x1000000;
        nArray[32] = 65536;
        nArray[33] = 0x1010404;
        nArray[34] = 4;
        nArray[35] = 0x1010000;
        nArray[36] = 0x1010400;
        nArray[37] = 0x1000000;
        nArray[38] = 0x1000000;
        nArray[39] = 1024;
        nArray[40] = 0x1010004;
        nArray[41] = 65536;
        nArray[42] = 66560;
        nArray[43] = 0x1000004;
        nArray[44] = 1024;
        nArray[45] = 4;
        nArray[46] = 0x1000404;
        nArray[47] = 66564;
        nArray[48] = 0x1010404;
        nArray[49] = 65540;
        nArray[50] = 0x1010000;
        nArray[51] = 0x1000404;
        nArray[52] = 0x1000004;
        nArray[53] = 1028;
        nArray[54] = 66564;
        nArray[55] = 0x1010400;
        nArray[56] = 1028;
        nArray[57] = 0x1000400;
        nArray[58] = 0x1000400;
        nArray[60] = 65540;
        nArray[61] = 66560;
        nArray[63] = 0x1010004;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[64];
        nArray2[0] = -2146402272;
        nArray2[1] = -2147450880;
        nArray2[2] = 32768;
        nArray2[3] = 1081376;
        nArray2[4] = 0x100000;
        nArray2[5] = 32;
        nArray2[6] = -2146435040;
        nArray2[7] = -2147450848;
        nArray2[8] = -2147483616;
        nArray2[9] = -2146402272;
        nArray2[10] = -2146402304;
        nArray2[11] = Integer.MIN_VALUE;
        nArray2[12] = -2147450880;
        nArray2[13] = 0x100000;
        nArray2[14] = 32;
        nArray2[15] = -2146435040;
        nArray2[16] = 0x108000;
        nArray2[17] = 0x100020;
        nArray2[18] = -2147450848;
        nArray2[20] = Integer.MIN_VALUE;
        nArray2[21] = 32768;
        nArray2[22] = 1081376;
        nArray2[23] = -2146435072;
        nArray2[24] = 0x100020;
        nArray2[25] = -2147483616;
        nArray2[27] = 0x108000;
        nArray2[28] = 32800;
        nArray2[29] = -2146402304;
        nArray2[30] = -2146435072;
        nArray2[31] = 32800;
        nArray2[33] = 1081376;
        nArray2[34] = -2146435040;
        nArray2[35] = 0x100000;
        nArray2[36] = -2147450848;
        nArray2[37] = -2146435072;
        nArray2[38] = -2146402304;
        nArray2[39] = 32768;
        nArray2[40] = -2146435072;
        nArray2[41] = -2147450880;
        nArray2[42] = 32;
        nArray2[43] = -2146402272;
        nArray2[44] = 1081376;
        nArray2[45] = 32;
        nArray2[46] = 32768;
        nArray2[47] = Integer.MIN_VALUE;
        nArray2[48] = 32800;
        nArray2[49] = -2146402304;
        nArray2[50] = 0x100000;
        nArray2[51] = -2147483616;
        nArray2[52] = 0x100020;
        nArray2[53] = -2147450848;
        nArray2[54] = -2147483616;
        nArray2[55] = 0x100020;
        nArray2[56] = 0x108000;
        nArray2[58] = -2147450880;
        nArray2[59] = 32800;
        nArray2[60] = Integer.MIN_VALUE;
        nArray2[61] = -2146435040;
        nArray2[62] = -2146402272;
        nArray2[63] = 0x108000;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[64];
        nArray3[0] = 520;
        nArray3[1] = 0x8020200;
        nArray3[3] = 0x8020008;
        nArray3[4] = 0x8000200;
        nArray3[6] = 131592;
        nArray3[7] = 0x8000200;
        nArray3[8] = 131080;
        nArray3[9] = 0x8000008;
        nArray3[10] = 0x8000008;
        nArray3[11] = 131072;
        nArray3[12] = 0x8020208;
        nArray3[13] = 131080;
        nArray3[14] = 0x8020000;
        nArray3[15] = 520;
        nArray3[16] = 0x8000000;
        nArray3[17] = 8;
        nArray3[18] = 0x8020200;
        nArray3[19] = 512;
        nArray3[20] = 131584;
        nArray3[21] = 0x8020000;
        nArray3[22] = 0x8020008;
        nArray3[23] = 131592;
        nArray3[24] = 0x8000208;
        nArray3[25] = 131584;
        nArray3[26] = 131072;
        nArray3[27] = 0x8000208;
        nArray3[28] = 8;
        nArray3[29] = 0x8020208;
        nArray3[30] = 512;
        nArray3[31] = 0x8000000;
        nArray3[32] = 0x8020200;
        nArray3[33] = 0x8000000;
        nArray3[34] = 131080;
        nArray3[35] = 520;
        nArray3[36] = 131072;
        nArray3[37] = 0x8020200;
        nArray3[38] = 0x8000200;
        nArray3[40] = 512;
        nArray3[41] = 131080;
        nArray3[42] = 0x8020208;
        nArray3[43] = 0x8000200;
        nArray3[44] = 0x8000008;
        nArray3[45] = 512;
        nArray3[47] = 0x8020008;
        nArray3[48] = 0x8000208;
        nArray3[49] = 131072;
        nArray3[50] = 0x8000000;
        nArray3[51] = 0x8020208;
        nArray3[52] = 8;
        nArray3[53] = 131592;
        nArray3[54] = 131584;
        nArray3[55] = 0x8000008;
        nArray3[56] = 0x8020000;
        nArray3[57] = 0x8000208;
        nArray3[58] = 520;
        nArray3[59] = 0x8020000;
        nArray3[60] = 131592;
        nArray3[61] = 8;
        nArray3[62] = 0x8020008;
        nArray3[63] = 131584;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[64];
        nArray4[0] = 8396801;
        nArray4[1] = 8321;
        nArray4[2] = 8321;
        nArray4[3] = 128;
        nArray4[4] = 0x802080;
        nArray4[5] = 0x800081;
        nArray4[6] = 0x800001;
        nArray4[7] = 8193;
        nArray4[9] = 0x802000;
        nArray4[10] = 0x802000;
        nArray4[11] = 8396929;
        nArray4[12] = 129;
        nArray4[14] = 0x800080;
        nArray4[15] = 0x800001;
        nArray4[16] = 1;
        nArray4[17] = 8192;
        nArray4[18] = 0x800000;
        nArray4[19] = 8396801;
        nArray4[20] = 128;
        nArray4[21] = 0x800000;
        nArray4[22] = 8193;
        nArray4[23] = 8320;
        nArray4[24] = 0x800081;
        nArray4[25] = 1;
        nArray4[26] = 8320;
        nArray4[27] = 0x800080;
        nArray4[28] = 8192;
        nArray4[29] = 0x802080;
        nArray4[30] = 8396929;
        nArray4[31] = 129;
        nArray4[32] = 0x800080;
        nArray4[33] = 0x800001;
        nArray4[34] = 0x802000;
        nArray4[35] = 8396929;
        nArray4[36] = 129;
        nArray4[39] = 0x802000;
        nArray4[40] = 8320;
        nArray4[41] = 0x800080;
        nArray4[42] = 0x800081;
        nArray4[43] = 1;
        nArray4[44] = 8396801;
        nArray4[45] = 8321;
        nArray4[46] = 8321;
        nArray4[47] = 128;
        nArray4[48] = 8396929;
        nArray4[49] = 129;
        nArray4[50] = 1;
        nArray4[51] = 8192;
        nArray4[52] = 0x800001;
        nArray4[53] = 8193;
        nArray4[54] = 0x802080;
        nArray4[55] = 0x800081;
        nArray4[56] = 8193;
        nArray4[57] = 8320;
        nArray4[58] = 0x800000;
        nArray4[59] = 8396801;
        nArray4[60] = 128;
        nArray4[61] = 0x800000;
        nArray4[62] = 8192;
        nArray4[63] = 0x802080;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[64];
        nArray5[0] = 256;
        nArray5[1] = 34078976;
        nArray5[2] = 0x2080000;
        nArray5[3] = 1107296512;
        nArray5[4] = 524288;
        nArray5[5] = 256;
        nArray5[6] = 0x40000000;
        nArray5[7] = 0x2080000;
        nArray5[8] = 1074266368;
        nArray5[9] = 524288;
        nArray5[10] = 0x2000100;
        nArray5[11] = 1074266368;
        nArray5[12] = 1107296512;
        nArray5[13] = 1107820544;
        nArray5[14] = 524544;
        nArray5[15] = 0x40000000;
        nArray5[16] = 0x2000000;
        nArray5[17] = 0x40080000;
        nArray5[18] = 0x40080000;
        nArray5[20] = 0x40000100;
        nArray5[21] = 1107820800;
        nArray5[22] = 1107820800;
        nArray5[23] = 0x2000100;
        nArray5[24] = 1107820544;
        nArray5[25] = 0x40000100;
        nArray5[27] = 0x42000000;
        nArray5[28] = 34078976;
        nArray5[29] = 0x2000000;
        nArray5[30] = 0x42000000;
        nArray5[31] = 524544;
        nArray5[32] = 524288;
        nArray5[33] = 1107296512;
        nArray5[34] = 256;
        nArray5[35] = 0x2000000;
        nArray5[36] = 0x40000000;
        nArray5[37] = 0x2080000;
        nArray5[38] = 1107296512;
        nArray5[39] = 1074266368;
        nArray5[40] = 0x2000100;
        nArray5[41] = 0x40000000;
        nArray5[42] = 1107820544;
        nArray5[43] = 34078976;
        nArray5[44] = 1074266368;
        nArray5[45] = 256;
        nArray5[46] = 0x2000000;
        nArray5[47] = 1107820544;
        nArray5[48] = 1107820800;
        nArray5[49] = 524544;
        nArray5[50] = 0x42000000;
        nArray5[51] = 1107820800;
        nArray5[52] = 0x2080000;
        nArray5[54] = 0x40080000;
        nArray5[55] = 0x42000000;
        nArray5[56] = 524544;
        nArray5[57] = 0x2000100;
        nArray5[58] = 0x40000100;
        nArray5[59] = 524288;
        nArray5[61] = 0x40080000;
        nArray5[62] = 34078976;
        nArray5[63] = 0x40000100;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[64];
        nArray6[0] = 0x20000010;
        nArray6[1] = 0x20400000;
        nArray6[2] = 16384;
        nArray6[3] = 541081616;
        nArray6[4] = 0x20400000;
        nArray6[5] = 16;
        nArray6[6] = 541081616;
        nArray6[7] = 0x400000;
        nArray6[8] = 0x20004000;
        nArray6[9] = 0x404010;
        nArray6[10] = 0x400000;
        nArray6[11] = 0x20000010;
        nArray6[12] = 0x400010;
        nArray6[13] = 0x20004000;
        nArray6[14] = 0x20000000;
        nArray6[15] = 16400;
        nArray6[17] = 0x400010;
        nArray6[18] = 536887312;
        nArray6[19] = 16384;
        nArray6[20] = 0x404000;
        nArray6[21] = 536887312;
        nArray6[22] = 16;
        nArray6[23] = 541065232;
        nArray6[24] = 541065232;
        nArray6[26] = 0x404010;
        nArray6[27] = 0x20404000;
        nArray6[28] = 16400;
        nArray6[29] = 0x404000;
        nArray6[30] = 0x20404000;
        nArray6[31] = 0x20000000;
        nArray6[32] = 0x20004000;
        nArray6[33] = 16;
        nArray6[34] = 541065232;
        nArray6[35] = 0x404000;
        nArray6[36] = 541081616;
        nArray6[37] = 0x400000;
        nArray6[38] = 16400;
        nArray6[39] = 0x20000010;
        nArray6[40] = 0x400000;
        nArray6[41] = 0x20004000;
        nArray6[42] = 0x20000000;
        nArray6[43] = 16400;
        nArray6[44] = 0x20000010;
        nArray6[45] = 541081616;
        nArray6[46] = 0x404000;
        nArray6[47] = 0x20400000;
        nArray6[48] = 0x404010;
        nArray6[49] = 0x20404000;
        nArray6[51] = 541065232;
        nArray6[52] = 16;
        nArray6[53] = 16384;
        nArray6[54] = 0x20400000;
        nArray6[55] = 0x404010;
        nArray6[56] = 16384;
        nArray6[57] = 0x400010;
        nArray6[58] = 536887312;
        nArray6[60] = 0x20404000;
        nArray6[61] = 0x20000000;
        nArray6[62] = 0x400010;
        nArray6[63] = 536887312;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[64];
        nArray7[0] = 0x200000;
        nArray7[1] = 0x4200002;
        nArray7[2] = 67110914;
        nArray7[4] = 2048;
        nArray7[5] = 67110914;
        nArray7[6] = 0x200802;
        nArray7[7] = 69208064;
        nArray7[8] = 69208066;
        nArray7[9] = 0x200000;
        nArray7[11] = 0x4000002;
        nArray7[12] = 2;
        nArray7[13] = 0x4000000;
        nArray7[14] = 0x4200002;
        nArray7[15] = 2050;
        nArray7[16] = 0x4000800;
        nArray7[17] = 0x200802;
        nArray7[18] = 0x200002;
        nArray7[19] = 0x4000800;
        nArray7[20] = 0x4000002;
        nArray7[21] = 0x4200000;
        nArray7[22] = 69208064;
        nArray7[23] = 0x200002;
        nArray7[24] = 0x4200000;
        nArray7[25] = 2048;
        nArray7[26] = 2050;
        nArray7[27] = 69208066;
        nArray7[28] = 0x200800;
        nArray7[29] = 2;
        nArray7[30] = 0x4000000;
        nArray7[31] = 0x200800;
        nArray7[32] = 0x4000000;
        nArray7[33] = 0x200800;
        nArray7[34] = 0x200000;
        nArray7[35] = 67110914;
        nArray7[36] = 67110914;
        nArray7[37] = 0x4200002;
        nArray7[38] = 0x4200002;
        nArray7[39] = 2;
        nArray7[40] = 0x200002;
        nArray7[41] = 0x4000000;
        nArray7[42] = 0x4000800;
        nArray7[43] = 0x200000;
        nArray7[44] = 69208064;
        nArray7[45] = 2050;
        nArray7[46] = 0x200802;
        nArray7[47] = 69208064;
        nArray7[48] = 2050;
        nArray7[49] = 0x4000002;
        nArray7[50] = 69208066;
        nArray7[51] = 0x4200000;
        nArray7[52] = 0x200800;
        nArray7[54] = 2;
        nArray7[55] = 69208066;
        nArray7[57] = 0x200802;
        nArray7[58] = 0x4200000;
        nArray7[59] = 2048;
        nArray7[60] = 0x4000002;
        nArray7[61] = 0x4000800;
        nArray7[62] = 2048;
        nArray7[63] = 0x200002;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[64];
        nArray8[0] = 0x10001040;
        nArray8[1] = 4096;
        nArray8[2] = 262144;
        nArray8[3] = 0x10041040;
        nArray8[4] = 0x10000000;
        nArray8[5] = 0x10001040;
        nArray8[6] = 64;
        nArray8[7] = 0x10000000;
        nArray8[8] = 262208;
        nArray8[9] = 0x10040000;
        nArray8[10] = 0x10041040;
        nArray8[11] = 266240;
        nArray8[12] = 0x10041000;
        nArray8[13] = 266304;
        nArray8[14] = 4096;
        nArray8[15] = 64;
        nArray8[16] = 0x10040000;
        nArray8[17] = 0x10000040;
        nArray8[18] = 0x10001000;
        nArray8[19] = 4160;
        nArray8[20] = 266240;
        nArray8[21] = 262208;
        nArray8[22] = 0x10040040;
        nArray8[23] = 0x10041000;
        nArray8[24] = 4160;
        nArray8[27] = 0x10040040;
        nArray8[28] = 0x10000040;
        nArray8[29] = 0x10001000;
        nArray8[30] = 266304;
        nArray8[31] = 262144;
        nArray8[32] = 266304;
        nArray8[33] = 262144;
        nArray8[34] = 0x10041000;
        nArray8[35] = 4096;
        nArray8[36] = 64;
        nArray8[37] = 0x10040040;
        nArray8[38] = 4096;
        nArray8[39] = 266304;
        nArray8[40] = 0x10001000;
        nArray8[41] = 64;
        nArray8[42] = 0x10000040;
        nArray8[43] = 0x10040000;
        nArray8[44] = 0x10040040;
        nArray8[45] = 0x10000000;
        nArray8[46] = 262144;
        nArray8[47] = 0x10001040;
        nArray8[49] = 0x10041040;
        nArray8[50] = 262208;
        nArray8[51] = 0x10000040;
        nArray8[52] = 0x10040000;
        nArray8[53] = 0x10001000;
        nArray8[54] = 0x10001040;
        nArray8[56] = 0x10041040;
        nArray8[57] = 266240;
        nArray8[58] = 266240;
        nArray8[59] = 4160;
        nArray8[60] = 4160;
        nArray8[61] = 262208;
        nArray8[62] = 0x10000000;
        nArray8[63] = 0x10041000;
        nArrayArray[7] = nArray8;
        Spbox = nArrayArray;
    }

    public DES() {
        this(0);
    }

    public DES(int n) {
        super(8);
        if (n == 0) {
            this.init(n);
            this.halves = new int[2];
        } else if (n == 1) {
            this.init(n);
            this.halves = new int[2];
        } else {
            throw new IllegalArgumentException("invalid cipher mode " + n);
        }
    }

    private static void FPERM(int[] nArray) {
        nArray[1] = DES.rotr(nArray[1], 1);
        int n = (nArray[0] ^ nArray[1]) & 0xAAAAAAAA;
        nArray[1] = nArray[1] ^ n;
        nArray[0] = DES.rotr(nArray[0] ^ n, 9);
        n = (nArray[0] ^ nArray[1]) & 0xFF00FF;
        nArray[1] = nArray[1] ^ n;
        nArray[0] = DES.rotl(nArray[0] ^ n, 6);
        n = (nArray[0] ^ nArray[1]) & 0x33333333;
        nArray[1] = nArray[1] ^ n;
        nArray[0] = DES.rotl(nArray[0] ^ n, 18);
        n = (nArray[0] ^ nArray[1]) & 0xFFFF0000;
        nArray[1] = nArray[1] ^ n;
        nArray[0] = DES.rotl(nArray[0] ^ n, 20);
        n = (nArray[0] ^ nArray[1]) & 0xF0F0F0F0;
        nArray[1] = nArray[1] ^ n;
        nArray[0] = DES.rotr(nArray[0] ^ n, 4);
    }

    private static void GETBLOCK(byte[] byArray, int n, int[] nArray) {
        nArray[0] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        nArray[1] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
    }

    private static void IPERM(int[] nArray) {
        nArray[1] = DES.rotl(nArray[1], 4);
        int n = (nArray[0] ^ nArray[1]) & 0xF0F0F0F0;
        nArray[0] = nArray[0] ^ n;
        nArray[1] = DES.rotr(nArray[1] ^ n, 20);
        n = (nArray[0] ^ nArray[1]) & 0xFFFF0000;
        nArray[0] = nArray[0] ^ n;
        nArray[1] = DES.rotr(nArray[1] ^ n, 18);
        n = (nArray[0] ^ nArray[1]) & 0x33333333;
        nArray[0] = nArray[0] ^ n;
        nArray[1] = DES.rotr(nArray[1] ^ n, 6);
        n = (nArray[0] ^ nArray[1]) & 0xFF00FF;
        nArray[0] = nArray[0] ^ n;
        nArray[1] = DES.rotl(nArray[1] ^ n, 9);
        n = (nArray[0] ^ nArray[1]) & 0xAAAAAAAA;
        nArray[0] = DES.rotl(nArray[0] ^ n, 1);
        nArray[1] = nArray[1] ^ n;
    }

    private static void PUTBLOCK(byte[] byArray, int n, int[] nArray) {
        byArray[n++] = (byte)(nArray[0] >> 24);
        byArray[n++] = (byte)(nArray[0] >> 16);
        byArray[n++] = (byte)(nArray[0] >> 8);
        byArray[n++] = (byte)nArray[0];
        byArray[n++] = (byte)(nArray[1] >> 24);
        byArray[n++] = (byte)(nArray[1] >> 16);
        byArray[n++] = (byte)(nArray[1] >> 8);
        byArray[n++] = (byte)nArray[1];
    }

    public String algName() {
        return "DES";
    }

    protected void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        DES.processBlock(byArray, n, byArray2, n2, this.kDec, this.halves);
    }

    public void decryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertDecryption();
        DES.processBlock(byArray, n, byArray2, n2, this.kDec, this.halves);
    }

    protected void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        DES.processBlock(byArray, n, byArray2, n2, this.kEnc, this.halves);
    }

    public void encryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertEncryption();
        DES.processBlock(byArray, n, byArray2, n2, this.kEnc, this.halves);
    }

    public void erase() {
        super.erase();
        Utils.setArray(this.kEnc, 0);
        Utils.setArray(this.kDec, 0);
        Utils.setArray(this.halves, 0);
    }

    public AlgorithmIdentifier getAlgID() {
        if (this.mode == 0) {
            return new AlgorithmIdentifier(AlgID.desECB.getOID());
        }
        if (this.mode == 1) {
            return new CBCAlgorithmIdentifier(AlgID.desCBC.getOID(), this.getIV());
        }
        throw new IllegalStateException("unknown mode " + this.mode);
    }

    private void init(int n) {
        if (n == 0) {
            this.mode = n;
        } else if (n == 1) {
            this.mode = n;
            this.initCBC(null);
        } else {
            throw new IllegalArgumentException("invalid cipher mode " + n);
        }
    }

    private void init(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.desECB.getOID())) {
            this.init(0);
        } else if (algorithmIdentifier.getOID().equals(AlgID.desCBC.getOID())) {
            this.init(1);
            this.initCBC(CryptoUtils.getIV(algorithmIdentifier));
        } else {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier " + algorithmIdentifier + " for DES");
        }
    }

    private void initCBC(byte[] byArray) {
        byte[] byArray2 = this.getIV();
        String string = "couldn't reset cipher IV";
        if (byArray != null) {
            string = "couldn't set IV provided with algID";
        } else if (byArray2 != null) {
            byArray = byArray2;
            string = "couldn't reset cipher IV";
        } else if (byArray2 == null) {
            byArray = this.getRBS().randomBytes(new byte[this.blockSize]);
            string = "couldn't randomize cipher IV";
        }
        try {
            this.setIV(byArray);
        }
        catch (CipherException cipherException) {
            throw new IllegalStateException(String.valueOf(string) + ":  " + cipherException.toString());
        }
        this.paddingID = Padding.PKCS5;
    }

    static void initKey(byte[] byArray, int[] nArray, boolean bl) {
        int n;
        int[] nArray2 = new int[56];
        int[] nArray3 = new int[56];
        int[] nArray4 = new int[8];
        int n2 = 0;
        while (n2 < 56) {
            n = pc1[n2] - 1;
            int n3 = n & 7;
            nArray2[n2] = (byArray[n >> 3] & bytebit[n3]) != 0 ? 1 : 0;
            ++n2;
        }
        int n4 = 0;
        while (n4 < 16) {
            Utils.setArray(nArray4, 0);
            n2 = 0;
            while (n2 < 56) {
                n = n2 + totrot[n4];
                nArray3[n2] = nArray2[n < (n2 < 28 ? 28 : 56) ? n : n - 28];
                ++n2;
            }
            n2 = 0;
            while (n2 < 48) {
                if (nArray3[pc2[n2] - 1] != 0) {
                    n = n2 % 6;
                    int n5 = n2 / 6;
                    nArray4[n5] = nArray4[n5] | bytebit[n] >> 2;
                }
                ++n2;
            }
            nArray[2 * n4] = nArray4[0] << 24 | nArray4[2] << 16 | nArray4[4] << 8 | nArray4[6];
            nArray[2 * n4 + 1] = nArray4[1] << 24 | nArray4[3] << 16 | nArray4[5] << 8 | nArray4[7];
            ++n4;
        }
        if (!bl) {
            n4 = 0;
            while (n4 < 16) {
                int n6 = nArray[n4];
                nArray[n4] = nArray[30 - n4];
                nArray[30 - n4] = n6;
                n6 = nArray[n4 + 1];
                nArray[n4 + 1] = nArray[31 - n4];
                nArray[31 - n4] = n6;
                n4 += 2;
            }
        }
        Utils.setArray(nArray2, 0);
        Utils.setArray(nArray3, 0);
        Utils.setArray(nArray4, 0);
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("The key is not an instance of SymmetricKey");
        }
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        super.setKey((SymmetricKey)key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.rbs = null;
        try {
            this.setIV(null);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.getMessage());
        }
        this.init(algorithmIdentifier);
        this.paddingID = Padding.NONE;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        super.setKey(symmetricKey);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.rbs = null;
        this.setIV(null);
        this.init(algorithmIdentifier);
        this.paddingID = iD;
    }

    static void processBlock(byte[] byArray, int n, byte[] byArray2, int n2, int[] nArray, int[] nArray2) {
        int n3;
        DES.GETBLOCK(byArray, n, nArray2);
        DES.IPERM(nArray2);
        int n4 = 0;
        while (n4 < 8) {
            n3 = DES.rotr(nArray2[1], 4) ^ nArray[4 * n4];
            nArray2[0] = nArray2[0] ^ (Spbox[6][n3 & 0x3F] ^ Spbox[4][n3 >> 8 & 0x3F] ^ Spbox[2][n3 >> 16 & 0x3F] ^ Spbox[0][n3 >> 24 & 0x3F]);
            n3 = nArray2[1] ^ nArray[4 * n4 + 1];
            nArray2[0] = nArray2[0] ^ (Spbox[7][n3 & 0x3F] ^ Spbox[5][n3 >> 8 & 0x3F] ^ Spbox[3][n3 >> 16 & 0x3F] ^ Spbox[1][n3 >> 24 & 0x3F]);
            n3 = DES.rotr(nArray2[0], 4) ^ nArray[4 * n4 + 2];
            nArray2[1] = nArray2[1] ^ (Spbox[6][n3 & 0x3F] ^ Spbox[4][n3 >> 8 & 0x3F] ^ Spbox[2][n3 >> 16 & 0x3F] ^ Spbox[0][n3 >> 24 & 0x3F]);
            n3 = nArray2[0] ^ nArray[4 * n4 + 3];
            nArray2[1] = nArray2[1] ^ (Spbox[7][n3 & 0x3F] ^ Spbox[5][n3 >> 8 & 0x3F] ^ Spbox[3][n3 >> 16 & 0x3F] ^ Spbox[1][n3 >> 24 & 0x3F]);
            ++n4;
        }
        nArray2[1] = DES.rotr(nArray2[1], 1);
        n3 = (nArray2[0] ^ nArray2[1]) & 0xAAAAAAAA;
        nArray2[1] = nArray2[1] ^ n3;
        nArray2[0] = DES.rotr(nArray2[0] ^ n3, 9);
        n3 = (nArray2[0] ^ nArray2[1]) & 0xFF00FF;
        nArray2[1] = nArray2[1] ^ n3;
        nArray2[0] = DES.rotl(nArray2[0] ^ n3, 6);
        n3 = (nArray2[0] ^ nArray2[1]) & 0x33333333;
        nArray2[1] = nArray2[1] ^ n3;
        nArray2[0] = DES.rotl(nArray2[0] ^ n3, 18);
        n3 = (nArray2[0] ^ nArray2[1]) & 0xFFFF0000;
        nArray2[1] = nArray2[1] ^ n3;
        nArray2[0] = DES.rotl(nArray2[0] ^ n3, 20);
        n3 = (nArray2[0] ^ nArray2[1]) & 0xF0F0F0F0;
        nArray2[1] = nArray2[1] ^ n3;
        nArray2[0] = DES.rotr(nArray2[0] ^ n3, 4);
        int n5 = nArray2[0];
        nArray2[0] = nArray2[1];
        nArray2[1] = n5;
        DES.PUTBLOCK(byArray2, n2, nArray2);
    }

    private static int rotl(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private static int rotr(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.init(algorithmIdentifier);
        this.releaseOp();
    }

    public void setDecryptionKey(Key key) throws InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("Key must be an instance of a SymmetricKey to be used with the DES cipher");
        }
        super.setDecryptionKey(key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    public void setEncryptionKey(Key key) throws InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("Key must be an instance of a SymmetricKey to be used with the DES cipher");
        }
        super.setEncryptionKey(key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    public void setKey(SymmetricKey symmetricKey) throws InvalidKeyException {
        super.setKey(symmetricKey);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    private void setKeyMaterial(SymmetricKey symmetricKey) throws InvalidKeyException {
        this.kEnc = new int[32];
        this.kDec = new int[32];
        DES.initKey(symmetricKey.getBytes(), this.kEnc, true);
        DES.initKey(symmetricKey.getBytes(), this.kDec, false);
    }

    public void setMode(int n) {
        if (n == 0) {
            this.init(n);
        } else if (n == 1) {
            this.init(n);
        } else {
            throw new IllegalArgumentException("The value, " + n + ", is not recognized " + "as a valid block mode");
        }
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    public String toString() {
        return "DES" + (this.mode == 1 ? "-CBC" : "") + (this.getKey() != null ? "; key = " + Utils.toHexString(this.getKey().getBytes()) : "");
    }
}

