/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.BlockCipher;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.DES;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.Padding;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.Utils;

public final class DES_EDE
extends BlockCipher {
    private static final int BLOCK_SIZE = 8;
    private int[] kEnc;
    private int[] kEnc2;
    private int[] kEnc3;
    private int[] kDec;
    private int[] kDec2;
    private int[] kDec3;
    private int[] halves;
    private byte[] buf1;
    private byte[] buf2;

    public DES_EDE() {
        this(0);
    }

    public DES_EDE(int n) {
        super(8);
        this.init(n);
        this.halves = new int[2];
    }

    public String algName() {
        return "DES-EDE";
    }

    protected void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        DES.processBlock(byArray, n, this.buf1, 0, this.kDec3, this.halves);
        DES.processBlock(this.buf1, 0, this.buf2, 0, this.kEnc2, this.halves);
        DES.processBlock(this.buf2, 0, byArray2, n2, this.kDec, this.halves);
    }

    public void decryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertDecryption();
        DES.processBlock(byArray, n, this.buf1, 0, this.kDec3, this.halves);
        DES.processBlock(this.buf1, 0, this.buf2, 0, this.kEnc2, this.halves);
        DES.processBlock(this.buf2, 0, byArray2, n2, this.kDec, this.halves);
    }

    protected void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        DES.processBlock(byArray, n, this.buf1, 0, this.kEnc, this.halves);
        DES.processBlock(this.buf1, 0, this.buf2, 0, this.kDec2, this.halves);
        DES.processBlock(this.buf2, 0, byArray2, n2, this.kEnc3, this.halves);
    }

    public void encryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertEncryption();
        DES.processBlock(byArray, n, this.buf1, 0, this.kEnc, this.halves);
        DES.processBlock(this.buf1, 0, this.buf2, 0, this.kDec2, this.halves);
        DES.processBlock(this.buf2, 0, byArray2, n2, this.kEnc3, this.halves);
    }

    public void erase() {
        super.erase();
        Utils.setArray(this.kEnc, 0);
        Utils.setArray(this.kEnc2, 0);
        Utils.setArray(this.kEnc3, 0);
        Utils.setArray(this.kDec, 0);
        Utils.setArray(this.kDec2, 0);
        Utils.setArray(this.kDec3, 0);
        Utils.setArray(this.buf1, (byte)0);
        Utils.setArray(this.buf2, (byte)0);
    }

    public AlgorithmIdentifier getAlgID() {
        if (this.mode == 0) {
            return new AlgorithmIdentifier(AlgID.DES_EDE3_ECB.getOID());
        }
        if (this.mode == 1) {
            return new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), this.getIV());
        }
        throw new IllegalStateException("unknown mode " + this.mode);
    }

    private void init(int n) {
        if (n == 0) {
            this.mode = n;
        } else if (n == 1) {
            this.mode = n;
            this.initCBC(null);
        } else {
            throw new IllegalArgumentException("invalid cipher mode " + n);
        }
    }

    private void init(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.DES_EDE3_ECB.getOID())) {
            this.init(0);
        } else if (algorithmIdentifier.getOID().equals(AlgID.DES_EDE3_CBC.getOID())) {
            this.init(1);
            this.initCBC(CryptoUtils.getIV(algorithmIdentifier));
        } else {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier " + algorithmIdentifier + " for DES_EDE");
        }
    }

    private void initCBC(byte[] byArray) {
        byte[] byArray2 = this.getIV();
        String string = "couldn't reset cipher IV";
        if (byArray != null) {
            string = "couldn't set IV provided with algID";
        } else if (byArray2 != null) {
            byArray = byArray2;
            string = "couldn't reset cipher IV";
        } else if (byArray2 == null) {
            byArray = this.getRBS().randomBytes(new byte[this.blockSize]);
            string = "couldn't randomize cipher IV";
        }
        try {
            this.setIV(byArray);
        }
        catch (CipherException cipherException) {
            throw new IllegalStateException(String.valueOf(string) + ":  " + cipherException.toString());
        }
        this.paddingID = Padding.PKCS5;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("The key is not an instance of SymmetricKey");
        }
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        super.setKey((SymmetricKey)key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.rbs = null;
        try {
            this.setIV(null);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.getMessage());
        }
        this.init(algorithmIdentifier);
        this.paddingID = Padding.NONE;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        super.setKey(symmetricKey);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.rbs = null;
        this.setIV(null);
        this.init(algorithmIdentifier);
        this.paddingID = iD;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.init(algorithmIdentifier);
        this.releaseOp();
    }

    public void setDecryptionKey(Key key) throws InvalidKeyException {
        super.setDecryptionKey(key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    public void setEncryptionKey(Key key) throws InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("Key must be an instance of a SymmetricKey to be used with the DES_EDE cipher");
        }
        super.setEncryptionKey(key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    public void setKey(SymmetricKey symmetricKey) throws InvalidKeyException {
        if (!(symmetricKey instanceof SymmetricKey)) {
            throw new InvalidKeyException("Key must be an instance of a SymmetricKey to be used with the DES_EDE cipher");
        }
        super.setKey(symmetricKey);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    private void setKeyMaterial(SymmetricKey symmetricKey) throws InvalidKeyException {
        if (symmetricKey.getBytes().length != 24 && symmetricKey.getBytes().length != 16 && symmetricKey.getBytes().length != 8) {
            throw new IllegalArgumentException("DES-EDE key must be 8, 16 or 24 bytes long.");
        }
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        System.arraycopy(symmetricKey.getBytes(), 0, byArray, 0, 8);
        if (symmetricKey.getBytes().length > 8) {
            System.arraycopy(symmetricKey.getBytes(), 8, byArray2, 0, 8);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, 8);
        }
        if (symmetricKey.getBytes().length > 16) {
            System.arraycopy(symmetricKey.getBytes(), 16, byArray3, 0, 8);
        } else {
            System.arraycopy(byArray, 0, byArray3, 0, 8);
        }
        this.kEnc = new int[32];
        this.kDec = new int[32];
        this.kEnc2 = new int[32];
        this.kDec2 = new int[32];
        this.kEnc3 = new int[32];
        this.kDec3 = new int[32];
        DES.initKey(byArray, this.kEnc, true);
        DES.initKey(byArray, this.kDec, false);
        DES.initKey(byArray2, this.kEnc2, true);
        DES.initKey(byArray2, this.kDec2, false);
        DES.initKey(byArray3, this.kEnc3, true);
        DES.initKey(byArray3, this.kDec3, false);
        if (this.buf1 == null) {
            this.buf1 = new byte[8];
            this.buf2 = new byte[8];
        }
        Utils.setArray(byArray, (byte)0);
        Utils.setArray(byArray2, (byte)0);
        Utils.setArray(byArray3, (byte)0);
    }

    public void setMode(int n) {
        if (n == 0) {
            this.init(n);
        } else if (n == 1) {
            this.init(n);
        } else {
            throw new IllegalArgumentException("The value, " + n + ", is not recognized " + "as a valid block mode");
        }
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    public String toString() {
        return "DES-EDE" + (this.mode == 1 ? "-CBC" : "") + (this.getKey() != null ? "; key = " + Utils.toHexString(this.getKey().getBytes()) : "") + "; iv = " + Utils.toHexString(this.getIV());
    }
}

