/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.DHPrivateKey;
import com.phaos.crypto.DHPublicKey;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.KeyAgreement;
import com.phaos.crypto.KeyAgreementException;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import java.math.BigInteger;

public class DHKeyAgreement
extends KeyAgreement {
    private static final ASN1ObjectID dhAlgOID = AlgID.dh.getOID();
    private DHPublicKey pubKey;
    private DHPrivateKey privKey;

    public DHKeyAgreement() {
    }

    public DHKeyAgreement(DHPrivateKey dHPrivateKey) throws InvalidKeyException {
        this.setPrivateKey(dHPrivateKey);
    }

    public DHKeyAgreement(DHPrivateKey dHPrivateKey, DHPublicKey dHPublicKey) throws InvalidKeyException {
        this.setPrivateKey(dHPrivateKey);
        this.setPublicKey(dHPublicKey);
    }

    public DHKeyAgreement(DHPublicKey dHPublicKey) throws InvalidKeyException {
        this.setPublicKey(dHPublicKey);
    }

    public String algName() {
        return "Diffie-Hellman";
    }

    public byte[] generateSecret() throws KeyAgreementException {
        if (this.privKey == null) {
            throw new IllegalStateException("Local party private key is not set yet.");
        }
        if (this.pubKey == null) {
            throw new IllegalStateException("Other party public key is not set yet.");
        }
        DHParams dHParams = this.privKey.getParams();
        DHParams dHParams2 = this.pubKey.getParams();
        BigInteger bigInteger = dHParams.getP();
        BigInteger bigInteger2 = dHParams.getG();
        BigInteger bigInteger3 = dHParams.getQ();
        if (bigInteger.compareTo(dHParams2.getP()) != 0 || bigInteger2.compareTo(dHParams2.getG()) != 0 || bigInteger3.compareTo(dHParams2.getQ()) != 0) {
            throw new KeyAgreementException("The parameters of the local party private key and the other party public key are not matching.");
        }
        BigInteger bigInteger4 = this.pubKey.getY().modPow(this.privKey.getX(), bigInteger);
        if (bigInteger4.compareTo(BigInteger.valueOf(1L)) == 0) {
            throw new KeyAgreementException("A trivial secret value is generated.");
        }
        return bigInteger4.toByteArray();
    }

    public AlgorithmIdentifier getAlgID() {
        return new AlgorithmIdentifier(dhAlgOID, false);
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (!algorithmIdentifier.getOID().equals(dhAlgOID)) {
            throw new AlgorithmIdentifierException("Not a Diffie-Hellman key agreement algorithm identifier.");
        }
    }

    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DHPrivateKey)) {
            throw new InvalidKeyException("The key is not a DHPrivateKey.");
        }
        DHParams dHParams = ((DHPrivateKey)privateKey).getParams();
        if (dHParams == null || dHParams.getP() == null || dHParams.getQ() == null || dHParams.getG() == null) {
            throw new InvalidKeyException("Missing parameters in the private key");
        }
        this.privKey = (DHPrivateKey)privateKey;
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DHPublicKey)) {
            throw new InvalidKeyException("The key is not a DHPublicKey.");
        }
        DHParams dHParams = ((DHPublicKey)publicKey).getParams();
        if (dHParams == null || dHParams.getP() == null || dHParams.getQ() == null || dHParams.getG() == null) {
            throw new InvalidKeyException("Missing parameters in the public key");
        }
        this.pubKey = (DHPublicKey)publicKey;
    }
}

