/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHParameterGenerator;
import com.phaos.crypto.MessageDigest;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class DHParams
implements ASN1Object {
    private BigInteger p;
    private BigInteger g;
    private BigInteger q;
    private BigInteger j;
    private byte[] seed;
    private int pgenCounter;
    private ASN1Sequence contents;
    private static final BigInteger one = BigInteger.valueOf(1L);
    private static final BigInteger two = BigInteger.valueOf(2L);

    public DHParams(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = bigInteger;
        this.g = bigInteger2;
        this.q = bigInteger3;
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(bigInteger, bigInteger2, bigInteger3);
        this.j = bigInteger4;
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray, int n) {
        this(bigInteger, bigInteger2, bigInteger3, byArray, n);
        this.j = bigInteger4;
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, int n) {
        this(bigInteger, bigInteger2, bigInteger3);
        this.seed = byArray;
        this.pgenCounter = n;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public BigInteger getP() {
        return this.p;
    }

    public int getPGenCounter() {
        return this.pgenCounter;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public byte[] getSeed() {
        return (byte[])this.seed.clone();
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.p = ASN1Integer.inputValue(aSN1SequenceInputStream);
        this.g = ASN1Integer.inputValue(aSN1SequenceInputStream);
        this.q = ASN1Integer.inputValue(aSN1SequenceInputStream);
        this.j = aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 2 ? ASN1Integer.inputValue(aSN1SequenceInputStream) : null;
        if (aSN1SequenceInputStream.hasMoreData()) {
            ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            this.seed = ASN1BitString.inputValue(aSN1SequenceInputStream2);
            this.pgenCounter = new ASN1Integer(aSN1SequenceInputStream2).intValue();
            aSN1SequenceInputStream2.terminate();
        } else {
            this.seed = null;
            this.pgenCounter = 0;
        }
        aSN1SequenceInputStream.terminate();
    }

    public static boolean isValidParams(DHParams dHParams, int n, int n2) {
        if (n % 256 != 0 || n < 1024 || n2 < 160) {
            throw new IllegalArgumentException("Invalid parameters bit length: L=" + n + ", m=" + n2);
        }
        byte[] byArray = dHParams.getSeed();
        int n3 = dHParams.getPGenCounter();
        if (byArray == null) {
            throw new IllegalArgumentException("Missing validation parameters");
        }
        int n4 = n / 1024;
        if (n4 * 1024 < n) {
            ++n4;
        }
        if (n3 >= 4096 * n4 || n3 <= 0) {
            return false;
        }
        BigInteger bigInteger = dHParams.getP();
        BigInteger bigInteger2 = dHParams.getQ();
        BigInteger bigInteger3 = dHParams.getJ();
        if (bigInteger3 != null && (bigInteger3.compareTo(two) < 0 || bigInteger.compareTo(bigInteger3.multiply(bigInteger2).add(one)) != 0)) {
            return false;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException(algorithmIdentifierException.toString());
        }
        BigInteger bigInteger4 = DHParameterGenerator.generateQ(byArray, n2, messageDigest);
        if (!bigInteger4.isProbablePrime(100) || bigInteger4.compareTo(bigInteger2) != 0) {
            return false;
        }
        BigInteger bigInteger5 = null;
        int n5 = 0;
        while (!((bigInteger5 = DHParameterGenerator.generateP(bigInteger4, byArray, n5, n, n2, messageDigest)).compareTo(one.shiftLeft(n - 1)) > 0 && bigInteger5.isProbablePrime(100) || ++n5 > n3)) {
        }
        if (n5 != n3 || bigInteger5.compareTo(bigInteger) != 0) {
            return false;
        }
        BigInteger bigInteger6 = dHParams.getG();
        return bigInteger6.compareTo(two) >= 0 && bigInteger6.compareTo(bigInteger5.subtract(two)) <= 0 && bigInteger6.modPow(bigInteger4, bigInteger5).compareTo(one) == 0;
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(this.p));
            aSN1Sequence.addElement(new ASN1Integer(this.g));
            aSN1Sequence.addElement(new ASN1Integer(this.q));
            if (this.j != null) {
                aSN1Sequence.addElement(new ASN1Integer(this.j));
            }
            if (this.seed != null) {
                ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                aSN1Sequence2.addElement(new ASN1BitString(this.seed));
                aSN1Sequence2.addElement(new ASN1Integer(this.pgenCounter));
                aSN1Sequence.addElement(aSN1Sequence2);
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{p = ");
        stringBuffer.append(this.p);
        stringBuffer.append(", g = ");
        stringBuffer.append(this.g);
        stringBuffer.append(", q = ");
        stringBuffer.append(this.q);
        if (this.j != null) {
            stringBuffer.append(", j = ");
            stringBuffer.append(this.j);
        }
        if (this.seed != null) {
            stringBuffer.append(",\nseed = ");
            stringBuffer.append(Utils.toHexString(this.seed));
            stringBuffer.append(", pgenCounter = ");
            stringBuffer.append(String.valueOf(this.pgenCounter) + " }");
        }
        return stringBuffer.toString();
    }
}

