/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHKey;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.PublicKey;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class DHPublicKey
extends DHKey
implements PublicKey {
    private static final ASN1ObjectID algOID = AlgID.dh.getOID();
    private BigInteger y;
    private ASN1Sequence spki;

    public DHPublicKey() {
    }

    public DHPublicKey(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public DHPublicKey(BigInteger bigInteger, DHParams dHParams) {
        super(dHParams);
        this.y = bigInteger;
    }

    public Object clone() {
        DHPublicKey dHPublicKey = new DHPublicKey();
        try {
            if (this.spki != null) {
                dHPublicKey.spki = new ASN1Sequence(Utils.toStream(this.spki));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key contents to stream");
        }
        try {
            if (this.params != null) {
                dHPublicKey.params = new DHParams(Utils.toStream(this.params));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key DH parameters to stream");
        }
        if (this.y != null) {
            dHPublicKey.y = new BigInteger(this.y.toByteArray());
        }
        return dHPublicKey;
    }

    public void erase() {
        this.params = null;
        this.y = null;
    }

    public AlgorithmIdentifier getAlgID() {
        return new AlgorithmIdentifier(algOID, this.params);
    }

    public ASN1Object getContents() {
        return new ASN1Integer(this.y);
    }

    public String getFormat() {
        return "X.509";
    }

    public BigInteger getY() {
        return this.y;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        if (!algOID.equals(algorithmIdentifier.getOID())) {
            throw new AlgorithmIdentifierException("Wrong algorithm identifier for Diffier-Hellman key.");
        }
        try {
            ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
            if (aSN1Object2 != null) {
                this.params = aSN1Object2 instanceof DHParams ? (DHParams)aSN1Object2 : new DHParams(Utils.toStream((ASN1Sequence)aSN1Object2));
            }
        }
        catch (IOException iOException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters.");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters.");
        }
        try {
            this.y = ((ASN1Integer)aSN1Object).getValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException("Contents invalid.");
        }
        this.spki = null;
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(0));
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1BitString)aSN1Sequence.elementAt(1)).getValue());
            this.initialize(algorithmIdentifier, aSN1Object);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidInputException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    public void setParams(DHParams dHParams) {
        if (dHParams.getP() == null || dHParams.getQ() == null || dHParams.getG() == null) {
            throw new IllegalArgumentException("Missing P or Q or G in the params");
        }
        this.params = dHParams;
        this.spki = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.spki == null) {
            this.spki = CryptoUtils.subjectPublicKeyInfo(this);
        }
        return this.spki;
    }

    public String toString() {
        return "{params = " + this.params + ", y = " + this.y + "}";
    }
}

