/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class DigestInfo
implements ASN1Object {
    private AlgorithmIdentifier digestAlgID;
    private byte[] digest;
    private ASN1Sequence contents = null;

    public DigestInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.digestAlgID = algorithmIdentifier;
        this.digest = byArray;
    }

    public DigestInfo(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public boolean equals(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        return algorithmIdentifier.equals(this.digestAlgID) && Utils.areEqual(byArray, this.digest);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DigestInfo)) {
            return false;
        }
        DigestInfo digestInfo = (DigestInfo)object;
        return this.equals(digestInfo.digestAlgID, digestInfo.digest);
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public AlgorithmIdentifier getDigestAlgID() {
        return this.digestAlgID;
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.digestAlgID = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.digest = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        this.update();
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.digestAlgID);
            aSN1Sequence.addElement(new ASN1OctetString(this.digest));
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.digestAlgID)) + ": " + Utils.toHexString(this.digest);
    }

    private void update() {
        this.contents = null;
    }
}

