/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.MessageDigest;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DigestInputStream
extends FilterInputStream {
    protected MessageDigest messageDigest;

    public DigestInputStream(InputStream inputStream, MessageDigest messageDigest) {
        super(inputStream);
        this.messageDigest = messageDigest;
    }

    public byte[] computeCurrent() {
        this.messageDigest.computeCurrent();
        return this.messageDigest.getDigestBits();
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public synchronized int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            this.messageDigest.update((byte)n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) break;
            byArray[n + n3] = (byte)n4;
            ++n3;
        }
        return n3 != 0 ? n3 : -1;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }
}

