/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.SREntropySource;

public abstract class EntropySource {
    private static EntropySource defaultEntropySource;
    private static final Object obj;

    static {
        obj = new Object();
    }

    protected EntropySource() {
    }

    public abstract void clear();

    public abstract byte generateByte();

    public synchronized byte[] generateBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = this.generateByte();
            ++n;
        }
        return byArray;
    }

    public static EntropySource getDefault() {
        Object object = obj;
        synchronized (object) {
            if (defaultEntropySource == null) {
                defaultEntropySource = new SREntropySource();
            }
        }
        return defaultEntropySource;
    }

    public static void setDefault(EntropySource entropySource) {
        Object object = obj;
        synchronized (object) {
            defaultEntropySource = entropySource;
        }
    }
}

