/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.KeyAgreementException;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.utils.OIDManager;

public abstract class KeyAgreement {
    protected KeyAgreement() {
    }

    public abstract String algName();

    public abstract byte[] generateSecret() throws KeyAgreementException;

    public abstract AlgorithmIdentifier getAlgID();

    public static KeyAgreement getInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        KeyAgreement keyAgreement;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "keyAgreement");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        try {
            keyAgreement = (KeyAgreement)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement KeyAgreement.");
        }
        keyAgreement.setAlgID(algorithmIdentifier);
        return keyAgreement;
    }

    public static KeyAgreement getInstance(PrivateKey privateKey) throws KeyAgreementException {
        KeyAgreement keyAgreement;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(privateKey.getAlgID().getOID(), "useKeyAgreement");
        if (clazz == null) {
            throw new KeyAgreementException("Cannot find a key agreement algorithm for this key with " + privateKey.getAlgID().getOID());
        }
        try {
            keyAgreement = (KeyAgreement)clazz.newInstance();
            keyAgreement.setPrivateKey(privateKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KeyAgreementException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new KeyAgreementException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new KeyAgreementException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyAgreementException(invalidKeyException.toString());
        }
        return keyAgreement;
    }

    public static KeyAgreement getInstance(PublicKey publicKey) throws KeyAgreementException {
        KeyAgreement keyAgreement;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(publicKey.getAlgID().getOID(), "useKeyAgreement");
        if (clazz == null) {
            throw new KeyAgreementException("Can not find a keyAgreement algorithm for this key with " + publicKey.getAlgID().getOID());
        }
        try {
            keyAgreement = (KeyAgreement)clazz.newInstance();
            keyAgreement.setPublicKey(publicKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KeyAgreementException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new KeyAgreementException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new KeyAgreementException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyAgreementException(invalidKeyException.toString());
        }
        return keyAgreement;
    }

    public abstract PublicKey getPublicKey();

    public abstract void setAlgID(AlgorithmIdentifier var1) throws AlgorithmIdentifierException;

    public abstract void setPrivateKey(PrivateKey var1) throws InvalidKeyException;

    public abstract void setPublicKey(PublicKey var1) throws InvalidKeyException;
}

