/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.OIDManager;

public abstract class KeyPairGenerator {
    protected RandomBitsSource rbs;

    protected KeyPairGenerator() {
    }

    public abstract KeyPair generateKeyPair();

    public abstract String getAlgorithm();

    public static KeyPairGenerator getInstance(AlgorithmIdentifier algorithmIdentifier) throws IllegalArgumentException {
        KeyPairGenerator keyPairGenerator;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "keyPairGenerator");
        if (clazz == null) {
            throw new IllegalArgumentException("Can not find a key pair generator for this algorithm ID.");
        }
        try {
            keyPairGenerator = (KeyPairGenerator)clazz.newInstance();
            keyPairGenerator.setAlgID(algorithmIdentifier);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Unable to access " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.toString());
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalArgumentException(algorithmIdentifierException.toString());
        }
        return keyPairGenerator;
    }

    public static KeyPairGenerator getInstance(String string) throws IllegalArgumentException {
        if (string.equals("RSA")) {
            return KeyPairGenerator.getInstance(AlgID.rsaEncryption);
        }
        if (string.equals("DSA")) {
            return KeyPairGenerator.getInstance(AlgID.dsa);
        }
        if (string.equals("DSAold")) {
            return KeyPairGenerator.getInstance(AlgID.dsaOld);
        }
        if (string.equals("Diffie-Hellman")) {
            return KeyPairGenerator.getInstance(AlgID.dh);
        }
        throw new IllegalArgumentException("Unrecognized key algorithm: " + string);
    }

    public abstract void initialize(int var1, RandomBitsSource var2);

    public abstract void setAlgID(AlgorithmIdentifier var1) throws AlgorithmIdentifierException;

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        this.rbs = randomBitsSource;
    }
}

