/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.utils.OIDManager;
import com.phaos.utils.Streamable;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public abstract class MessageDigest
implements Cloneable {
    public byte[] digestBits;
    public boolean digestValid;
    protected AlgorithmIdentifier algID;

    protected MessageDigest() {
    }

    public abstract String algName();

    public abstract int blockSize();

    public abstract Object clone();

    public abstract void computeCurrent();

    public byte[] computeDigest(Streamable streamable) throws IOException {
        return this.computeDigest(Utils.toBytes(streamable));
    }

    public byte[] computeDigest(byte[] byArray) {
        this.init();
        this.update(byArray);
        this.computeCurrent();
        return this.getDigestBits();
    }

    public abstract AlgorithmIdentifier getAlgID();

    public byte[] getDigestBits() {
        return (byte[])this.digestBits.clone();
    }

    public abstract int getDigestLength();

    public static MessageDigest getInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        MessageDigest messageDigest;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "messageDigest");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        try {
            messageDigest = (MessageDigest)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement Message Digest.");
        }
        messageDigest.setAlgID(algorithmIdentifier);
        return messageDigest;
    }

    protected abstract MDState getState();

    public abstract void init();

    public boolean isEqual(byte[] byArray) {
        return Utils.areEqual(this.digestBits, byArray);
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        return Utils.areEqual(byArray, byArray2);
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.algID = algorithmIdentifier;
    }

    protected abstract void setState(MDState var1);

    public String toString() {
        return String.valueOf(this.algName()) + (this.digestValid ? " " + Utils.toHexString(this.digestBits) : "");
    }

    public abstract void update(byte var1);

    public void update(int n) {
        this.update(Utils.wordToBytes(n));
    }

    public void update(long l) {
        this.update(Utils.longToBytes(l));
    }

    public void update(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            this.update(byArray, 0, n);
        }
    }

    public void update(String string) {
        this.update(Utils.unicodeToBytes(string));
    }

    public void update(short s) {
        this.update(Utils.shortToBytes(s));
    }

    public void update(boolean bl) {
        if (bl) {
            this.update((byte)1);
        } else {
            this.update((byte)0);
        }
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.update(byArray[n3]);
            ++n3;
        }
    }

    public void update(int[] nArray) {
        byte[] byArray = new byte[nArray.length << 2];
        Utils.wordsToBytes(nArray, byArray);
        this.update(byArray);
    }

    public void update(long[] lArray) {
        byte[] byArray = new byte[lArray.length << 3];
        Utils.longsToBytes(lArray, byArray);
        this.update(byArray);
    }

    public void update(short[] sArray) {
        byte[] byArray = new byte[sArray.length << 1];
        Utils.shortsToBytes(sArray, byArray);
        this.update(byArray);
    }

    public void updateASCII(String string) {
        this.update(string.getBytes());
    }

    public abstract class MDState {
        protected MDState() {
        }

        public abstract Object clone();

        public abstract void copyTo(MDState var1);

        public abstract void init();
    }
}

