/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;

public final class NullCipher
extends Cipher {
    public String algName() {
        return "NullCipher";
    }

    public int blockSize() {
        return 1;
    }

    public byte[] decrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        this.assertDecryption();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.assertDecryption();
        System.arraycopy(byArray, n, byArray2, n3, n2);
    }

    public void decryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertDecryption();
        byArray2[n2] = byArray[n];
    }

    public byte[] encrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        this.assertEncryption();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.assertEncryption();
        System.arraycopy(byArray, n, byArray2, n3, n2);
    }

    public void encryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertEncryption();
        byArray2[n2] = byArray[n];
    }

    public void erase() {
        super.erase();
    }

    public AlgorithmIdentifier getAlgID() {
        return null;
    }

    public int getBlockSize() {
        return 1;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        super.erase();
        this.key = key != null ? (Key)key.clone() : null;
        this.encryptionKey = this.key;
        this.decryptionKey = this.key;
        this.releaseOp();
        this.rbs = null;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        throw new AlgorithmIdentifierException("Method 'setAlgID' not valid for NullCipher");
    }
}

