/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class OAEPAlgorithmIdentifier
extends AlgorithmIdentifier {
    static final ASN1ObjectID OAEP_OID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 7);
    static final ASN1ObjectID P_SPECIFIED_OID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 9);
    static final AlgorithmIdentifier pSpecifiedEmptyIdentifier = new AlgorithmIdentifier(P_SPECIFIED_OID, new ASN1OctetString(new byte[0]));
    private AlgorithmIdentifier hashFunc;
    private AlgorithmIdentifier maskGenFunc;
    private AlgorithmIdentifier pSourceFunc;

    public OAEPAlgorithmIdentifier() {
        this(AlgID.sha1, AlgID.mgf1WithSHA1, pSpecifiedEmptyIdentifier);
    }

    public OAEPAlgorithmIdentifier(ASN1Object aSN1Object) throws AlgorithmIdentifierException {
        super(OAEP_OID, aSN1Object);
        this.decodeParameters();
    }

    public OAEPAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, AlgorithmIdentifier algorithmIdentifier3) {
        super(OAEP_OID, OAEPAlgorithmIdentifier.makeParameters(algorithmIdentifier, algorithmIdentifier2, algorithmIdentifier3));
        this.hashFunc = algorithmIdentifier;
        this.maskGenFunc = algorithmIdentifier2;
        this.pSourceFunc = algorithmIdentifier3;
    }

    public OAEPAlgorithmIdentifier(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public Object clone() {
        AlgorithmIdentifier algorithmIdentifier = null;
        AlgorithmIdentifier algorithmIdentifier2 = null;
        AlgorithmIdentifier algorithmIdentifier3 = null;
        if (this.hashFunc != null) {
            algorithmIdentifier = (AlgorithmIdentifier)this.hashFunc.clone();
        }
        if (this.maskGenFunc != null) {
            algorithmIdentifier2 = (AlgorithmIdentifier)this.maskGenFunc.clone();
        }
        if (this.pSourceFunc != null) {
            algorithmIdentifier3 = (AlgorithmIdentifier)this.pSourceFunc.clone();
        }
        return new OAEPAlgorithmIdentifier(algorithmIdentifier, algorithmIdentifier2, algorithmIdentifier3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeParameters() throws AlgorithmIdentifierException {
        ASN1Sequence aSN1Sequence;
        Vector vector;
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)this.getParameters();
        Vector vector2 = aSN1Sequence2.elements();
        if (vector2.size() > 3) {
            throw new AlgorithmIdentifierException("Parameters not formatted correctly");
        }
        int n = 0;
        int n2 = vector2.size();
        if (n2 == 0) {
            this.hashFunc = AlgID.sha1;
            this.maskGenFunc = AlgID.mgf1WithSHA1;
            this.pSourceFunc = pSpecifiedEmptyIdentifier;
            return;
        }
        ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)vector2.elementAt(n);
        if (aSN1GenericConstructed.getTag() == 0) {
            ++n;
            vector = aSN1GenericConstructed.elements();
            if (vector.size() != 1) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
            if (vector.elementAt(0) instanceof ASN1Sequence) {
                aSN1Sequence = (ASN1Sequence)vector.elementAt(0);
                this.hashFunc = new AlgorithmIdentifier((ASN1ObjectID)aSN1Sequence.elementAt(0), aSN1Sequence.elementAt(1));
            } else {
                if (!(vector.elementAt(0) instanceof AlgorithmIdentifier)) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
                this.hashFunc = (AlgorithmIdentifier)vector.elementAt(0);
            }
            if (n == n2) {
                this.maskGenFunc = AlgID.mgf1WithSHA1;
                this.pSourceFunc = pSpecifiedEmptyIdentifier;
                return;
            }
            aSN1GenericConstructed = (ASN1GenericConstructed)vector2.elementAt(n);
        } else {
            this.hashFunc = AlgID.sha1;
        }
        if (aSN1GenericConstructed.getTag() == 1) {
            ++n;
            vector = aSN1GenericConstructed.elements();
            if (vector.size() != 1) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
            if (vector.elementAt(0) instanceof ASN1Sequence) {
                aSN1Sequence = (ASN1Sequence)vector.elementAt(0);
                this.maskGenFunc = new AlgorithmIdentifier((ASN1ObjectID)aSN1Sequence.elementAt(0), aSN1Sequence.elementAt(1));
            } else {
                if (!(vector.elementAt(0) instanceof AlgorithmIdentifier)) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
                this.maskGenFunc = (AlgorithmIdentifier)vector.elementAt(0);
            }
            if (n == n2) {
                this.pSourceFunc = pSpecifiedEmptyIdentifier;
                return;
            }
            aSN1GenericConstructed = (ASN1GenericConstructed)vector2.elementAt(n);
        } else {
            this.maskGenFunc = AlgID.mgf1WithSHA1;
        }
        if (aSN1GenericConstructed.getTag() != 2) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
        ++n;
        vector = aSN1GenericConstructed.elements();
        if (vector.size() != 1) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
        if (vector.elementAt(0) instanceof ASN1Sequence) {
            aSN1Sequence = (ASN1Sequence)vector.elementAt(0);
            this.pSourceFunc = new AlgorithmIdentifier((ASN1ObjectID)aSN1Sequence.elementAt(0), aSN1Sequence.elementAt(1));
            return;
        } else {
            if (!(vector.elementAt(0) instanceof AlgorithmIdentifier)) throw new AlgorithmIdentifierException("Parameters not formatted correctly");
            this.pSourceFunc = (AlgorithmIdentifier)vector.elementAt(0);
        }
    }

    public AlgorithmIdentifier getHashFunc() {
        return (AlgorithmIdentifier)this.hashFunc.clone();
    }

    public AlgorithmIdentifier getMaskGenFunc() {
        return (AlgorithmIdentifier)this.maskGenFunc.clone();
    }

    public AlgorithmIdentifier getPSourceFunc() {
        return this.pSourceFunc;
    }

    public void input(InputStream inputStream) throws IOException {
        super.input(inputStream);
        try {
            this.decodeParameters();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException("Problem decoding the parameters: " + algorithmIdentifierException.getMessage());
        }
    }

    private static ASN1Object makeParameters(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, AlgorithmIdentifier algorithmIdentifier3) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (!algorithmIdentifier.equals(AlgID.sha1)) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(algorithmIdentifier, 0));
        }
        if (!algorithmIdentifier2.equals(AlgID.mgf1WithSHA1)) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(algorithmIdentifier2, 1));
        }
        if (!algorithmIdentifier3.equals(pSpecifiedEmptyIdentifier)) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(algorithmIdentifier3, 2));
        }
        return aSN1Sequence;
    }
}

