/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.HMAC;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PBMacAlgID;
import com.phaos.crypto.RandomBitsSource;
import java.math.BigInteger;

public class PasswordBasedMAC
extends MessageDigest {
    public static final int DEFAULT_SALT_LEN = 8;
    public static final AlgorithmIdentifier DEFAULT_OWF = AlgID.sha1;
    public static final int DEFAULT_ITER_COUNT = 1024;
    public static final AlgorithmIdentifier DEFAULT_MAC = AlgID.hmacSHA;
    private byte[] salt;
    private AlgorithmIdentifier owfAlgID;
    private int count;
    private AlgorithmIdentifier macAlgID;
    private RandomBitsSource rbs;
    private byte[] password;
    private byte[] baseKey;
    private MessageDigest owf;
    private MessageDigest mac;

    public PasswordBasedMAC() {
    }

    public PasswordBasedMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws AlgorithmIdentifierException {
        this.setAlgID(algorithmIdentifier);
        this.setPassword(byArray);
    }

    public PasswordBasedMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        this.setRandomBitsSource(randomBitsSource);
        this.setAlgID(algorithmIdentifier);
        this.setPassword(byArray);
    }

    public PasswordBasedMAC(byte[] byArray) throws AlgorithmIdentifierException {
        this(AlgID.PasswordBasedMac, byArray);
    }

    public String algName() {
        return "PasswordBasedMac";
    }

    public int blockSize() {
        return this.mac.blockSize();
    }

    public Object clone() {
        PasswordBasedMAC passwordBasedMAC = new PasswordBasedMAC();
        passwordBasedMAC.digestBits = (byte[])this.digestBits.clone();
        passwordBasedMAC.digestValid = this.digestValid;
        passwordBasedMAC.salt = (byte[])this.salt.clone();
        passwordBasedMAC.owfAlgID = new AlgorithmIdentifier(this.owfAlgID.getOID(), this.owfAlgID.getParameters());
        passwordBasedMAC.count = this.count;
        passwordBasedMAC.macAlgID = new AlgorithmIdentifier(this.macAlgID.getOID(), this.macAlgID.getParameters());
        passwordBasedMAC.rbs = this.rbs;
        passwordBasedMAC.password = (byte[])this.password.clone();
        passwordBasedMAC.baseKey = (byte[])this.baseKey.clone();
        passwordBasedMAC.owf = (MessageDigest)this.owf.clone();
        passwordBasedMAC.mac = (MessageDigest)this.mac.clone();
        return passwordBasedMAC;
    }

    public void computeCurrent() {
        this.mac.computeCurrent();
        System.arraycopy(this.mac.digestBits, 0, this.digestBits, 0, this.digestBits.length);
        this.digestValid = true;
    }

    private byte[] genBaseKey() {
        if (this.salt == null) {
            if (this.rbs == null) {
                this.rbs = RandomBitsSource.getDefault();
            }
            this.salt = new byte[8];
            this.rbs.randomBytes(this.salt);
        }
        byte[] byArray = new byte[this.owf.getDigestLength()];
        this.owf.init();
        this.owf.update(this.password);
        this.owf.update(this.salt);
        this.owf.computeCurrent();
        System.arraycopy(this.owf.digestBits, 0, byArray, 0, this.owf.digestBits.length);
        int n = 1;
        while (n < this.count) {
            System.arraycopy(this.owf.computeDigest(byArray), 0, byArray, 0, this.owf.digestBits.length);
            ++n;
        }
        return byArray;
    }

    public AlgorithmIdentifier getAlgID() {
        if (this.algID == null) {
            if (this.salt == null && this.rbs != null) {
                this.salt = new byte[8];
                this.rbs.randomBytes(this.salt);
            }
            if (this.salt == null || this.owfAlgID == null || this.count <= 0 || this.macAlgID == null) {
                return AlgID.PasswordBasedMac;
            }
            try {
                this.algID = new PBMacAlgID(this.salt, this.owfAlgID, BigInteger.valueOf(this.count), this.macAlgID);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        }
        return this.algID;
    }

    public int getCount() {
        return this.count;
    }

    public int getDigestLength() {
        return this.mac.getDigestLength();
    }

    public AlgorithmIdentifier getMacAlgID() {
        return this.macAlgID;
    }

    public AlgorithmIdentifier getOwfAlgID() {
        return this.owfAlgID;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    protected MessageDigest.MDState getState() {
        return null;
    }

    public void init() {
        try {
            if (this.owf == null) {
                this.owf = MessageDigest.getInstance(this.owfAlgID);
            }
            if (this.mac == null) {
                this.mac = MessageDigest.getInstance(this.macAlgID);
                this.digestBits = new byte[this.mac.getDigestLength()];
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
        if (this.baseKey == null) {
            this.baseKey = this.genBaseKey();
            ((HMAC)this.mac).setKey(this.baseKey);
        }
        this.mac.init();
        this.digestValid = false;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier.getOID();
        if (!aSN1ObjectID.equals(AlgID.PasswordBasedMac.getOID())) {
            throw new AlgorithmIdentifierException("Invalid algorithm OID: " + aSN1ObjectID);
        }
        ASN1Object aSN1Object = algorithmIdentifier.getParameters();
        if (aSN1Object != null) {
            PBMacAlgID pBMacAlgID = new PBMacAlgID(aSN1Object);
            this.salt = pBMacAlgID.getSalt();
            this.owfAlgID = pBMacAlgID.getOwfAlgID();
            this.count = pBMacAlgID.getCount().intValue();
            this.setMacAlgID(pBMacAlgID.getMacAlgID());
            this.algID = pBMacAlgID;
        } else {
            if (this.rbs != null) {
                this.salt = new byte[8];
                this.rbs.randomBytes(this.salt);
            } else {
                this.salt = null;
            }
            this.owfAlgID = DEFAULT_OWF;
            this.count = 1024;
            this.macAlgID = DEFAULT_MAC;
        }
        this.baseKey = null;
        this.owf = MessageDigest.getInstance(this.owfAlgID);
        this.mac = MessageDigest.getInstance(this.macAlgID);
        this.digestBits = new byte[this.mac.getDigestLength()];
        this.digestValid = false;
    }

    public void setCount(int n) {
        this.count = n;
        this.baseKey = null;
        this.digestValid = false;
    }

    public void setMacAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier.getOID();
        if (!aSN1ObjectID.equals(AlgID.hmacSHA.getOID()) && !aSN1ObjectID.equals(AlgID.hmacMD5.getOID())) {
            throw new AlgorithmIdentifierException("Unsupported MAC algorithm: " + aSN1ObjectID);
        }
        this.macAlgID = algorithmIdentifier;
    }

    public void setOwfAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.owfAlgID = algorithmIdentifier;
        this.baseKey = null;
        this.digestValid = false;
    }

    public void setPassword(byte[] byArray) {
        this.password = byArray;
        this.baseKey = null;
        this.digestValid = false;
    }

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        this.rbs = randomBitsSource;
    }

    public void setSalt(byte[] byArray) {
        this.salt = byArray;
        this.baseKey = null;
        this.digestValid = false;
    }

    protected void setState(MessageDigest.MDState mDState) {
        throw new RuntimeException("Method setState(MDState) not valid for PasswordBasedMAC class");
    }

    public void update(byte by) {
        this.mac.update(by);
        this.digestValid = false;
    }

    public void update(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
        this.digestValid = false;
    }
}

