/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.CipherException;
import com.phaos.crypto.PKCS5;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PasswordProtectedObject
implements Serializable {
    protected PKCS5 pkcs5;
    protected byte[] encryptedData;
    protected transient Serializable obj;

    public PasswordProtectedObject() {
    }

    public PasswordProtectedObject(int n) {
        this(n, RandomBitsSource.getDefault());
    }

    public PasswordProtectedObject(int n, RandomBitsSource randomBitsSource) {
        this(new PKCS5(n, randomBitsSource));
    }

    public PasswordProtectedObject(PKCS5 pKCS5) {
        this.pkcs5 = pKCS5;
    }

    public PasswordProtectedObject(Serializable serializable) {
        this(serializable, 3, RandomBitsSource.getDefault());
    }

    public PasswordProtectedObject(Serializable serializable, int n) {
        this(serializable, n, RandomBitsSource.getDefault());
    }

    public PasswordProtectedObject(Serializable serializable, int n, RandomBitsSource randomBitsSource) {
        this(n, randomBitsSource);
        this.obj = serializable;
    }

    public PasswordProtectedObject(Serializable serializable, PKCS5 pKCS5) {
        this(pKCS5);
        this.obj = serializable;
    }

    public PasswordProtectedObject(Serializable serializable, RandomBitsSource randomBitsSource) {
        this(serializable, 3, randomBitsSource);
    }

    public Object decrypt() throws CipherException, IOException, ClassNotFoundException {
        byte[] byArray = this.pkcs5.decrypt(this.encryptedData);
        ObjectInputStream objectInputStream = new ObjectInputStream(new UnsyncByteArrayInputStream(byArray));
        return objectInputStream.readObject();
    }

    public void encrypt() throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(unsyncByteArrayOutputStream);
        objectOutputStream.writeObject(this.obj);
        objectOutputStream.close();
        try {
            this.encryptedData = this.pkcs5.encrypt(unsyncByteArrayOutputStream.toByteArray());
        }
        catch (CipherException cipherException) {
            throw new IOException(cipherException.toString());
        }
        this.obj = null;
    }

    public PKCS5 getPKCS5() {
        return this.pkcs5;
    }

    public void setObject(Serializable serializable) {
        this.obj = serializable;
    }

    public void setPKCS5(PKCS5 pKCS5) {
        this.pkcs5 = pKCS5;
    }

    public void setPassword(String string) {
        this.pkcs5.setPassword(string);
    }
}

