/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.DSA;
import com.phaos.crypto.DSAParams;
import com.phaos.crypto.DSAPrivateKey;
import com.phaos.crypto.DSAPublicKey;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SHA;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.FixedByteArrayOutputStream;
import com.phaos.utils.OIDManager;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import com.phaos.utils.VersionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CryptoUtils {
    private static final byte[][] desWeakKeys = new byte[][]{Utils.fromHexString("0101010101010101"), Utils.fromHexString("1f1f1f1f0e0e0e0e"), Utils.fromHexString("e0e0e0e0f1f1f1f1"), Utils.fromHexString("fefefefefefefefe")};
    private static final byte[][] desSemiWeakKeys = new byte[][]{Utils.fromHexString("01fe01fe01fe01fe"), Utils.fromHexString("fe01fe01fe01fe01"), Utils.fromHexString("1fe01fe00ef10ef1"), Utils.fromHexString("e01fe01ff10ef10e"), Utils.fromHexString("01e001e001f101f1"), Utils.fromHexString("e001e001f101f101"), Utils.fromHexString("1ffe1ffe0efe0efe"), Utils.fromHexString("fe1ffe1ffe0efe0e"), Utils.fromHexString("011f011f010e010e"), Utils.fromHexString("1f011f010e010e01"), Utils.fromHexString("e0fee0fef1fef1fe"), Utils.fromHexString("fee0fee0fef1fef1")};
    private static final byte[][] desPossiblyWeakKeys = new byte[][]{Utils.fromHexString("1f1f01010e0e0101"), Utils.fromHexString("e00101e0f10101f1"), Utils.fromHexString("011f1f01010e0e01"), Utils.fromHexString("fe1f01e0fe0e01f1"), Utils.fromHexString("1f01011f0e01010e"), Utils.fromHexString("fe011fe0fe010ef1"), Utils.fromHexString("01011f1f01010e0e"), Utils.fromHexString("e01f1fe0f10e0ef1"), Utils.fromHexString("e0e00101f1f10101"), Utils.fromHexString("fe0101fefe0101fe"), Utils.fromHexString("fefe0101fefe0101"), Utils.fromHexString("e01f01fef10e01fe"), Utils.fromHexString("fee01f01fef10e01"), Utils.fromHexString("e0011ffef1010efe"), Utils.fromHexString("e0fe1f01f1fe0e01"), Utils.fromHexString("fe1f1ffefe0e0efe"), Utils.fromHexString("fee0011ffef1010e"), Utils.fromHexString("1ffe01e00efe01f1"), Utils.fromHexString("e0fe011ff1fe010e"), Utils.fromHexString("01fe1fe001fe0ef1"), Utils.fromHexString("e0e01f1ff1f10e0e"), Utils.fromHexString("1fe001fe0ef101fe"), Utils.fromHexString("fefe1f1ffefe0e0e"), Utils.fromHexString("01e01ffe01f10efe"), Utils.fromHexString("fe1fe001fe0ef101"), Utils.fromHexString("0101e0e00101f1f1"), Utils.fromHexString("e01ffe01f10efe01"), Utils.fromHexString("1f1fe0e00e0ef1f1"), Utils.fromHexString("fe01e01ffe01f10e"), Utils.fromHexString("1f0efee00e01fef1"), Utils.fromHexString("e001fe1ff101fe0e"), Utils.fromHexString("011ffee0010efef1"), Utils.fromHexString("01e0e00101f1f101"), Utils.fromHexString("1f01e0fe0e01f1fe"), Utils.fromHexString("1ffee0010efef001"), Utils.fromHexString("011fe0fe010ef1fe"), Utils.fromHexString("1fe0fe010ef1fe01"), Utils.fromHexString("0101fefe0101fefe"), Utils.fromHexString("01fefe0101fefe01"), Utils.fromHexString("1f1ffefe0e0efefe"), Utils.fromHexString("1fe0e01f0ef1f10e"), Utils.fromHexString("fefee0e0fefef1f1"), Utils.fromHexString("01fee01f01fef10e"), Utils.fromHexString("e0fefee0f1fefef1"), Utils.fromHexString("01e0fe1f01f1fe0e"), Utils.fromHexString("fee0e0fefef1f1fe"), Utils.fromHexString("1ffefe1f0efefe0e"), Utils.fromHexString("e0e0fefef1f1fefe")};

    public static boolean checkKeyParity(SymmetricKey symmetricKey, int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("Invalid parity argument");
        }
        byte[] byArray = symmetricKey.getBytes();
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by = byArray[n2];
            int n3 = by >> 7 ^ by >> 6 ^ by >> 5 ^ by >> 4 ^ by >> 3 ^ by >> 2 ^ by >> 1 ^ by;
            if ((n3 & 1) != n) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static byte[] generateKeyID(PublicKey publicKey) {
        SHA sHA = new SHA();
        sHA.update(Utils.toBytes(publicKey.getContents()));
        sHA.computeCurrent();
        return sHA.digestBits;
    }

    public static byte[] getIV(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier instanceof CBCAlgorithmIdentifier) {
            return ((CBCAlgorithmIdentifier)algorithmIdentifier).getIV();
        }
        CBCAlgorithmIdentifier cBCAlgorithmIdentifier = new CBCAlgorithmIdentifier(algorithmIdentifier.getOID(), algorithmIdentifier.getParameters());
        return cBCAlgorithmIdentifier.getIV();
    }

    public static KeyPair inputKeyPair(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        if (aSN1Sequence.size() == 9) {
            RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
            try {
                rSAPrivateKey.initialize(AlgID.rsaEncryption, aSN1Sequence);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IOException(algorithmIdentifierException.toString());
            }
            return new KeyPair(rSAPrivateKey.getPublicKey(), rSAPrivateKey);
        }
        if (aSN1Sequence.size() == 6) {
            if (((ASN1Integer)aSN1Sequence.elementAt(0)).getValue().intValue() != 0) {
                throw new ASN1FormatException("Invalid key pair format");
            }
            DSAParams dSAParams = new DSAParams(((ASN1Integer)aSN1Sequence.elementAt(1)).getValue(), ((ASN1Integer)aSN1Sequence.elementAt(2)).getValue(), ((ASN1Integer)aSN1Sequence.elementAt(3)).getValue());
            DSAPublicKey dSAPublicKey = new DSAPublicKey(((ASN1Integer)aSN1Sequence.elementAt(4)).getValue(), dSAParams);
            DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(((ASN1Integer)aSN1Sequence.elementAt(5)).getValue(), dSAParams);
            return new KeyPair(dSAPublicKey, dSAPrivateKey);
        }
        throw new ASN1FormatException("Unknown key pair format");
    }

    public static PrivateKey inputPrivateKey(File file) throws IOException {
        return CryptoUtils.inputPrivateKey(new FileInputStream(file));
    }

    public static PrivateKey inputPrivateKey(InputStream inputStream) throws IOException {
        Object object;
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
        if (!aSN1Integer.equals(0)) {
            throw new VersionException(aSN1Integer.getValue(), 0);
        }
        AlgorithmIdentifier algorithmIdentifier = null;
        Object object2 = null;
        if (aSN1Sequence.size() == 9) {
            algorithmIdentifier = AlgID.rsaEncryption;
            object2 = aSN1Sequence;
        } else if (aSN1Sequence.size() == 5) {
            algorithmIdentifier = AlgID.dsaWithSHA1;
            object2 = aSN1Sequence;
        } else {
            algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
            object = aSN1Sequence.elementAt(2);
            if (object instanceof ASN1OctetString) {
                object2 = ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(((ASN1OctetString)object).getValue()));
            } else if (object instanceof ASN1Sequence) {
                object2 = object;
            } else {
                throw new IOException("Invalid private key contents");
            }
        }
        object = OIDManager.getOIDManager();
        String string = ((OIDManager)object).getProperty(algorithmIdentifier.getOID(), "privateKey");
        if (string == null) {
            throw new IOException("Unrecognized algorithm identifier.");
        }
        try {
            Class<?> clazz = Class.forName(string);
            PrivateKey privateKey = (PrivateKey)clazz.newInstance();
            privateKey.initialize(algorithmIdentifier, (ASN1Object)object2);
            return privateKey;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Unable to instantiate " + string + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Unable to instantiate " + string + ":" + instantiationException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Class " + string + " not found.");
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Class does not implement PrivateKey.");
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }

    public static PublicKey inputSPKI(ASN1Sequence aSN1Sequence) throws IOException {
        return CryptoUtils.inputSPKI(new UnsyncByteArrayInputStream(Utils.toBytes(aSN1Sequence)));
    }

    public static PublicKey inputSPKI(InputStream inputStream) throws IOException {
        PublicKey publicKey;
        Object object;
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1SequenceInputStream);
        OIDManager oIDManager = OIDManager.getOIDManager();
        String string = oIDManager.getProperty(algorithmIdentifier.getOID(), "publicKey");
        if (string == null) {
            throw new IOException("Unrecognized algorithm identifier.");
        }
        try {
            object = Class.forName(string);
            publicKey = (PublicKey)((Class)object).newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Unable to instantiate " + string + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Unable to instantiate " + string + ":" + instantiationException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Class " + string + " not found.");
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Class does not implement PublicKey.");
        }
        object = ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(ASN1BitString.inputValue(aSN1SequenceInputStream)));
        try {
            publicKey.initialize(algorithmIdentifier, (ASN1Object)object);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
        return publicKey;
    }

    public static PublicKey inputSPKI(byte[] byArray) throws IOException {
        return CryptoUtils.inputSPKI(new UnsyncByteArrayInputStream(byArray));
    }

    public static boolean isDesPossiblyWeakKey(SymmetricKey symmetricKey) {
        byte[] byArray = symmetricKey.getBytes();
        int n = 0;
        while (n < desPossiblyWeakKeys.length) {
            if (Utils.areEqual(desPossiblyWeakKeys[n], byArray)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isDesSemiWeakKey(SymmetricKey symmetricKey) {
        byte[] byArray = symmetricKey.getBytes();
        int n = 0;
        while (n < desSemiWeakKeys.length) {
            if (Utils.areEqual(desSemiWeakKeys[n], byArray)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isDesWeakKey(SymmetricKey symmetricKey) {
        byte[] byArray = symmetricKey.getBytes();
        int n = 0;
        while (n < desWeakKeys.length) {
            if (Utils.areEqual(desWeakKeys[n], byArray)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static ASN1Sequence makeAlgID(ASN1ObjectID aSN1ObjectID) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(aSN1ObjectID);
        if (!aSN1ObjectID.equals(DSA.dsaSigOID)) {
            aSN1Sequence.addElement(new ASN1Null());
        }
        return aSN1Sequence;
    }

    public static Signature makeSignature(PrivateKey privateKey) throws SignatureException {
        Signature signature;
        OIDManager oIDManager = OIDManager.getOIDManager();
        String string = oIDManager.getProperty(privateKey.getAlgID().getOID(), "useSignature");
        if (string == null) {
            throw new SignatureException("Can not find a signature algorithm for this key.");
        }
        try {
            signature = (Signature)Class.forName(string).newInstance();
            signature.setPrivateKey(privateKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SignatureException("Unable to instantiate " + string + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new SignatureException("Unable to instantiate " + string + ":" + instantiationException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SignatureException(classNotFoundException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new SignatureException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        return signature;
    }

    public static Signature makeSignature(PublicKey publicKey) throws AuthenticationException {
        Signature signature;
        OIDManager oIDManager = OIDManager.getOIDManager();
        String string = oIDManager.getProperty(publicKey.getAlgID().getOID(), "useSignature");
        if (string == null) {
            throw new AuthenticationException("Can not find a signature algorithm for this key.");
        }
        try {
            signature = (Signature)Class.forName(string).newInstance();
            signature.setPublicKey(publicKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AuthenticationException("Unable to instantiate " + string + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AuthenticationException("Unable to instantiate " + string + ":" + instantiationException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AuthenticationException(classNotFoundException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AuthenticationException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
        return signature;
    }

    public static ASN1Sequence privateKeyInfo(PrivateKey privateKey) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(0L));
        aSN1Sequence.addElement(privateKey.getAlgID());
        aSN1Sequence.addElement(new ASN1OctetString(Utils.toBytes(privateKey.getContents())));
        return aSN1Sequence;
    }

    public static void setKeyParity(SymmetricKey symmetricKey, int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("Invalid parity argument");
        }
        byte[] byArray = symmetricKey.getBytes();
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by = byArray[n2];
            int n3 = by >> 7 ^ by >> 6 ^ by >> 5 ^ by >> 4 ^ by >> 3 ^ by >> 2 ^ by >> 1;
            byArray[n2] = n == 1 ? (byte)((by | 1) ^ n3 & 1) : (byte)(by & 0xFE ^ n3 & 1);
            ++n2;
        }
    }

    public static byte[] sign(byte[] byArray, PrivateKey privateKey) throws SignatureException {
        return CryptoUtils.sign(byArray, privateKey, RandomBitsSource.getDefault());
    }

    public static byte[] sign(byte[] byArray, PrivateKey privateKey, RandomBitsSource randomBitsSource) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(privateKey.getAlgID());
            signature.setDocument(byArray);
            signature.setRandomBitsSource(randomBitsSource);
            signature.sign();
            return signature.getSigBytes();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
    }

    public static ASN1Sequence signASN1(ASN1Object aSN1Object, PrivateKey privateKey) throws SignatureException {
        return CryptoUtils.signASN1(aSN1Object, privateKey, RandomBitsSource.getDefault());
    }

    public static ASN1Sequence signASN1(ASN1Object aSN1Object, PrivateKey privateKey, RandomBitsSource randomBitsSource) throws SignatureException {
        Signature signature = Signature.getInstance(privateKey);
        signature.setDocument(Utils.toBytes(aSN1Object));
        signature.setRandomBitsSource(randomBitsSource);
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(aSN1Object);
        aSN1Sequence.addElement(signature.getAlgID());
        aSN1Sequence.addElement(new ASN1BitString(signature.sign()));
        return aSN1Sequence;
    }

    public static ASN1Sequence signatureAlgID(PrivateKey privateKey) throws IOException {
        AlgorithmIdentifier algorithmIdentifier;
        try {
            algorithmIdentifier = Signature.getInstance(privateKey).getAlgID();
        }
        catch (SignatureException signatureException) {
            throw new IOException(signatureException.toString());
        }
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(algorithmIdentifier.length());
        algorithmIdentifier.output(fixedByteArrayOutputStream);
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(fixedByteArrayOutputStream.getBytes());
        return new ASN1Sequence(unsyncByteArrayInputStream);
    }

    public static ASN1Sequence subjectPublicKeyInfo(PublicKey publicKey) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(publicKey.getAlgID());
        aSN1Sequence.addElement(new ASN1BitString(Utils.toBytes(publicKey.getContents())));
        return aSN1Sequence;
    }

    public static boolean verifySignature(PublicKey publicKey, byte[] byArray, byte[] byArray2) throws AuthenticationException {
        Signature signature = Signature.getInstance(publicKey);
        signature.setDocument(byArray);
        signature.setSigBytes(byArray2);
        return signature.verify();
    }

    public static boolean verifySignedASN1(ASN1Sequence aSN1Sequence, PublicKey publicKey) {
        try {
            byte[] byArray = Utils.toBytes(aSN1Sequence.elementAt(0));
            byte[] byArray2 = ((ASN1BitString)aSN1Sequence.elementAt(2)).getValue();
            Signature signature = Signature.getInstance(new AlgorithmIdentifier(Utils.toStream(aSN1Sequence.elementAt(1))));
            signature.setPublicKey(publicKey);
            signature.setDocument(byArray);
            signature.setSigBytes(byArray2);
            return signature.verify();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            return false;
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

