/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import java.io.IOException;
import java.io.OutputStream;

public class FixedByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    private boolean isClosed;

    public FixedByteArrayOutputStream(int n) {
        this(new byte[n]);
    }

    public FixedByteArrayOutputStream(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.buf = byArray;
    }

    private void assertOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("output stream closed");
        }
    }

    private void assertSpaceFor(int n) throws IOException {
        if (n > this.buf.length - this.count) {
            throw new IOException("insufficient space in buffer");
        }
    }

    public int bufSize() {
        return this.buf.length;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public byte[] getBytes() {
        if (this.count != this.buf.length) {
            throw new IllegalStateException("getBytes only valid for full buffer");
        }
        return this.buf;
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public void write(int n) throws IOException {
        this.assertOpen();
        this.assertSpaceFor(1);
        this.buf[this.count++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.assertOpen();
        this.assertSpaceFor(n2);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }
}

