/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKIX;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.utils.InvalidFormatException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class OIDManager {
    private static OIDManager defaultOIDManager = null;
    private Hashtable oidmap = new Hashtable();
    private Hashtable attTypemap = new Hashtable();
    private Hashtable attNamemap = new Hashtable();
    protected OIDManager parent = null;
    public static final AlgorithmIdentifier cryptokiPrivateKey = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.phaosID, 2, 1));
    public static final AlgorithmIdentifier cryptokiPublicKey = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.phaosID, 2, 2));
    private static final Object lockDefault = new Object();
    static /* synthetic */ Class class$com$phaos$crypto$RSAPrivateKey;
    static /* synthetic */ Class class$com$phaos$crypto$RSAPublicKey;
    static /* synthetic */ Class class$com$phaos$crypto$RSApkcs1;
    static /* synthetic */ Class class$com$phaos$crypto$RSAMDSignature;
    static /* synthetic */ Class class$com$phaos$crypto$RSAKeyPairGenerator;
    static /* synthetic */ Class class$com$phaos$crypto$DSAPrivateKey;
    static /* synthetic */ Class class$com$phaos$crypto$DSAPublicKey;
    static /* synthetic */ Class class$com$phaos$crypto$DSA;
    static /* synthetic */ Class class$com$phaos$crypto$DSAKeyPairGenerator;
    static /* synthetic */ Class class$com$phaos$crypto$DHPrivateKey;
    static /* synthetic */ Class class$com$phaos$crypto$DHPublicKey;
    static /* synthetic */ Class class$com$phaos$crypto$DHKeyAgreement;
    static /* synthetic */ Class class$com$phaos$crypto$DHKeyPairGenerator;
    static /* synthetic */ Class class$com$phaos$crypto$DiffieHellman;
    static /* synthetic */ Class class$com$phaos$crypto$SymmetricKeyGenerator;
    static /* synthetic */ Class class$com$phaos$crypto$Blowfish;
    static /* synthetic */ Class class$com$phaos$crypto$RC2;
    static /* synthetic */ Class class$com$phaos$crypto$Arcfour;
    static /* synthetic */ Class class$com$phaos$crypto$DES_EDE;
    static /* synthetic */ Class class$com$phaos$crypto$DES;
    static /* synthetic */ Class class$com$phaos$crypto$AES;
    static /* synthetic */ Class class$com$phaos$crypto$MD2;
    static /* synthetic */ Class class$com$phaos$crypto$MD5;
    static /* synthetic */ Class class$com$phaos$crypto$SHA;
    static /* synthetic */ Class class$com$phaos$crypto$HMAC;
    static /* synthetic */ Class class$com$phaos$crypto$PasswordBasedMAC;
    static /* synthetic */ Class class$com$phaos$crypto$cryptoki$CkiPrivateKey;
    static /* synthetic */ Class class$com$phaos$crypto$cryptoki$CkiPublicKey;
    static /* synthetic */ Class class$com$phaos$crypto$cryptoki$CkiSignature;
    static /* synthetic */ Class class$com$phaos$crypto$cryptoki$CkiRSApkcs1;
    static /* synthetic */ Class class$com$phaos$cert$extension$SubjectKeyIDExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$KeyUsageExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$SubjectAltNameExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$IssuerAltNameExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$BasicConstraintsExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$CRLNumberExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$CRLReasonExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$CRLHoldInstructionExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$CRLInvalidityDateExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$DeltaCRLIndicatorExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$IssuingDistPointExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$CRLCertificateIssuerExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$NameConstraintsExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$CertificatePoliciesExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$AuthorityKeyIDExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$PolicyConstraintsExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$ExtKeyUsageExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$CRLDistPointExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$AuthorityInfoAccessExtension;
    static /* synthetic */ Class class$com$phaos$cert$extension$NetscapeCertTypeExtension;

    public OIDManager() {
    }

    public OIDManager(OIDManager oIDManager) {
        this.parent = oIDManager;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getAttributeName(ASN1ObjectID aSN1ObjectID) {
        String string = (String)this.attNamemap.get(aSN1ObjectID);
        if (string == null && this.parent != null) {
            string = this.parent.getAttributeName(aSN1ObjectID);
        }
        return string;
    }

    public ASN1ObjectID getAttributeType(String string) {
        ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)this.attTypemap.get(string.toUpperCase());
        if (aSN1ObjectID == null && this.parent != null) {
            aSN1ObjectID = this.parent.getAttributeType(string.toUpperCase());
        }
        return aSN1ObjectID;
    }

    private static OIDManager getDefaultOIDManager() {
        OIDManager oIDManager = new OIDManager();
        oIDManager.mapDefaults();
        return oIDManager;
    }

    public Class getMapping(ASN1ObjectID aSN1ObjectID, String string) {
        Hashtable hashtable = this.getMappings(aSN1ObjectID);
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v == null && this.parent != null) {
            return this.parent.getMapping(aSN1ObjectID, string);
        }
        if (v == null && this.parent == null) {
            this.mapTable(aSN1ObjectID, hashtable);
            v = hashtable.get(string);
        }
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            try {
                return Class.forName((String)v);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.toString());
            }
        }
        return (Class)v;
    }

    public Hashtable getMappings(ASN1ObjectID aSN1ObjectID) {
        Hashtable hashtable = (Hashtable)this.oidmap.get(aSN1ObjectID);
        if (hashtable == null && this.parent != null) {
            hashtable = this.parent.getMappings(aSN1ObjectID);
        } else if (hashtable == null && this.parent == null) {
            hashtable = new Hashtable();
            this.oidmap.put(aSN1ObjectID, hashtable);
            this.mapTable(aSN1ObjectID, hashtable);
            hashtable = (Hashtable)this.oidmap.get(aSN1ObjectID);
        }
        return hashtable;
    }

    public static OIDManager getOIDManager() {
        Object object = lockDefault;
        synchronized (object) {
            if (defaultOIDManager == null) {
                defaultOIDManager = OIDManager.getDefaultOIDManager();
            }
        }
        return defaultOIDManager;
    }

    public Properties getProperties(ASN1ObjectID aSN1ObjectID) {
        Hashtable hashtable = this.getMappings(aSN1ObjectID);
        Properties properties = new Properties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ((Hashtable)properties).put(string, ((Class)hashtable.get(string)).getName());
        }
        return properties;
    }

    public String getProperty(ASN1ObjectID aSN1ObjectID, String string) {
        if (string.equals("attributeTypeName")) {
            Hashtable hashtable = (Hashtable)this.oidmap.get(aSN1ObjectID);
            if (hashtable == null) {
                return null;
            }
            return (String)hashtable.get(string);
        }
        Hashtable hashtable = this.getMappings(aSN1ObjectID);
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v == null && this.parent != null) {
            return this.parent.getProperty(aSN1ObjectID, string);
        }
        if (v == null && this.parent == null) {
            this.mapTable(aSN1ObjectID, hashtable);
            v = hashtable.get(string);
        }
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return ((Class)v).getName();
    }

    private static String lTrim(String string) {
        int n = 0;
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n < string.length() ? string.substring(n) : "";
    }

    /*
     * Unable to fully structure code
     */
    public void load(InputStream var1_1) throws IOException {
        while (true) {
            var2_2 = null;
            var3_3 = var1_1.read();
            if (var3_3 != -1) ** GOTO lbl7
            break;
lbl-1000:
            // 1 sources

            {
                var3_3 = var1_1.read();
lbl7:
                // 2 sources

                ** while (Character.isWhitespace((char)((char)var3_3)))
            }
lbl8:
            // 1 sources

            if (var3_3 == 35 || var3_3 == 33) {
                while ((var3_3 = var1_1.read()) != -1 && var3_3 != 13 && var3_3 != 10) {
                }
                continue;
            }
            var4_4 = new StringBuffer();
            do {
                var4_4.append((char)var3_3);
            } while ((var3_3 = var1_1.read()) != -1 && var3_3 != 13 && var3_3 != 10);
            var2_2 = var4_4.toString();
            if (var2_2.length() <= 0) continue;
            var4_5 = var2_2.charAt(0);
            if (var4_5 == '&') {
                var2_2 = var2_2.substring(1);
            }
            try {
                var5_6 = new ASN1ObjectID(OIDManager.rTrim(OIDManager.lTrim(var2_2)));
                var6_8 = new Properties();
                var6_8.load(new OIDManagerInputStream(var1_1));
                this.setProperties(var5_6, var6_8);
            }
            catch (InvalidFormatException var5_7) {
                throw new IOException(var5_7.toString());
            }
        }
    }

    private void map3DES(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", class$com$phaos$crypto$DES_EDE != null ? class$com$phaos$crypto$DES_EDE : (class$com$phaos$crypto$DES_EDE = OIDManager.class$("com.phaos.crypto.DES_EDE")));
            }
        }
        catch (Throwable throwable) {}
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void mapAES(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", class$com$phaos$crypto$AES != null ? class$com$phaos$crypto$AES : (class$com$phaos$crypto$AES = OIDManager.class$("com.phaos.crypto.AES")));
            }
        }
        catch (Throwable throwable) {}
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void mapBasedMACAlgorithms(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("messageDigest")) {
                hashtable.put("messageDigest", class$com$phaos$crypto$PasswordBasedMAC != null ? class$com$phaos$crypto$PasswordBasedMAC : (class$com$phaos$crypto$PasswordBasedMAC = OIDManager.class$("com.phaos.crypto.PasswordBasedMAC")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapBlowfish(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", class$com$phaos$crypto$Blowfish != null ? class$com$phaos$crypto$Blowfish : (class$com$phaos$crypto$Blowfish = OIDManager.class$("com.phaos.crypto.Blowfish")));
            }
        }
        catch (Throwable throwable) {}
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void mapCryptoki(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("privateKey")) {
                hashtable.put("privateKey", class$com$phaos$crypto$cryptoki$CkiPrivateKey != null ? class$com$phaos$crypto$cryptoki$CkiPrivateKey : (class$com$phaos$crypto$cryptoki$CkiPrivateKey = OIDManager.class$("com.phaos.crypto.cryptoki.CkiPrivateKey")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("publicKey")) {
                hashtable.put("publicKey", class$com$phaos$crypto$cryptoki$CkiPublicKey != null ? class$com$phaos$crypto$cryptoki$CkiPublicKey : (class$com$phaos$crypto$cryptoki$CkiPublicKey = OIDManager.class$("com.phaos.crypto.cryptoki.CkiPublicKey")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("useSignature")) {
                hashtable.put("useSignature", class$com$phaos$crypto$cryptoki$CkiSignature != null ? class$com$phaos$crypto$cryptoki$CkiSignature : (class$com$phaos$crypto$cryptoki$CkiSignature = OIDManager.class$("com.phaos.crypto.cryptoki.CkiSignature")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("useCipher")) {
                hashtable.put("useCipher", class$com$phaos$crypto$cryptoki$CkiRSApkcs1 != null ? class$com$phaos$crypto$cryptoki$CkiRSApkcs1 : (class$com$phaos$crypto$cryptoki$CkiRSApkcs1 = OIDManager.class$("com.phaos.crypto.cryptoki.CkiRSApkcs1")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", class$com$phaos$crypto$cryptoki$CkiRSApkcs1 != null ? class$com$phaos$crypto$cryptoki$CkiRSApkcs1 : (class$com$phaos$crypto$cryptoki$CkiRSApkcs1 = OIDManager.class$("com.phaos.crypto.cryptoki.CkiRSApkcs1")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapDES(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", class$com$phaos$crypto$DES != null ? class$com$phaos$crypto$DES : (class$com$phaos$crypto$DES = OIDManager.class$("com.phaos.crypto.DES")));
            }
        }
        catch (Throwable throwable) {}
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void mapDHKeyAgreement(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("privateKey")) {
                hashtable.put("privateKey", class$com$phaos$crypto$DHPrivateKey != null ? class$com$phaos$crypto$DHPrivateKey : (class$com$phaos$crypto$DHPrivateKey = OIDManager.class$("com.phaos.crypto.DHPrivateKey")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("publicKey")) {
                hashtable.put("publicKey", class$com$phaos$crypto$DHPublicKey != null ? class$com$phaos$crypto$DHPublicKey : (class$com$phaos$crypto$DHPublicKey = OIDManager.class$("com.phaos.crypto.DHPublicKey")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("useKeyAgreement")) {
                hashtable.put("useKeyAgreement", class$com$phaos$crypto$DHKeyAgreement != null ? class$com$phaos$crypto$DHKeyAgreement : (class$com$phaos$crypto$DHKeyAgreement = OIDManager.class$("com.phaos.crypto.DHKeyAgreement")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("keyPairGenerator")) {
                hashtable.put("keyPairGenerator", class$com$phaos$crypto$DHKeyPairGenerator != null ? class$com$phaos$crypto$DHKeyPairGenerator : (class$com$phaos$crypto$DHKeyPairGenerator = OIDManager.class$("com.phaos.crypto.DHKeyPairGenerator")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("keyAgreement")) {
                hashtable.put("keyAgreement", class$com$phaos$crypto$DHKeyAgreement != null ? class$com$phaos$crypto$DHKeyAgreement : (class$com$phaos$crypto$DHKeyAgreement = OIDManager.class$("com.phaos.crypto.DHKeyAgreement")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapDSACipher(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("privateKey")) {
                hashtable.put("privateKey", class$com$phaos$crypto$DSAPrivateKey != null ? class$com$phaos$crypto$DSAPrivateKey : (class$com$phaos$crypto$DSAPrivateKey = OIDManager.class$("com.phaos.crypto.DSAPrivateKey")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("publicKey")) {
                hashtable.put("publicKey", class$com$phaos$crypto$DSAPublicKey != null ? class$com$phaos$crypto$DSAPublicKey : (class$com$phaos$crypto$DSAPublicKey = OIDManager.class$("com.phaos.crypto.DSAPublicKey")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("useSignature")) {
                hashtable.put("useSignature", class$com$phaos$crypto$DSA != null ? class$com$phaos$crypto$DSA : (class$com$phaos$crypto$DSA = OIDManager.class$("com.phaos.crypto.DSA")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("keyPairGenerator")) {
                hashtable.put("keyPairGenerator", class$com$phaos$crypto$DSAKeyPairGenerator != null ? class$com$phaos$crypto$DSAKeyPairGenerator : (class$com$phaos$crypto$DSAKeyPairGenerator = OIDManager.class$("com.phaos.crypto.DSAKeyPairGenerator")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapDSASignature(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("signature")) {
                hashtable.put("signature", class$com$phaos$crypto$DSA != null ? class$com$phaos$crypto$DSA : (class$com$phaos$crypto$DSA = OIDManager.class$("com.phaos.crypto.DSA")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapDefaults() {
        this.setAttributeTypeName("CN", PKIX.id_at_commonName);
        this.setAttributeTypeName("L", PKIX.id_at_localityName);
        this.setAttributeTypeName("ST", PKIX.id_at_stateOrProvinceName);
        this.setAttributeTypeName("O", PKIX.id_at_organizationName);
        this.setAttributeTypeName("OU", PKIX.id_at_organizationalUnitName);
        this.setAttributeTypeName("C", PKIX.id_at_countryName);
        this.setAttributeTypeName("Email", PKIX.emailAddress);
    }

    private void mapDiffieHellman(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", class$com$phaos$crypto$DiffieHellman != null ? class$com$phaos$crypto$DiffieHellman : (class$com$phaos$crypto$DiffieHellman = OIDManager.class$("com.phaos.crypto.DiffieHellman")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapHMAC(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("messageDigest")) {
                hashtable.put("messageDigest", class$com$phaos$crypto$HMAC != null ? class$com$phaos$crypto$HMAC : (class$com$phaos$crypto$HMAC = OIDManager.class$("com.phaos.crypto.HMAC")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapMD2(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("messageDigest")) {
                hashtable.put("messageDigest", class$com$phaos$crypto$MD2 != null ? class$com$phaos$crypto$MD2 : (class$com$phaos$crypto$MD2 = OIDManager.class$("com.phaos.crypto.MD2")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapMD5(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("messageDigest")) {
                hashtable.put("messageDigest", class$com$phaos$crypto$MD5 != null ? class$com$phaos$crypto$MD5 : (class$com$phaos$crypto$MD5 = OIDManager.class$("com.phaos.crypto.MD5")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapRC2(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", class$com$phaos$crypto$RC2 != null ? class$com$phaos$crypto$RC2 : (class$com$phaos$crypto$RC2 = OIDManager.class$("com.phaos.crypto.RC2")));
            }
        }
        catch (Throwable throwable) {}
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void mapRC4(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", class$com$phaos$crypto$Arcfour != null ? class$com$phaos$crypto$Arcfour : (class$com$phaos$crypto$Arcfour = OIDManager.class$("com.phaos.crypto.Arcfour")));
            }
        }
        catch (Throwable throwable) {}
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void mapRSACipher(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("privateKey")) {
                hashtable.put("privateKey", class$com$phaos$crypto$RSAPrivateKey != null ? class$com$phaos$crypto$RSAPrivateKey : (class$com$phaos$crypto$RSAPrivateKey = OIDManager.class$("com.phaos.crypto.RSAPrivateKey")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("publicKey")) {
                hashtable.put("publicKey", class$com$phaos$crypto$RSAPublicKey != null ? class$com$phaos$crypto$RSAPublicKey : (class$com$phaos$crypto$RSAPublicKey = OIDManager.class$("com.phaos.crypto.RSAPublicKey")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", class$com$phaos$crypto$RSApkcs1 != null ? class$com$phaos$crypto$RSApkcs1 : (class$com$phaos$crypto$RSApkcs1 = OIDManager.class$("com.phaos.crypto.RSApkcs1")));
            }
            if (!hashtable.containsKey("useCipher")) {
                hashtable.put("useCipher", class$com$phaos$crypto$RSApkcs1 != null ? class$com$phaos$crypto$RSApkcs1 : (class$com$phaos$crypto$RSApkcs1 = OIDManager.class$("com.phaos.crypto.RSApkcs1")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("useSignature")) {
                hashtable.put("useSignature", class$com$phaos$crypto$RSAMDSignature != null ? class$com$phaos$crypto$RSAMDSignature : (class$com$phaos$crypto$RSAMDSignature = OIDManager.class$("com.phaos.crypto.RSAMDSignature")));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (!hashtable.containsKey("keyPairGenerator")) {
                hashtable.put("keyPairGenerator", class$com$phaos$crypto$RSAKeyPairGenerator != null ? class$com$phaos$crypto$RSAKeyPairGenerator : (class$com$phaos$crypto$RSAKeyPairGenerator = OIDManager.class$("com.phaos.crypto.RSAKeyPairGenerator")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapRSASignature(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("signature")) {
                hashtable.put("signature", class$com$phaos$crypto$RSAMDSignature != null ? class$com$phaos$crypto$RSAMDSignature : (class$com$phaos$crypto$RSAMDSignature = OIDManager.class$("com.phaos.crypto.RSAMDSignature")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapSHA(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("messageDigest")) {
                hashtable.put("messageDigest", class$com$phaos$crypto$SHA != null ? class$com$phaos$crypto$SHA : (class$com$phaos$crypto$SHA = OIDManager.class$("com.phaos.crypto.SHA")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapSymmetricKeyGenerator(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("symmetricKeyGenerator")) {
                hashtable.put("symmetricKeyGenerator", class$com$phaos$crypto$SymmetricKeyGenerator != null ? class$com$phaos$crypto$SymmetricKeyGenerator : (class$com$phaos$crypto$SymmetricKeyGenerator = OIDManager.class$("com.phaos.crypto.SymmetricKeyGenerator")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapTable(ASN1ObjectID aSN1ObjectID, Hashtable hashtable) {
        if (aSN1ObjectID.equals(AlgID.rsaEncryption.getOID()) || aSN1ObjectID.equals(AlgID.rsaWithOAEPEncoding.getOID())) {
            this.mapRSACipher(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.md2WithRSAEncryption.getOID()) || aSN1ObjectID.equals(AlgID.md5WithRSAEncryption.getOID()) || aSN1ObjectID.equals(AlgID.sha_1WithRSAEncryption.getOID())) {
            this.mapRSASignature(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.dsa.getOID()) || aSN1ObjectID.equals(AlgID.dsaOld.getOID())) {
            this.mapDSACipher(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.dsaWithSHA1.getOID()) || aSN1ObjectID.equals(AlgID.dsaWithSHA.getOID()) || aSN1ObjectID.equals(AlgID.dsaWithSHA1Old.getOID())) {
            this.mapDSASignature(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.dh.getOID())) {
            this.mapDHKeyAgreement(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.dhKeyAgreement.getOID())) {
            this.mapDiffieHellman(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.blowfishECB.getOID()) || aSN1ObjectID.equals(AlgID.blowfishCBC.getOID())) {
            this.mapBlowfish(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.RC2_CBC.getOID())) {
            this.mapRC2(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.RC4.getOID())) {
            this.mapRC4(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.DES_EDE3_CBC.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_ECB.getOID())) {
            this.map3DES(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.desCBC.getOID()) || aSN1ObjectID.equals(AlgID.desECB.getOID())) {
            this.mapDES(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.aes128_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes128_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes192_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes192_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes256_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes256_CBC.getOID())) {
            this.mapAES(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.md2.getOID())) {
            this.mapMD2(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.md5.getOID())) {
            this.mapMD5(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.sha_1.getOID()) || aSN1ObjectID.equals(AlgID.sha1.getOID()) || aSN1ObjectID.equals(AlgID.sha.getOID()) || aSN1ObjectID.equals(AlgID.sha_256.getOID()) || aSN1ObjectID.equals(AlgID.sha_384.getOID()) || aSN1ObjectID.equals(AlgID.sha_512.getOID())) {
            this.mapSHA(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.hmacMD5.getOID()) || aSN1ObjectID.equals(AlgID.hmacSHA.getOID())) {
            this.mapHMAC(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.PasswordBasedMac.getOID())) {
            this.mapBasedMACAlgorithms(hashtable);
        } else if (aSN1ObjectID.equals(cryptokiPrivateKey.getOID()) || aSN1ObjectID.equals(cryptokiPublicKey.getOID())) {
            this.mapCryptoki(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_subjectKeyIdentifier)) {
            this.mapX509SubjectKeyIDExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_keyUsage)) {
            this.mapX509KeyUsageExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_subjectAltName)) {
            this.mapX509SubjectAltNameExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_issuerAltName)) {
            this.mapX509IssuerAltNameExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_basicConstraints)) {
            this.mapX509BasicConstraintsExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_cRLNumber)) {
            this.mapX509CRLNumberExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_cRLReason)) {
            this.mapX509CRLReasonExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_holdInstructionCode)) {
            this.mapX509CRLHoldInstructionExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_invalidityDate)) {
            this.mapX509CRLInvalidityDateExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_deltaCRLIndicator)) {
            this.mapX509DeltaCRLIndicatorExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_issuingDistributionPoint)) {
            this.mapX509IssuingDistPointExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_certificateIssuer)) {
            this.mapX509CRLCertificateIssuerExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_nameConstraints)) {
            this.mapX509NameConstraintsExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_certificatePolicies)) {
            this.mapX509CertificatePoliciesExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_authorityKeyIdentifier)) {
            this.mapX509AuthorityKeyIDExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_policyConstraints)) {
            this.mapX509PolicyConstraintsExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_extKeyUsage)) {
            this.mapX509ExtKeyUsageExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_cRLDistributionPoints)) {
            this.mapX509CRLDistPointExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_pe_authorityInfoAccess)) {
            this.mapX509AuthorityInfoAccessExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_netscape_ce_type)) {
            this.mapX509NetscapeCertTypeExtension(hashtable);
        }
    }

    private void mapX509AuthorityInfoAccessExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$AuthorityInfoAccessExtension != null ? class$com$phaos$cert$extension$AuthorityInfoAccessExtension : (class$com$phaos$cert$extension$AuthorityInfoAccessExtension = OIDManager.class$("com.phaos.cert.extension.AuthorityInfoAccessExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509AuthorityKeyIDExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$AuthorityKeyIDExtension != null ? class$com$phaos$cert$extension$AuthorityKeyIDExtension : (class$com$phaos$cert$extension$AuthorityKeyIDExtension = OIDManager.class$("com.phaos.cert.extension.AuthorityKeyIDExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509BasicConstraintsExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$BasicConstraintsExtension != null ? class$com$phaos$cert$extension$BasicConstraintsExtension : (class$com$phaos$cert$extension$BasicConstraintsExtension = OIDManager.class$("com.phaos.cert.extension.BasicConstraintsExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509CRLCertificateIssuerExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$CRLCertificateIssuerExtension != null ? class$com$phaos$cert$extension$CRLCertificateIssuerExtension : (class$com$phaos$cert$extension$CRLCertificateIssuerExtension = OIDManager.class$("com.phaos.cert.extension.CRLCertificateIssuerExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509CRLDistPointExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$CRLDistPointExtension != null ? class$com$phaos$cert$extension$CRLDistPointExtension : (class$com$phaos$cert$extension$CRLDistPointExtension = OIDManager.class$("com.phaos.cert.extension.CRLDistPointExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509CRLHoldInstructionExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$CRLHoldInstructionExtension != null ? class$com$phaos$cert$extension$CRLHoldInstructionExtension : (class$com$phaos$cert$extension$CRLHoldInstructionExtension = OIDManager.class$("com.phaos.cert.extension.CRLHoldInstructionExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509CRLInvalidityDateExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$CRLInvalidityDateExtension != null ? class$com$phaos$cert$extension$CRLInvalidityDateExtension : (class$com$phaos$cert$extension$CRLInvalidityDateExtension = OIDManager.class$("com.phaos.cert.extension.CRLInvalidityDateExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509CRLNumberExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$CRLNumberExtension != null ? class$com$phaos$cert$extension$CRLNumberExtension : (class$com$phaos$cert$extension$CRLNumberExtension = OIDManager.class$("com.phaos.cert.extension.CRLNumberExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509CRLReasonExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$CRLReasonExtension != null ? class$com$phaos$cert$extension$CRLReasonExtension : (class$com$phaos$cert$extension$CRLReasonExtension = OIDManager.class$("com.phaos.cert.extension.CRLReasonExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509CertificatePoliciesExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$CertificatePoliciesExtension != null ? class$com$phaos$cert$extension$CertificatePoliciesExtension : (class$com$phaos$cert$extension$CertificatePoliciesExtension = OIDManager.class$("com.phaos.cert.extension.CertificatePoliciesExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509DeltaCRLIndicatorExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$DeltaCRLIndicatorExtension != null ? class$com$phaos$cert$extension$DeltaCRLIndicatorExtension : (class$com$phaos$cert$extension$DeltaCRLIndicatorExtension = OIDManager.class$("com.phaos.cert.extension.DeltaCRLIndicatorExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509ExtKeyUsageExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$ExtKeyUsageExtension != null ? class$com$phaos$cert$extension$ExtKeyUsageExtension : (class$com$phaos$cert$extension$ExtKeyUsageExtension = OIDManager.class$("com.phaos.cert.extension.ExtKeyUsageExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509IssuerAltNameExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$IssuerAltNameExtension != null ? class$com$phaos$cert$extension$IssuerAltNameExtension : (class$com$phaos$cert$extension$IssuerAltNameExtension = OIDManager.class$("com.phaos.cert.extension.IssuerAltNameExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509IssuingDistPointExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$IssuingDistPointExtension != null ? class$com$phaos$cert$extension$IssuingDistPointExtension : (class$com$phaos$cert$extension$IssuingDistPointExtension = OIDManager.class$("com.phaos.cert.extension.IssuingDistPointExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509KeyUsageExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$KeyUsageExtension != null ? class$com$phaos$cert$extension$KeyUsageExtension : (class$com$phaos$cert$extension$KeyUsageExtension = OIDManager.class$("com.phaos.cert.extension.KeyUsageExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509NameConstraintsExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$NameConstraintsExtension != null ? class$com$phaos$cert$extension$NameConstraintsExtension : (class$com$phaos$cert$extension$NameConstraintsExtension = OIDManager.class$("com.phaos.cert.extension.NameConstraintsExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509NetscapeCertTypeExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$NetscapeCertTypeExtension != null ? class$com$phaos$cert$extension$NetscapeCertTypeExtension : (class$com$phaos$cert$extension$NetscapeCertTypeExtension = OIDManager.class$("com.phaos.cert.extension.NetscapeCertTypeExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509PolicyConstraintsExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$PolicyConstraintsExtension != null ? class$com$phaos$cert$extension$PolicyConstraintsExtension : (class$com$phaos$cert$extension$PolicyConstraintsExtension = OIDManager.class$("com.phaos.cert.extension.PolicyConstraintsExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509SubjectAltNameExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$SubjectAltNameExtension != null ? class$com$phaos$cert$extension$SubjectAltNameExtension : (class$com$phaos$cert$extension$SubjectAltNameExtension = OIDManager.class$("com.phaos.cert.extension.SubjectAltNameExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private void mapX509SubjectKeyIDExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", class$com$phaos$cert$extension$SubjectKeyIDExtension != null ? class$com$phaos$cert$extension$SubjectKeyIDExtension : (class$com$phaos$cert$extension$SubjectKeyIDExtension = OIDManager.class$("com.phaos.cert.extension.SubjectKeyIDExtension")));
            }
        }
        catch (Throwable throwable) {}
    }

    private static String rTrim(String string) {
        int n = string.length();
        while (n > 0 && Character.isWhitespace(string.charAt(n - 1))) {
            --n;
        }
        return n > 0 ? string.substring(0, n) : "";
    }

    public ASN1ObjectID setAttributeTypeName(String string, ASN1ObjectID aSN1ObjectID) {
        this.attNamemap.put(aSN1ObjectID, string);
        return this.attTypemap.put(string.toUpperCase(), aSN1ObjectID);
    }

    public Class setMapping(ASN1ObjectID aSN1ObjectID, String string, Class clazz) {
        Class clazz2;
        Hashtable<String, Class> hashtable = this.getMappings(aSN1ObjectID);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Class>();
            this.setMappings(aSN1ObjectID, hashtable);
        }
        if ((clazz2 = hashtable.put(string, clazz)) == null) {
            return null;
        }
        if (clazz2 instanceof String) {
            try {
                return Class.forName((String)((Object)clazz2));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.toString());
            }
        }
        return clazz2;
    }

    public Hashtable setMappings(ASN1ObjectID aSN1ObjectID, Hashtable hashtable) {
        return this.oidmap.put(aSN1ObjectID, hashtable);
    }

    public static void setOIDManager(OIDManager oIDManager) {
        Object object = lockDefault;
        synchronized (object) {
            defaultOIDManager = oIDManager;
        }
    }

    public Properties setProperties(ASN1ObjectID aSN1ObjectID, Properties properties) {
        Object object;
        Object object2;
        Hashtable hashtable = new Hashtable();
        try {
            object2 = ((Hashtable)properties).keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                hashtable.put((String)object, Class.forName((String)((Hashtable)properties).get(object)));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.toString());
        }
        object2 = this.setMappings(aSN1ObjectID, hashtable);
        object = new Properties();
        Enumeration enumeration = ((Hashtable)object2).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ((Hashtable)object).put(string, ((Class)((Hashtable)object2).get(string)).getName());
        }
        return object;
    }

    public String setProperty(ASN1ObjectID aSN1ObjectID, String string, String string2) {
        String string3;
        if (string.equals("attributeTypeName")) {
            this.setAttributeTypeName(string2, aSN1ObjectID);
            Hashtable<String, String> hashtable = (Hashtable<String, String>)this.oidmap.get(aSN1ObjectID);
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
                this.oidmap.put(aSN1ObjectID, hashtable);
            }
            return hashtable.put(string, string2);
        }
        Hashtable<String, String> hashtable = this.getMappings(aSN1ObjectID);
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
            this.setMappings(aSN1ObjectID, hashtable);
        }
        if ((string3 = hashtable.put(string, string2)) == null) {
            return null;
        }
        if (string3 instanceof String) {
            return string3;
        }
        return ((Class)((Object)string3)).getName();
    }

    private class OIDManagerInputStream
    extends FilterInputStream {
        private boolean comment = false;
        private boolean atEOF = false;

        public OIDManagerInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read() throws IOException {
            int n;
            if (this.atEOF || (n = this.in.read()) == -1) {
                return -1;
            }
            if (this.comment) {
                if (n == 13 || n == 10) {
                    this.comment = false;
                }
            } else if (n == 35 || n == 33) {
                this.comment = true;
            } else if (n == 38) {
                this.atEOF = true;
            }
            return this.atEOF ? -1 : n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = -1;
            int n4 = 0;
            while (n4 < n2 && (n3 = this.read()) != -1) {
                byArray[n + n4] = (byte)n3;
                ++n4;
            }
            return n4 == 0 && n3 == -1 ? -1 : n4;
        }
    }
}

