#
# MySQL Install-time SQL
#
#-------------------------------------------------------------------------------------------------------------------------
#
# This SQL file is executed during an install of exteNdComposer 5.2.  It generates the default tables to be used with MYSQL so
# that the Process Manager Engine will start when the app server is started.
#
# This file is a subset of the file, DBResource_en_US_MYSQL.properties.  Whenever new tables, indexes, or initializing
# records are added to DBResource_en_US_MYSQL.properties, this file must be updated also.
#
#-------------------------------------------------------------------------------------------------------------------------
#

use Process50;
CREATE TABLE xcEngineInfo (ProcessInstances BIGINT NOT NULL, ProcessCompletes BIGINT NOT NULL, VersionNumber FLOAT NOT NULL, LastProcessID BIGINT NOT NULL, LastTimedEventID BIGINT NOT NULL, HeartbeatTime BIGINT, HeartbeatFactor BIGINT) TYPE=InnoDB;
CREATE TABLE xcProcessInfo (ProcessName VARCHAR(255) NOT NULL, VersionNumber FLOAT, Context VARCHAR(255), ProcessID BIGINT NOT NULL, ParentID BIGINT, State INTEGER, CreateDateTime DATETIME, ModifyDateTime DATETIME, LockStatus INTEGER NOT NULL, EngineName VARCHAR(64), CONSTRAINT pk_ProcessInfo PRIMARY KEY (ProcessID)) TYPE=InnoDB;
CREATE TABLE xcProcessState (ProcessName VARCHAR(100) NOT NULL, ProcessID BIGINT NOT NULL, Document LONGBLOB, CreateDateTime DATETIME NOT NULL, ModifyDateTime DATETIME NOT NULL, KeepUntil DATETIME, PRIMARY KEY (ProcessID,ProcessName), FOREIGN KEY (ProcessID) REFERENCES xcProcessInfo(ProcessID) ON DELETE CASCADE) TYPE=InnoDB;
CREATE TABLE xcEngineLog (ProcessID BIGINT, ProcessName VARCHAR(100), LogMessage VARCHAR(255) NOT NULL, LogDateTime DATETIME NOT NULL, LogLevel INTEGER, Event INTEGER, OtherInfo VARCHAR(255),INDEX ProcessID_idx(ProcessID), FOREIGN KEY(ProcessID) REFERENCES xcProcessInfo(ProcessID) ON DELETE CASCADE) TYPE=InnoDB;
CREATE TABLE xcTimedEvents (TimerID BIGINT NOT NULL, ProcessID BIGINT NOT NULL, ActivityName VARCHAR(100) NOT NULL, StartTime DATETIME NOT NULL, ExpireTime DATETIME NOT NULL, TimerType INTEGER NOT NULL, EngineInstanceID VARCHAR(100), OtherInfo VARCHAR(255),INDEX ProcessID_idx(ProcessID), CONSTRAINT pk_TimedEvents PRIMARY KEY(TimerID), FOREIGN KEY(ProcessID) REFERENCES xcProcessInfo(ProcessID) ON DELETE CASCADE) TYPE=InnoDB;
CREATE TABLE xcPendingActivity (CorrelationID VARCHAR(100) NOT NULL, Addressee VARCHAR(100), Priority INTEGER, ProcessID BIGINT NOT NULL, ActivityName VARCHAR(100) NOT NULL, InputMessage VARCHAR(100) NOT NULL, ProcessName VARCHAR(100) NOT NULL, CreateDateTime DATETIME, ExpireDateTime DATETIME, LockedBy VARCHAR(100), LockUntil DATETIME,INDEX ProcessID_idx(ProcessID), CONSTRAINT pk_PendingActivity PRIMARY KEY(CorrelationID,ProcessName), FOREIGN KEY(ProcessID) REFERENCES xcProcessInfo(ProcessID) ON DELETE CASCADE) TYPE=InnoDB;
CREATE INDEX xcEngineLog_idx ON xcEngineLog(ProcessID);
CREATE INDEX xcTimedEvents_idx ON xcTimedEvents(ProcessID);
CREATE INDEX xcPendAct_idx ON xcPendingActivity(ProcessID, ActivityName);
CREATE INDEX xcPendAct_idx2 ON xcPendingActivity(Addressee);
CREATE INDEX xcProcessInfo_idx ON xcProcessInfo(ProcessName);
CREATE INDEX xcProcessInfo_idx2 ON xcProcessInfo(State);
CREATE TABLE xcProcessDefs (ProcessName VARCHAR(240) NOT NULL, Context VARCHAR(240) NOT NULL, VersionNumber FLOAT NOT NULL, EffectiveDate DATETIME, Document LONGBLOB NOT NULL, MD5 VARCHAR(100), MD5Encoded VARCHAR(100), CONSTRAINT pk_ProcessDefs PRIMARY KEY (ProcessName,Context,VersionNumber)) TYPE=InnoDB;
CREATE TABLE xcActiveVersions (ProcessName VARCHAR(240) NOT NULL, Context VARCHAR(240) NOT NULL, VersionNumber FLOAT NOT NULL, ExpireDate DATETIME, NextVersionNumber FLOAT, CONSTRAINT pk_ActiveVersions PRIMARY KEY (ProcessName,Context)) TYPE=InnoDB;
CREATE TABLE xcClusterEngineInfo (EngineName VARCHAR(64) NOT NULL, Heartbeat DATETIME, StartTime DATETIME, ShutDownTime DATETIME, PRIMARY KEY (EngineName)) TYPE=InnoDB;
CREATE TABLE xcWSReceiveRedirect (CorrelationID VARCHAR(100) NOT NULL, ProcessID BIGINT, ActivityName VARCHAR(100), ProcessName VARCHAR(100) NOT NULL, OutputMsg LONGBLOB, OutputMsgName VARCHAR(100) NOT NULL, OutputMsgType INTEGER NOT NULL, PRIMARY KEY (CorrelationID,ProcessName)) TYPE=InnoDB;
CREATE INDEX xcProcessInfo_idx3 ON xcProcessInfo(EngineName(64));

# Initial records that are normally inserted via GNVDBInit:

INSERT INTO xcEngineInfo (ProcessInstances, ProcessCompletes, VersionNumber, LastProcessID, LastTimedEventID, HeartbeatTime, HeartbeatFactor) VALUES(0, 0, 2, 0, 0, 60, 10);
INSERT INTO xcProcessInfo (ProcessName, VersionNumber, Context, ProcessID, ParentID, State, CreateDateTime, ModifyDateTime, LockStatus, EngineName) VALUES('Engine', NULL, NULL, -1, NULL, NULL, NULL, NULL, 0, 'DummyRecord');
