/*
 * $Header: /export/home/cvs/xforms/src/javascripts/old/Common_init1.js,v 1.1 2003/06/14 17:40:41 smu Exp $
 */ 

init();       

// Connector Instance
var xmlHttp;

// DOM Document instances
var xmlDoc;
var xmlInboundDoc;
var xmlOutboundDoc;
var xmlTempDoc;

// Globals
var lastEventId;
var roundtripLock;
var timeStart;
var timeRec;
var timeEnd;
var docArray;
//var debugOutbound = false;
//var debugInbound = false;
//var debugCommunication = false;
//var debugEventFlow = false;
//var debugTime = true;

/* The Init function performs the initiation of the page environment after the load of the page.
*/
function init(){
	docArray = new Array();
    setConnector();
    setDocument();
    roundtripLock = false;
}   


/* The function setConnector Instantiates the Http Connector
*/
function setConnector(){
    if (window.XMLHttpRequest) {
        xmlHttp=new XMLHttpRequest();
    } else {
        if (window.ActiveXObject) {
            xmlHttp = new ActiveXObject("MSXML2.XMLHTTP");
        }
    }
}


/* The function setDocument instantiate the DOM Documents 
*/
function setDocument(){
    if (document.implementation && document.implementation.createDocument) {
        xmlDoc = document.implementation.createDocument("", "", null);
        xmlInboundDoc = document.implementation.createDocument("", "", null);

        Document.prototype.loadXML = function (s) {
            // parse the string to a new doc   
            var doc2 = (new DOMParser()).parseFromString(s, "text/xml");
            // remove all initial children
            while (this.hasChildNodes())
                this.removeChild(this.lastChild);
            // insert and import nodes
            for (var i = 0; i < doc2.childNodes.length; i++) {
                this.appendChild(this.importNode(doc2.childNodes[i], true));
            }
        };

        Document.prototype.__defineGetter__("xml", function (){
                                            return (new XMLSerializer()).serializeToString(this);
                                           });
    } else {
        xmlDoc = new ActiveXObject("MSXML2.DOMDocument");
        xmlInboundDoc = new ActiveXObject("MSXML2.DOMDocument");
    }
}

/* The function setDocumentOutbound creates a DOM document based on a form id. 
   The purpose of this document is to be the carrier of information to be sent to 
   the controller servlet.
   
   Parameter formid: The ID of the form for which the document is generated.
*/
function setDocumentOutbound(formid){     
    var xmlOutboundDocument;
    if (document.implementation && document.implementation.createDocument) {
        xmlOutboundDocument = document.implementation.createDocument("", "", null);
    } else {
        xmlOutboundDocument  = new ActiveXObject("MSXML2.DOMDocument");
    }
	var docSkel = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><document formid=\"" + formid + "\"><controls/></document>"
	xmlOutboundDocument.loadXML(docSkel);
	return xmlOutboundDocument;
}

/* The function getDocumentOutbound retrieves an outblund document from the internal storage
   based on the form id.
   
   Parameter formid: The ID of the form for which the document is generated.
*/
function getDocumentOutbound(formid){
  var arrayDoc = docArray[formid];
  if (arrayDoc != null){
    xmlOutboundDoc = arrayDoc;
  }
  else {
	var xmloutdoc = setDocumentOutbound(formid);    
	docArray[formid] = xmloutdoc;
	xmlOutboundDoc = xmloutdoc;
  }
}

/* The function clearDocumentOutbound removes an outblund document from the internal storage
   based on the form id and inserts a fresh document in the internal storage.
   
   Parameter formid: The ID of the form for which the document is generated.
*/
function clearDocumentOutbound(formid){
	var xmloutdoc = setDocumentOutbound(formid);    
	docArray[formid] = xmloutdoc;
}

/* The function httpLoadXml sends a document to the specified server and loads the resulting 
   document into a inputdocument. 
   
   Parameter uri: the URI to the source of the document
   Parameter outputDoc: the outputDocument to be sent to the server.
   Parameter formid: Id of the form to communicate action/event
*/
function httpLoadXml(uri, outputDoc, formid){

    var parameterString = "xformsid=" + formid + "&xformstransferprotocol="  + outputDoc.xml;
    xmlHttp.open("POST", uri, false);
    xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    //xmlHttp.setRequestHeader("Content-Length",  parameterString.length );

    xmlHttp.send(parameterString);
    var inboundText = xmlHttp.responseText;
    xmlInboundDoc.loadXML(inboundText);
    if (debugInbound || debugCommunication) {
        alert("InboundDoc: \n" + xmlInboundDoc.xml);
    }
}

/* The function savePosition stores a given event in a event que placed in each of the 
   outbound documents. This is generally used to store events such as focus etc. in order to
   track the user curser movements.
   
   Parameter formid: the id of the form in which the event occurs. This identifies the 
                     outbound document.
   Parameter id: the id of the control on which the event occurs.
   Parameter ev: a description of the event.
*/
function savePosition(formid, id, ev){
    getDocumentOutbound(formid);
    var rootList = xmlOutboundDoc.getElementsByTagName("controls");
    var root = rootList[0];
    var controlNode = xmlOutboundDoc.createElement("control");
    root.appendChild(controlNode);
    controlNode.setAttribute("id", id);
    var eventsNode = xmlOutboundDoc.createElement("events");
    controlNode.appendChild(eventsNode);
    var eventNode = xmlOutboundDoc.createElement("event");
    eventsNode.appendChild(eventNode);
    var eventText = xmlOutboundDoc.createTextNode(ev);
    eventNode.appendChild(eventText);
    lastEventId = id;
}         

/* The function handleText retrieves a value from a document text element and return its value.

   Parameter id: the id of the element from which th etext must be retrieved. 
*/
function handleText(id){
    return document.getElementById(id).value;
}   

/* The function handleCheckBox retrieves a value from a form Checkbox element and return its value.

   Parameter id: the id of the element from which th etext must be retrieved. 
*/
function handleCheckBox(id){
    var returnVal = "unchecked";
    if (document.getElementById(id).checked) {
        returnVal="checked";
    }
    return returnVal;
}   

/* The function handleButton retrieves a value from a form Button element and return its value.

   Parameter id: the id of the element from which th etext must be retrieved. 
*/
function handleButton(id){
    return document.getElementById(id).value;
}   

/* The function handleSelectOne retrieves a value from a form Select element and return its value.
   The select must be of the type <Select multiple = 'false' >.

   Parameter id: the id of the element from which th etext must be retrieved. 
*/
function handleSelectOne(id){
    var selectNode = document.getElementById(id);
    var valString = selectNode.options[selectNode.selectedIndex].text;
    return valString;               
}

/* The function handleTextArea retrieves a value from a form TextArea element and return its value.

   Parameter id: the id of the element from which th etext must be retrieved. 
*/
function handleTextArea(id){
    var textNode = document.getElementById(id);
    return textNode.value;
}   

/* The function handleControl retrieves a value from a form Control and return its value.
   This function is general and based on the control type the function calls the appropriate 
   handler.

   Parameter id: the id of the element from which th etext must be retrieved. 
*/
function handleControl(id){
    var typeId = document.getElementById(id).type;
    if (debugOutbound) {
        alert("Control Type : " + typeId);
    }
    if (typeId == "text") {
        return handleText(id);
    }
    if (typeId == "checkbox") {
        return handleCheckBox(id);
    }
    if (typeId == "button") {

        return handleButton(id);
    }
    if (typeId == "select-one") {
        return handleSelectOne(id);
    }
    if (typeId == "select-multiple") {
        return "";
    }
    if (typeId == "textarea") {
        return handleTextArea(id);
    }
}

/* The function buildOutboundDoc builds the final protocol ducument thta is sent to the controller
   servlet. 
   
   Parameter formid: the id of the form in which the event occurs. This identifies the 
                     outbound document.
   Parameter id: the id of the control on which the event occurs.
   Parameter ev: a description of the last trigger event.
*/
function buildOutboundDoc(formid, id, ev){
    getDocumentOutbound(formid);
    var rootList = xmlOutboundDoc.getElementsByTagName("controls");
    var root = rootList[0];
    
    if (id == lastEventId) {
        root.removeChild(root.lastChild);
    }

    var controlNode = xmlOutboundDoc.createElement("control");
    root.appendChild(controlNode);
    controlNode.setAttribute("id", id);
    //Test if control is selectMany
    var selectManyFlag = (document.getElementById(id).type == "select-multiple");
    // set the value attr.
    controlNode.setAttribute("value", handleControl(id));
    if (debugOutbound) {
        alert("Doc Now: \n " + xmlOutboundDoc.xml);
    }
    if (selectManyFlag) {
        var itemsetNode = xmlOutboundDoc.createElement("itemset");
        controlNode.appendChild(itemsetNode);
        var selectNode = document.getElementById(id);
        for (var j = 0; j < selectNode.options.length; j++) {
            var itemNode = xmlOutboundDoc.createElement("item");
            itemNode.setAttribute("label", selectNode.options[j].text);
            var selectedVal = selectNode.options[j].selected;
            var selectedFlag = "true";
            if (selectedVal == "0") {
                selectedFlag = "false"
            }
            itemNode.setAttribute("selected", selectedFlag); 
            itemsetNode.appendChild(itemNode);
        }   
    }
    var eventsNode = xmlOutboundDoc.createElement("events");
    controlNode.appendChild(eventsNode);
    var eventNode = xmlOutboundDoc.createElement("event");
    eventsNode.appendChild(eventNode);
    var eventText = xmlOutboundDoc.createTextNode(ev);
    eventNode.appendChild(eventText);
}

/* The function roundtrip initiates and controls a roundtrip to the controller servlet. 

   Parameter formid: the id of the form in which the event occurs. This identifies the 
                     outbound document.
   Parameter id: the id of the control on which the event occurs.
   Parameter ev: a description of the last trigger event.
*/
function roundtrip(formid, id, ev){
    if (!roundtripLock) {
        if (debugEventFlow) {
            defaultStatus = defaultStatus + "Id: " + id + " RTLock: " + roundtripLock + " ";
        }
        buildOutboundDoc(formid, id, ev); 
        // send the document to the server specified by BaseURI
        if (debugOutbound || debugCommunication) {
            alert("Outbound Document: \n" + xmlOutboundDoc.xml);
        }
		if (debugTime){
		  var d1 = new Date();
          timeStart = d1.getTime();
		}
        httpLoadXml(baseURI, xmlOutboundDoc, formid);
        // If everything is OK - Lets update the document with the response
		if (debugTime){
		  var d2 = new Date();
          timeRec = d2.getTime();
		}
        lastEventId = "";
		clearDocumentOutbound(formid);
        handleDocument();
		if (debugTime){
		  var d3 = new Date();
		  timeEnd = d3.getTime();
		  defaultStatus = "Communication time: " + (timeRec - timeStart) + " mSec, Rendering Time: " + (timeEnd - timeRec) + " mSec";
		}  

    }
}

function rerender(id, ev){
    rerender();
}

/* The function rerender controls the rendering process in the case that a given form needs to be 
   rerendered. This is generally called in the case that a xforms repeat have inserted or deleted 
   items but can also be used if a style within a form changes.
   
   Parameter formNode: the DOM node that shall replace an existing node identified by a mutual node id.
*/
function rerender(formNode){
    var formId = formNode.attributes.getNamedItem("id").value;
    var replaceNode = document.getElementById(formId);
    var insertNode = document.createElement("form");
    var insertPoint = replaceNode.parentNode;
    insertNode.setAttribute("id", formId);
    buildNewNode(formNode, insertNode);
    insertPoint.replaceChild(insertNode, replaceNode);
}       

/* The function handleAlerts displays a list of alerts if these are present.

   Parameter aLIst: a List containing all alert texts
   DEPRECATED! 
*/
function handleAlerts(aList){
    for (var i = 0; i < aList.length; i++) {
        var alertNode = aList[i];
        var alertString = alertNode.firstChild.nodeValue;
        alert(alertString);
    }   
}

/* The function handleHint sets the title of a given control so that this reflects a hint on the control.

   Parameter id: the id of the control. 
   Parameter hintNode: a DOM Node containing the hint
   DEPRECATED! 
*/
function handleHint(id, hintNode){
    document.getElementById(id).title = hintNode.firstChild.nodeValue;
}   

/* the function handleItemSet updates a itemset control based on the itemsetNode.

   Parameter id: the id of the control. 
   Parameter itemsetNode: a DOM Node containing the new values for the control.
*/
function handleItemSets(id, itemsetNode){
    roundtripLock = true;
    if (debugEventFlow) {
        defaultStatus = defaultStatus + " Item Set Handling ";
    }
    selectNode = document.getElementById(id);
    itemList = itemsetNode.getElementsByTagName("item");
    //var optionNode = selectNode.getElementsByTagName("option");
    for (var i = 0; i < itemList.length; i++) {
        var selected = itemList.item(i).getAttribute("selected");
        if (selected == "true") {
            //optionNode.item(i).setAttribute("selected", true);
            selectNode.options[i].selected = true;
        } else {
            //optionNode.item(i).setAttribute("selected", false);
            selectNode.options[i].selected = false;
        }   
    }
    roundtripLock = false;
}   

/* The function handleProperties updates a number of properties on a given control.
   The xfroms properties that currently is handled in this function are:
   - readonly
   - relevant
   - focus.
   
   Parameter controlId: The id of the control for which the properties must be applied
   Parameter attnode: a DOM Node containing the properties.
*/
function handleProperties(controlId, attnode){
    var propMap = attnode.attributes;
    var readonly = propMap.getNamedItem("readonly");
    var relevant = propMap.getNamedItem("relevant");
    if ((readonly != null && readonly.value == "true") || (relevant != null && relevant.value == "false")) {
        document.getElementById(controlId).disabled=true;
    } else {
        document.getElementById(controlId).disabled=false;
    }
    var propfocus = propMap.getNamedItem("focus");
    if (propfocus != null && propfocus.value == "true") {
        document.getElementById(controlId).hasfocus=true;
    }
}                     

/* The function handleDocument is the main updater of incomming protocol documents. 
   The function handles both updates of single controls and full rerendering on an entire form
   (this is delegated to the rerender function)
*/
function handleDocument(){
    if (xmlInboundDoc.xml != "") {
        var rodNode = xmlInboundDoc.documentElement;
        if (rodNode.nodeName == "form") {
            rerender(rodNode);
        } else {
		  var submitNode = xmlInboundDoc.getElementsByTagName("submitinfo");
		  if (submitNode.length > 0){
		    // we now go into the submit mode
			//alert("SubmitInfo:" + submitNode.item(0).firstChild.nodeValue);
			performSubmit(rodNode, submitNode.item(0).firstChild.nodeValue);
		  }
		  else	
		
		{

            var nodeList = xmlInboundDoc.getElementsByTagName("control");
            for (var i = 0; i < nodeList.length; i++) {
                var node = nodeList.item(i);
                var attMap = node.attributes;
                var ctrlId = attMap.getNamedItem("id").value;
                var ctrlValue = "";
                var valNode = attMap.getNamedItem("value");
                if (valNode != null) {
                    ctrlValue = valNode.value;
                }
                if (debugInbound) {
                    alert("Control Id: " + ctrlId +"\nValue: " + ctrlValue);
                }
                // Handle Values
                var typeId = document.getElementById(ctrlId).nodeName;
                if (ctrlValue != "") {
                    if (typeId == "SPAN") {
                        document.getElementById(ctrlId).innerHTML = ctrlValue;
                    } else {
                        document.getElementById(ctrlId).value = ctrlValue;
                    }
                }
                // Handle ItemSets
                var itemSetList = node.getElementsByTagName("itemset");
                if ((itemSetList != null && itemSetList.length > 0) && ctrlValue == "") {
                    handleItemSets(ctrlId, itemSetList.item(0));
                }
                // Handle labels
                var labellist = node.getElementsByTagName("label");
                if (labellist.length > 0) {
                    attMap = labellist.item(0).attributes;
                    var labelId = attMap.getNamedItem("id").value;
                    var labelVal = attMap.getNamedItem("value").value;
                    document.getElementById(labelId).innerHTML = labelVal;
                }
                // Handle properties
                var proplist = node.getElementsByTagName("properties");
                if (proplist.length > 0) {
                    handleProperties(ctrlId, proplist.item(0));
                }
                // Handle Hints
                var hintList = node.getElementsByTagName("hint");
                if (hintList.length > 0) {
                    handleHint(ctrlId, hintList.item(0));
                }
                // Handle Alerts
                var alertList = node.getElementsByTagName("alert");
                if (alertList.length > 0) {
                    handleAlerts(alertList);
                }
            }
			}
        }
    }
}

/* The function setNewAttributes handles movement of attributes within a DOM Node to a document node

   Parameter sourceNode: a DOM Node containing the source attributes.
   Parameter targetNode: the target document Node 
*/
function setNewAttributes(sourceNode, targetNode){
    var attr = sourceNode.getAttribute("name");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("name", attr);
    }
    attr = sourceNode.getAttribute("value");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("value", attr);
    }
    attr = sourceNode.getAttribute("title");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("title", attr);
    }
    attr = sourceNode.getAttribute("align");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("align", attr);
    }
    attr = sourceNode.getAttribute("style");
    if ((attr != null) && (attr != "")) {
        styleAttributes(targetNode, attr);
    }
    attr = sourceNode.getAttribute("valign");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("valign", attr);
    }
    attr = sourceNode.getAttribute("border");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("border", attr);
    }
    attr = sourceNode.getAttribute("cellpadding");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("cellpadding", attr);
    }
    attr = sourceNode.getAttribute("cellspacing");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("cellspacing", attr);
    }
    attr = sourceNode.getAttribute("clear");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("clear", attr);
    }
    attr = sourceNode.getAttribute("noflow");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("noflow", attr);
    }
    attr = sourceNode.getAttribute("nowrap");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("nowrap", attr);
    }
    attr = sourceNode.getAttribute("width");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("width", attr);
    }
    attr = sourceNode.getAttribute("colspan");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("colspan", attr);
    }
    attr = sourceNode.getAttribute("rowspan");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("rowspan", attr);
    }
    attr = sourceNode.getAttribute("disabled");
    if ((attr != null) && (attr != "")) {
        targetNode.setAttribute("disabled", attr);
    }
    attr = sourceNode.getAttribute("onchange");
    if ((attr != null) && (attr != "")) {
        targetNode.onchange = new Function("" + attr);
    }
    attr = sourceNode.getAttribute("onclick");
    if ((attr != null) && (attr != "")) {
        targetNode.onclick = new Function("" + attr);
    }
    attr = sourceNode.getAttribute("onfocus");
    if ((attr != null) && (attr != "")) {
        targetNode.onfocus = new Function("" + attr);
    }
    attr = sourceNode.getAttribute("onblur");
    if ((attr != null) && (attr != "")) {
        targetNode.onblur = new Function("" + attr);
    }
}

/* The function buildNewNode is a recursive method which is used to build a document form 
   based on a W3C DOM reprersentation of the form. 
   
   Parameter sourceXMLNode: the DOM Node to be copied.
   Parameter targetdocumentNode: the target document Node.
*/
function buildNewNode(sourceXmlNode, targetDocumentNode){
    var nodeList = sourceXmlNode.childNodes;
    var i;
    for (i = 0; i < nodeList.length; i++) {
        var currNode = nodeList.item(i);

// BR
        if (currNode.nodeName == "br") {
            var newNode = document.createElement("br");
            targetDocumentNode.appendChild(newNode);
        }

// HR
        if (currNode.nodeName == "hr") {
            var newNode = document.createElement("hr");
            targetDocumentNode.appendChild(newNode);
        }

// DIV
        if (currNode.nodeName == "div") {
            var newNode = document.createElement("div");
            newNode.setAttribute("id", currNode.getAttribute("id"));
            setNewAttributes(currNode, newNode);
            targetDocumentNode.appendChild(newNode);
            buildNewNode(currNode, newNode);
        }

// SELECT
        if (currNode.nodeName == "select") {
            var newNode = document.createElement("select");
            newNode.setAttribute("id", currNode.getAttribute("id"));
            attr = currNode.getAttribute("multiple");
            if ((attr != null) && (attr != "")) {
                newNode.setAttribute("multiple", attr);
            }
            setNewAttributes(currNode, newNode);
            targetDocumentNode.appendChild(newNode);
            buildNewNode(currNode, newNode);
        }

// OPTION
        if (currNode.nodeName == "option") {
            var newNode = document.createElement("option");
            newNode.setAttribute("id", currNode.getAttribute("id"));
            var attr = currNode.getAttribute("selected");
            if ((attr != null) && (attr != "")) {
                newNode.setAttribute("selected", attr);
            }
            setNewAttributes(currNode, newNode);
            targetDocumentNode.appendChild(newNode);
            buildNewNode(currNode, newNode);
        }

// INPUT
        if (currNode.nodeName == "input") {
            var newNode = document.createElement("input");
            newNode.setAttribute("id", currNode.getAttribute("id"));
            newNode.setAttribute("type", currNode.getAttribute("type"));
            setNewAttributes(currNode, newNode);
            targetDocumentNode.appendChild(newNode);
            buildNewNode(currNode, newNode);
        }

// SPAN
        if (currNode.nodeName == "span") {
            var newNode = document.createElement("span");
            newNode.setAttribute("id", currNode.getAttribute("id"));
            setNewAttributes(currNode, newNode);
            targetDocumentNode.appendChild(newNode);
            buildNewNode(currNode, newNode);
        }

// TEXTAREA
        if (currNode.nodeName == "textarea") {
            var newNode = document.createElement("textarea");
            newNode.setAttribute("id", currNode.getAttribute("id"));
            var attr = currNode.getAttribute("cols");
            if ((attr != null) && (attr != "")) {
                newNode.setAttribute("cols", attr);
            }
            attr = currNode.getAttribute("rows");
            if ((attr != null) && (attr != "")) {
                newNode.setAttribute("rows", attr);
            }
            attr = currNode.getAttribute("wrap");
            if ((attr != null) && (attr != "")) {
                newNode.setAttribute("wrap", attr);
            }
            setNewAttributes(currNode, newNode);
            targetDocumentNode.appendChild(newNode);
            buildNewNode(currNode, newNode);
        }

// TABLE
        if (currNode.nodeName == "table") {
            var newNode = document.createElement("table");
            var attr = currNode.getAttribute("id");
            if ((attr != null) && (attr != "")) {
                newNode.setAttribute("id", attr);
            }
            setNewAttributes(currNode, newNode);
            targetDocumentNode.appendChild(newNode);
            buildNewNode(currNode, newNode);
        }

// TR
        if (currNode.nodeName == "tr") {
            var newNode = document.createElement("tr");
            var attr = currNode.getAttribute("id");
            if ((attr != null) && (attr != "")) {
                newNode.setAttribute("id", attr);
            }
            setNewAttributes(currNode, newNode);
            targetDocumentNode.appendChild(newNode);
            buildNewNode(currNode, newNode);
        }

// TH
        if (currNode.nodeName == "th") {
            var newNode = document.createElement("th");
            var attr = currNode.getAttribute("id");
            if ((attr != null) && (attr != "")) {
                newNode.setAttribute("id", attr);
            }
            setNewAttributes(currNode, newNode);
            targetDocumentNode.appendChild(newNode);
            buildNewNode(currNode, newNode);
        }

// TD
        if (currNode.nodeName == "td") {
            var newNode = document.createElement("td");
            var attr = currNode.getAttribute("id");
            if ((attr != null) && (attr != "")) {
                newNode.setAttribute("id", attr);
            }
            setNewAttributes(currNode, newNode);
            targetDocumentNode.appendChild(newNode);
            buildNewNode(currNode, newNode);
        }

// RAW TEXT 			
        if (currNode.nodeType == 3) {
            if (currNode.nodeValue != null && currNode.nodeValue != "") {
                var newNode = document.createTextNode(currNode.nodeValue);
                targetDocumentNode.appendChild(newNode);
            }
        }
    }
}  

function performSubmit(rodNode, submitInfo){
  if (rodNode.nodeName == "document"){
    var formId = rodNode.getAttribute("formid");
    var replaceNode = document.getElementById(formId);
    var insertNode = document.createElement("form");
    var insertPoint = replaceNode.parentNode;
    insertNode.setAttribute("id", formId);
	var stringArray = submitInfo.split(";");
	var actionStr = stringArray[0].split("=")[1];
	var methodStr = stringArray[2].split("=")[1];
	var typeStr = stringArray[3].split("=")[1];
	var docStr = stringArray[4];
	docStr = docStr.substring(docStr.indexOf("=") + 1, docStr.length);
	if (typeStr == "all"){
	  insertNode.setAttribute("action", actionStr);
	  insertNode.setAttribute("method", methodStr);
      if (methodStr == "get"){
	    var fieldArray = docStr.split("&");
	    for (var i = 1; i < fieldArray.length - 1; i++){
	      var nameValuePair = fieldArray[i].split("=");
	      var fieldNode = document.createElement("input");
	      fieldNode.setAttribute("type", "hidden")
	      fieldNode.setAttribute("name", nameValuePair[0]);
	      fieldNode.setAttribute("value", nameValuePair[1]);
	      insertNode.appendChild(fieldNode);
	    }
      }
	  else{
	    if (methodStr == "post"){
		// NB! Not Spec complient ... Investigations ongoing regarding the final spec compliant solution
	      var fieldNode = document.createElement("input");
	      fieldNode.setAttribute("type", "hidden")
	      fieldNode.setAttribute("name", "submission");
	      fieldNode.setAttribute("value", docStr);
	      insertNode.appendChild(fieldNode);
		}  
	  }	  		
      insertPoint.replaceChild(insertNode, replaceNode);
	  document.getElementById(formId).submit();
	}
	else{
	  if (typeStr == "none" || typeStr == "instance" ){
	    performSubmitSequence(formId, typeStr, actionStr, methodStr, docStr)
		//alert(typeStr + " WAS CALLED");
	  }
	}  
  }	
  
  function performSubmitSequence(formid, type, action, method, instanceDoc){
    //httpLoadXml(baseURI, xmlOutboundDoc, formid);
    xmlHttp.open(method, action, false);
	if (method == "get"){
      xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	}
	else{
	  xmlHttp.setRequestHeader("Content-Type", "application/xml");
	}    
    //xmlHttp.setRequestHeader("Content-Length",  parameterString.length );

    //alert("Ready to send data");
    xmlHttp.send(instanceDoc);
    var inboundText = xmlHttp.responseText;
	//alert("This is received from submit target: \n" + inboundText );
	if (type == "instance"){
	// prepare the result doc
        buildOutboundDoc(formid, formid, "ev-submit-success"); 
        processSubmitResult(inboundText);
        httpLoadXml(baseURI, xmlOutboundDoc, formid);
	}
	else{
	  if (type == "none"){
        buildOutboundDoc(formid, formid, "ev-submit-success"); 
        httpLoadXml(baseURI, xmlOutboundDoc, formid);
	  }
	}
    // If everything is OK - Lets update the document with the response
    lastEventId = "";
	clearDocumentOutbound(formid);
    handleDocument();
  }  
}

function processSubmitResult(resultNodeString){
  setTempDocument();
  var docSkel = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><instance>";
  var endDoc = "</instance>";
  xmlTempDoc.loadXML(docSkel + resultNodeString + endDoc);
  var tempNode = xmlTempDoc.documentElement;
  var tempClone = tempNode.cloneNode(true);
  var rootList = xmlOutboundDoc.getElementsByTagName("controls");
  var root = rootList[0];
  root.appendChild(tempNode);
}

function setTempDocument(){   
    xmlTempDoc = null;
    if (document.implementation && document.implementation.createDocument) {
        xmlTempDoc = document.implementation.createDocument("", "", null);
    } else {
        xmlTempDoc  = new ActiveXObject("MSXML2.DOMDocument");
    }
}
