/* MOZILLA ONLY */

/* The function styleAttributes provides the Mozilla specific handling of
   CSS styling. Generally used when a form is redrawn.
   Parameter targetNode: The document node that the style should be applied to.
   Parameter styleString: The string containing the full style description.
                          must be in standard CSS format.
*/
function styleAttributes(targetNode, styleString){
    targetNode.setAttribute("style", styleString);
}       

/* The function setDocument is used to set the Mozilla specific document environment.
*/
function setDocument(){
    xmlDoc = document.implementation.createDocument("", "", null);
    xmlInboundDoc = document.implementation.createDocument("", "", null);

    Document.prototype.loadXML = function (s) {
        var doc2 = (new DOMParser()).parseFromString(s, "text/xml");
        while (this.hasChildNodes())
            this.removeChild(this.lastChild);
        for (var i = 0; i < doc2.childNodes.length; i++) {
            this.appendChild(this.importNode(doc2.childNodes[i], true));
        }
    };

    Document.prototype.__defineGetter__("xml", function (){return (new XMLSerializer()).serializeToString(this);});

}

