
//------------------------------ Controller -------------------------

function Controller() {}

// Singleton handling
Controller.controller=null;

Controller.getInstance = function() {
  if (Controller.controller==null)
    Controller.controller = new Controller();
  return Controller.controller; 
} 

Controller.prototype.DOMFocusIn = function(formid, id, event, priority) {
  Framework.registerEvent(Package.packSimpleEvent(formid, id, event), formid, priority );
}  
 
Controller.prototype.DOMFocusOut = function(formid, id, event, priority) {
  Framework.registerEvent(Package.packSimpleEvent(formid, id, event), formid, priority );
}  

Controller.prototype.setId = function (xhtmlNode, id) {
  xhtmlNode.setAttribute("id", id);
}

Controller.prototype.setStyle = function (xhtmlNode, style) {
  Util.setStyleAttributes(xhtmlNode, style);
}

Controller.prototype.setOptions = function (xhtmlNode, readonly, relevant) {
  Util.setReadonlyRelevantAttributes(xhtmlNode, readonly, relevant);
}

Controller.prototype.setEvents = function (xhtmlNode, eventsArray) {
  xhtmlNode = Util.setEvents(xhtmlNode, eventsArray); 
}

Controller.prototype.createXhtmlMarkup = function (renderNode) {
  alert("No createXhtmlMarkup implemented for control");
}

Controller.prototype.render = function (renderNode, createXhtmlMarkup, updateXhtmlNode){  
  
  var instance = Util.getInstance(renderNode);
  var xhtmlNode = null;
  if (createXhtmlMarkup) {
    xhtmlNode = instance.createXhtmlMarkup(renderNode); 
  } else {
    xhtmlNode = document.getElementById(Package.getId(renderNode)); 
  }
  
  if (updateXhtmlNode && (xhtmlNode != null)) {
    instance.doUpdate(renderNode, xhtmlNode); 
  }

  return xhtmlNode;
}

Controller.prototype.doUpdate = function (renderNode, xhtmlNode) {
  var instance = Util.getInstance(renderNode);
  instance.setId(xhtmlNode, Package.getId(renderNode));    
  instance.setStyle(xhtmlNode, Package.getStyle(renderNode));
  var nl = renderNode.childNodes;
  for (i=0;i<nl.length;i++) {
    var node = nl.item(i);
    if (node.nodeType==1) { // Element node
      if (node.tagName=="options")
        instance.setOptions(xhtmlNode, Package.getReadOnly(node), Package.getRelevant(node));
      if (node.tagName=="events")
        instance.setEvents(xhtmlNode, Package.getEvents(node));
    }
  }
}

//------------------------------ ControlController -------------------------

function ControlController() {}
ControlController.prototype = new Controller();
// Singleton handling
ControlController.controlController=null;

ControlController.getInstance = function() {
  if (ControlController.controlController==null)
    ControlController.controlController = new ControlController();
  return ControlController.controlController; 
}

ControlController.prototype.doUpdate = function (renderNode, xhtmlNode) {
  var instance = Util.getInstance(renderNode);
  xhtmlNode = instance.setValue(renderNode, xhtmlNode);
  Controller.getInstance().doUpdate(renderNode, xhtmlNode);
}

ControlController.prototype.xforms_value_changed = function(formid, id, event, priority, value) {
  Framework.registerEvent(Package.packValueEvent(formid, id, event, value), formid, priority);
}  

ControlController.prototype.getValue = function(id) {
  return document.getElementById(id).value; 
}


ControlController.prototype.setValue= function (renderNode, xhtmlNode) {
  var value = Package.getValue(renderNode);
  if (value != null) {
    xhtmlNode.setAttribute("value", value);
  }
  return xhtmlNode;
}


//------------------------------ ContainerController -------------------------

function ContainerController() {}
ContainerController.prototype = new Controller();

// Singleton handling
ContainerController.containerController=null;
ContainerController.getInstance = function() {
  if (ContainerController.containerController==null)
    ContainerController.containerController= new ContainerController();
  return ContainerController.containerController; 
}

ContainerController.prototype.render = function (renderNode, createXhtmlMarkup, updateXhtmlNode) { 
  var xhtmlNode = Controller.getInstance().render(renderNode, createXhtmlMarkup, updateXhtmlNode);
  if (createXhtmlMarkup) {
    var controlsArray = Package.getControlsArray(renderNode); 
    for (var i= 0; i < controlsArray.length; i++ ) {
        var controlArray = Package.getControlArray(controlsArray[i]);
        if (controlArray != null) {
            for (var j=0; j < controlArray.length; j++) {
            var control = Util.getInstance(controlArray[j]).render(controlArray[j],createXhtmlMarkup,updateXhtmlNode); 
                if (control != null)
                    xhtmlNode.appendChild(control);
                }
            } 
        } 
        return xhtmlNode;
    }
    else return null;
}

//------------------------------ Group -------------------------

function Group() {}
Group.prototype = new ContainerController();

// Singleton handling
Group.group=null;
Group.getInstance = function() {
  if (Group.group==null)
    Group.group= new Group();
  return Group.group; 
}


Group.prototype.createXhtmlMarkup = function(rendeNode) {
  var newGroupNode = document.createElement("div");
  return newGroupNode;
}

//------------------------------ Repeat -------------------------

function Repeat() {}
Repeat.prototype = new ContainerController();

// Singleton handling
Repeat.repeat=null;
Repeat.getInstance = function() {
  if (Repeat.repeat==null)
    Repeat.repeat= new Repeat();
  return Repeat.repeat; 
}

Repeat.prototype.createXhtmlMarkup = function() {
  var newRepeatNode = document.createElement("div");
  return newRepeatNode;
}


//------------------------------ Labeled -------------------------
function Labeled() {}
Labeled.prototype = new ControlController();

// Singleton handling
Labeled.labeled=null;
Labeled.getInstance = function() { 
  if (Labeled.labeled==null)
    Labeled.labeled = new Labeled();
  return Labeled.labeled; 
}

Labeled.prototype.createXhtmlMarkup = function() {
  var newLabeledNode = document.createElement("span");
  newLabeledNode.setAttribute("id", "NOCONTROL"); ///
  return newLabeledNode;
}


Labeled.prototype.render = function (renderNode, createXhtmlMarkup, updateXhtmlNode) { 
  var instance = Util.getInstance(renderNode);
  var xhtmlNode = ControlController.getInstance().render(renderNode, createXhtmlMarkup, updateXhtmlNode);
  if (createXhtmlMarkup) {
    var labeledXhtmlNode = Labeled.getInstance().createXhtmlMarkup();// ctype explicit specified
    var labelControlsArray = Package.getLabels(renderNode);
    var labelXhtmlNodeArray = new Array();
    for (var i=0; i < labelControlsArray.length; i++) {
      labelXhtmlNodeArray[i] = Label.getInstance().render(labelControlsArray[i],createXhtmlMarkup,updateXhtmlNode); //ctype explicit specified
    }
    labeledXhtmlNode = instance.placeLabels(renderNode, xhtmlNode,labelXhtmlNodeArray, labeledXhtmlNode);
    return labeledXhtmlNode;
  } else
    return null;
}

//insert labels before xhtmlNode
Labeled.prototype.placeLabels = function(renderNode, xhtmlNode, labelXhtmlNodeArray, labeledXhtmlNode) {
  for (var i = 0; i < labelXhtmlNodeArray.length; i++ ) {
    labeledXhtmlNode.appendChild(labelXhtmlNodeArray[i]);
  }  
  labeledXhtmlNode.appendChild(xhtmlNode);
  return labeledXhtmlNode;
}

//------------------------------ Label -------------------------


function Label() {}
Label.prototype = new ControlController();

// Singleton handling
Label.label=null;
Label.getInstance = function() { 
  if (Label.label==null)
    Label.label = new Label();
  return Label.label; 
}

Label.prototype.createXhtmlMarkup = function() {
  var newLabelNode = document.createElement("span");
  return newLabelNode;
}


Label.prototype.setValue = function (renderNode, xhtmlNode) {
  var value = Package.getValue(renderNode);
  if (value != null) {
    if (xhtmlNode.firstChild != null)
      xhtmlNode.removeChild(xhtmlNode.firstChild);
    xhtmlNode.appendChild(document.createTextNode(value)); 
  }
  return xhtmlNode;
}

//------------------------------ Input -------------------------

function Input() {}
Input.prototype = new Labeled();

// Singleton handling
Input.input=null;
Input.getInstance = function() { 
  if (Input.input==null)
    Input.input = new Input();
  return Input.input; 
}

Input.prototype.createXhtmlMarkup = function(renderNode) {
    var xhtmlNode = document.createElement("input");
    xhtmlNode.setAttribute("type", "text");
  return xhtmlNode;
}

//------------------------------ Button -------------------------

function Button() {}
Button.prototype = new Labeled();

// Singleton handling
Button.button=null;
Button.getInstance = function() { 
  if (Button.button==null)
    Button.button = new Button();
  return Button.button; 
}

Button.prototype.createXhtmlMarkup = function(renderNode) {
  var xhtmlNode = document.createElement("input");
  xhtmlNode.setAttribute("type", "button");   
  return xhtmlNode;
}

Button.prototype.xforms_activate = function(formid, id, event, priority) {
  Framework.registerEvent(Package.packSimpleEvent(formid, id, event), formid, priority);  
} 


//insert label within the Control
Button.prototype.placeLabels = function(renderNode, xhtmlNode,labelXhtmlNodeArray, labeledXhtmlNode) {
  var instance = Util.getInstance(renderNode);
  labelValue = "";
  for (var i = 0; i < labelXhtmlNodeArray.length; i++ ) {
    labelValue = labelValue+labelXhtmlNodeArray[i].firstChild.nodeValue;
  }
  xhtmlNode = instance.setValue(labelValue, xhtmlNode);
  labeledXhtmlNode = xhtmlNode
  return labeledXhtmlNode;
}

Button.prototype.setValue= function (renderValue, xhtmlNode) {
  if (typeof(renderValue) == "string")
    xhtmlNode.setAttribute("value", renderValue);
  return xhtmlNode;
}


//------------------------------ SelectOne -------------------------

function SelectOne() {}
SelectOne.prototype = new Labeled();

// Singleton handling
SelectOne.selectOne=null;
SelectOne.getInstance = function() { 
  if (SelectOne.selectOne==null)
    SelectOne.selectOne = new SelectOne();
  return SelectOne.selectOne; 
}


SelectOne.prototype.render = function (renderNode, createXhtmlMarkup, updateXhtmlNode) { 
  
  var xhtmlNode = Labeled.getInstance().render(renderNode, createXhtmlMarkup, updateXhtmlNode);
  if (createXhtmlMarkup) {
    var itemsArray = Package.getItemsArray(renderNode);
    if (itemsArray != null) {
        for (var i=0; i < itemsArray.length; i++) {
            var item = itemsArray[i];  
            var option = document.createElement("option");
            var label_text = document.createTextNode(item[0].value)
            option.appendChild(label_text);
            option.setAttribute("value", item[1].value);
            xhtmlNode.lastChild.appendChild(option); // because the Labeled control is placed at the end of a list
            } 
        }
        return xhtmlNode;
    }
    else
        return null;
}

SelectOne.prototype.createXhtmlMarkup = function(renderNode) {
  var xhtmlNode = document.createElement("select");
  return xhtmlNode;
}

SelectOne.prototype.doUpdate = function (renderNode, xhtmlNode) {
  var instance = Util.getInstance(renderNode);
  xhtmlNode = instance.setSelected(renderNode, xhtmlNode);
  Labeled.getInstance().doUpdate(renderNode, xhtmlNode);
}

SelectOne.prototype.setSelected= function (renderNode, xhtmlNode) {
  var value = Package.getValue(renderNode);
  if (value != null) {
    var nl = xhtmlNode.childNodes;
    for (i=0;i<nl.length;i++) {
        var option = nl.item(i);
        if (option.getAttribute("value") ==  value)
            option.selected=true;
         else
            option.selected=false;
        }
    }
    return xhtmlNode;
}


//------------------------------ Select -------------------------

function Select() {}
Select.prototype = new SelectOne();

// Singleton handling
Select.select=null;
Select.getInstance = function() { 
  if (Select.select==null)
    Select.select = new Select();
  return Select.select; 
}


Select.prototype.createXhtmlMarkup = function(renderNode) {
  var xhtmlNode = null;
  if (isMSIE) {
    xhtmlNode = document.createElement("<select multiple=\"multiple\"></select>");
    }
  else if (isMozilla) {
    xhtmlNode = document.createElement("select");
    xhtmlNode.setAttribute("multiple","multiple");
    }

  return xhtmlNode;
}

Select.prototype.setSelected= function (renderNode, xhtmlNode) {
  var value = Package.getValue(renderNode);
  if (value != null) {
    var valueArray = value.split(" ");
    var nl = xhtmlNode.childNodes;
    for (i=0;i<nl.length;i++) {
        var option = nl.item(i);
        option.selected=false;
        for(j=0; j < valueArray.length; j++) {
            if (option.getAttribute("value") == valueArray[j])
                option.selected=true;    
            }
        }
    }
    return xhtmlNode;
}

Select.prototype.getValue = function(id) {
    var selectElement = document.getElementById(id);
    var value = "";
    var nl = selectElement.childNodes 
        for (i=0;i<nl.length;i++) {
            var option = nl.item(i);
            if (option.selected == true)
                value = value + " "+option.value
            }
    return value;
}



//------------------------------ Xhtml -------------------------

function XHtml() {}
XHtml.prototype = new ContainerController(); 

// Singleton handling
XHtml.xHtml=null;
XHtml.getInstance = function() { 
  if (XHtml.xHtml==null)
    XHtml.xHtml= new XHtml();
  return XHtml.xHtml; 
}

XHtml.prototype.createXhtmlMarkup = function(renderNode) {
  var xhtmlNode = null;
    
  if ( renderNode.getAttribute("tag") != null && renderNode.getAttribute("tag").value != "") {
    var tag = renderNode.getAttribute("tag");
    xhtmlNode = document.createElement(tag);
  }
  if ( renderNode.getAttribute("text") != null && renderNode.getAttribute("text").value != "") {
    var text = renderNode.getAttribute("text");
    xhtmlNode = document.createTextNode(text);
  }
  return xhtmlNode;
}

XHtml.prototype.setId = function (xhtmlNode, id) {
  // overload method from Controller because in XHtml should no Id be set
}

