//browser informations
var isMSIE = false;
var isMozilla = false;

//debug informations
var debug = false;
var debugOutbound = false;
var debugInbound = false;
var debugCommunication = false;

//communication informations
var xmlHttp;
var inboundDocument;
var outboundDocument;
 
//constants
var DOC_SKEL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
function Framework() {}
 
//------------------------------ Initialize communication ------------------------------ 

function xformsInit(){
  if ((userAgent == "MSIE") && (userAgentVersion == "6.0")) {
    isMSIE = true;
  }
  if ((userAgent == "Mozilla") && (userAgentVersion == "6.0")) {
    isMozilla = true;
  }
  Framework.setConnector();   
  Framework.setDocumentInbound();   
  Framework.setDocumentOutbound();
  if (debugInbound || debugCommunication)
    alert("FirstPackages: "+firstPackages);
  Framework.loadNewXForms(firstPackages);
  var root = inboundDocument.documentElement;
  Framework.traversePackages(root);
}

Framework.loadNewXForms = function(inString) {     
  var doc = ""+DOC_SKEL+inString;
  inboundDocument.loadXML(doc);
  return inboundDocument;
}

Framework.httpLoadXml = function(formid) {
  if (debugOutbound || debugCommunication) {
    alert("outboundDocument: "+outboundDocument.xml);
  }
  var parameterString = "xformsid=" + formid + "&xformstransferprotocol="  + outboundDocument.xml;
  xmlHttp.open("POST", xformsServletUrl, false);
  xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
  xmlHttp.send(parameterString);
  var inboundText = xmlHttp.responseText; 
  inboundDocument.loadXML(inboundText); 
  if (debugInbound || debugCommunication) {
    alert("inboundDocument: " + inboundDocument.xml);
  }
  Framework.setDocumentOutbound(); ///reset OutboundDocument
}

Framework.setConnector = function() {
  if (window.XMLHttpRequest) {
    xmlHttp=new XMLHttpRequest();
  } else {
    if (window.ActiveXObject) {
      xmlHttp = new ActiveXObject("MSXML2.XMLHTTP");
    }
  }
}

Framework.setDocumentOutbound = function() {
  if (document.implementation && document.implementation.createDocument)
    outboundDocument = document.implementation.createDocument("", "", null);
  else
    outboundDocument  = new ActiveXObject("MSXML2.DOMDocument");    
  var doc = DOC_SKEL+"<controls/>";  
  outboundDocument.loadXML(doc);    
}
 
Framework.setDocumentInbound = function() {
  if (isMSIE) {
    inboundDocument = new ActiveXObject("MSXML2.DOMDocument");
    }
  else if (isMozilla) {
    inboundDocument = document.implementation.createDocument("", "", null);
    Document.prototype.loadXML = function (s) {
      var doc2 = (new DOMParser()).parseFromString(s, "text/xml");
        while (this.hasChildNodes())
            this.removeChild(this.lastChild);
        for (var i = 0; i < doc2.childNodes.length; i++) {
            this.appendChild(this.importNode(doc2.childNodes[i], true));
        }
    };
    Document.prototype.__defineGetter__("xml", function (){return (new XMLSerializer()).serializeToString(this);});
    }
}

Framework.getXMLOutboundDocument = function(formid) {
  // :UNRESOLVED: Should pick the document corresponding to the formid
  return outboundDocument;
}


//------------------------------  Packages traversing ------------------------------ 

Framework.traversePackages = function(root) {
  var controlsArray = Package.getControlsArray(root);
  for (var i=0; i < controlsArray.length; i++) {
    var controls  = controlsArray[i];
    var action = controls.attributes.getNamedItem("action").value; 
    if ((action != null) && (action == "render")) {
      Framework.traverseRender_package(controls);
    }
    else if ((action != null) && (action == "update")) {
      Framework.traverseUpdate_package(controls);
    }
    else if ((action != null) && (action == "submit")) {
      var submitNode = root.getElementsByTagName("submitinfo");
      if (submitNode.length > 0){
      Framework.performSubmit(submitNode.item(0).firstChild.nodeValue);
      }
    }
  }
}

Framework.traverseRender_package = function(replaceNode) {
  var replaceid = replaceNode.attributes.getNamedItem("replaceid").value;
  renderNode = replaceNode.firstChild;
  var placeHolderNode = document.getElementById(replaceid); 
  if (placeHolderNode == null) {
    return;
    }     
  var parentNode = placeHolderNode.parentNode;
  if ((parentNode.id == "NOCONTROL")) {
    placeHolderNode = parentNode;
    parentNode = parentNode.parentNode;
    }
  var ctype = renderNode.attributes.getNamedItem("ctype").value;
  var newNodeFunction = new Function("return "+ctype+".getInstance().render(this.renderNode,true,true)");
  var returnNode = newNodeFunction();
  parentNode.replaceChild(returnNode, placeHolderNode); 
}

Framework.traverseUpdate_package = function(updateControlsNode) { 
  var controlNodes = updateControlsNode.childNodes;
  for (var i=0; i < controlNodes.length ; i++) {
    updateNode = controlNodes.item(i);
    var updateId = updateNode.attributes.getNamedItem("id").value;
    var documentNode = document.getElementById(updateId);
    var ctype = updateNode.attributes.getNamedItem("ctype").value;
    var newNodeFunction = new Function("return "+ctype+".getInstance().render(this.updateNode,false,true)");
    newNodeFunction();
  }
} 


//------------------------------  event registration ------------------------------ 

Framework.registerEvent = function(event, formid, priority)  {
  var xmlOutboundDocument = Framework.getXMLOutboundDocument(formid);
  var controls = xmlOutboundDocument.documentElement;
  if (event != null)
    controls.appendChild(event);
  // simple roundtrip handling - only if the priority of the event is higher than 5 a server roundtrip is made
  if (priority>5) {
    Framework.httpLoadXml(formid); 
    var root = inboundDocument.documentElement; 
    Framework.traversePackages(root);    
  }
}

Framework.eventListener = function(ctype, formid, id, event, priority) {
var instance = Util.getInstance(ctype);
  //special case
  if (event=="xforms-value-changed")
     instance.xforms_value_changed(formid, id, event, priority, instance.getValue(id));
  else {   
    newFormid = formid;
    newId = id
    newEvent = event;
    newPriority = priority;
    eventMethod = event.replace("-","_");
    newFunction = new Function("return "+ctype+".getInstance()."+eventMethod+"(this.newFormid, this.newId, this.newEvent, this.newPriority)");
    newFunction();
    }
}

//------------------------------  Submit handling------------------------------ 
Framework.performSubmit = function(submitInfo){
    var insertNode = document.createElement("form");
    var stringArray = submitInfo.split(";");
    var formId = stringArray[0].split("=")[1];
    var actionStr = stringArray[1].substring(stringArray[1].indexOf("=") + 1, stringArray[1].length);
    var methodStr = stringArray[3].split("=")[1];
    var typeStr = stringArray[4].split("=")[1];
    var docStr = stringArray[5];
    docStr = docStr.substring(docStr.indexOf("=") + 1, docStr.length);
    if (typeStr == "all"){
      insertNode.setAttribute("action", actionStr);
      insertNode.setAttribute("method", methodStr);
      if (methodStr == "get"){
        var fieldArray = docStr.split("&");
        for (var i = 1; i < fieldArray.length - 1; i++){
          var nameValuePair = fieldArray[i].split("=");
          var fieldNode = document.createElement("input");
          fieldNode.setAttribute("type", "hidden")
          fieldNode.setAttribute("name", nameValuePair[0]);
          fieldNode.setAttribute("value", nameValuePair[1]);
          insertNode.appendChild(fieldNode);
        }
      }
      else{
        if (methodStr == "post"){
   	// NB! Not Spec complient ... Investigations ongoing regarding the final spec compliant solution
          var fieldNode = document.createElement("input");
          fieldNode.setAttribute("type", "hidden")
	  fieldNode.setAttribute("name", "submission");
	  fieldNode.setAttribute("value", docStr);
	  insertNode.appendChild(fieldNode);
	}  
      }	  		
      document.appendChild(insertNode);
      insertNode.submit();
    }
    else {
      if (typeStr == "none" || typeStr == "instance" ){
        Framework.performSubmitSequence(formId, typeStr, actionStr, methodStr, docStr);
      }
    }  
  }	

Framework.performSubmitSequence = function(formid, type, action, method, instanceDoc) {
    xmlHttp.open(method, action, false);
    if (method == "get"){
        xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    }
    else {
        xmlHttp.setRequestHeader("Content-Type", "application/xml");
    }    
    xmlHttp.send(instanceDoc);
    if (type == "instance") {
        var inSubmitText = xmlHttp.responseText;
        var inSubmitDoc = Framework.loadNewXForms(inSubmitText); ///NY
        var inSubmitTempRoot = inSubmitDoc.documentElement;
        var inSubmitRoot = inSubmitTempRoot.cloneNode(true);
        Framework.registerEvent(Package.packSubmitEvent(formid, inSubmitRoot ), formid, 10);	
        }
    else if (type == "none") {
        Framework.registerEvent(Package.packSubmitEvent(formid, null), formid, 10);
        }  
} 


Framework.processSubmitResult = function(resultNodeString){
  setTempDocument();
  var docSkel = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><instance>";
  var endDoc = "</instance>";
  xmlTempDoc.loadXML(docSkel + resultNodeString + endDoc);
  var tempNode = xmlTempDoc.documentElement;
  var tempClone = tempNode.cloneNode(true);
  var rootList = xmlOutboundDoc.getElementsByTagName("controls");
  var root = rootList[0];
  root.appendChild(tempNode);
}
