function Package() {}

//------------------------------ get from package ------------------------------

Package.getCType = function (renderNode) {
  var ctype = renderNode.attributes.getNamedItem("ctype");
  if (ctype != null)
    return ctype.value;
  else return null;
}

Package.getLabels = function (renderNode) {
  var childs = renderNode.childNodes;
  var labels;
  for (var i= 0; i < childs.length; i++) {
    if ((childs.item(i).nodeType==1) && (childs.item(i).tagName=="labels")) {
      labels = childs.item(i);
    }
  }
  var res = new Array();
  if (labels != null && labels.childNodes != null) {
    for (var i=0; i < labels.childNodes.length; i++) {
      var label = labels.childNodes.item(i);
      if ((label.nodeType==1) && (label.tagName=="control")) {
        res[i] = label;
      }
    }
  }
  return res;   
}

Package.getControlsArray = function (renderNode) {
  var res = new Array();
  if (renderNode != null) {
    var j= 0;
    var childs = renderNode.childNodes;
    for (var i= 0; i < childs.length; i++) {
      if ((childs.item(i).nodeType==1) && (childs.item(i).tagName=="controls")) {
        res[j] = childs.item(i); 
        j++;
      }
    }
  }
  return res;
}

Package.getControlArray = function (renderNode) {
  var res = new Array();
  if (renderNode != null) {
    var j= 0;
    var childs = renderNode.childNodes;
    for (var i= 0; i < childs.length; i++) {
      if ((childs.item(i).nodeType==1) && (childs.item(i).tagName=="control")) {
        res[j] = childs.item(i);
        j++;
      }
    }
  }
  return res;
}

Package.getItemsArray = function (renderNode) {
  var res = new Array();
  if (renderNode != null) {
    var k = 0;
    var childs = renderNode.childNodes;
    for (var i= 0; i < childs.length; i++) {
      if ((childs.item(i).nodeType==1) && (childs.item(i).tagName=="items")) {
        var eventChilds = childs.item(i).childNodes;
        for ( var j= 0; j < eventChilds.length; j++) {
          if ((eventChilds.item(i).nodeType==1) && (eventChilds.item(i).tagName=="item")) {
            var item = new Array();
            item[0] = eventChilds.item(j).attributes.getNamedItem("label");
            item[1] = eventChilds.item(j).attributes.getNamedItem("value"); 
            res[k]  = item;
            k++;
          }
        }
      }
    }
  }
  return res;
}


Package.getControls = function (renderNode) {
  var childs = renderNode.childNodes;
  var controls;
  for (var i= 0; i < childs.length; i++) {
    if ((childs.item(i).nodeType==1) && (childs.item(i).tagName=="controls")) {
      controls = childs.item(i);
    }
  }
  var res = new Array();
  if (controls != null && controls.childNodes != null) {
    for (var i=0; i < controls.childNodes.length; i++) {
      var control = controls.childNodes.item(i);
      if ((control.nodeType==1) && (control.tagName=="control")) {
        res[i] = control;
      }
    }
  }
  return res;   
}

Package.getId = function (renderNode) {
  var id = renderNode.attributes.getNamedItem("id");
  if (id != null)
    return id.value;
  else return null;
}

Package.getStyle = function (renderNode) {
  var style = renderNode.attributes.getNamedItem("style");
  if (style != null)
    return style.value;
  else return null;
}

Package.getValue = function (renderNode) {
  var value = renderNode.attributes.getNamedItem("value");
  if (value != null)
    return value.value;
  else return null;
}

Package.getReadOnly = function (renderNode) {
  var readonly = renderNode.attributes.getNamedItem("readonly");
  if (readonly != null)
    return readonly.value;
  else return null;
}

Package.getRelevant = function (renderNode) {
  var relevant = renderNode.attributes.getNamedItem("relevant");
  if (relevant != null)
    return relevant.value;
  else return null;
}

Package.getEvents = function (renderNode) {
  var events = renderNode.childNodes;
  var res = new Array();
  var j=0;
  for (var i=0; i < events.length; i++) {
    var event = events.item(i);
    if (event.nodeType==1 && event.tagName=="event") {
      var evt = new Array();
      evt[0] = events.item(i).getAttribute("property")
      evt[1] = events.item(i).getAttribute("script");
      res[j] = evt;
      j++;
    }
  }
  return res;   
}

//------------------------------ put in package ------------------------------

Package.packSimpleEvent = function(formId, id, event) {
  var xmlOutboundDocument = Framework.getXMLOutboundDocument(formId);    
  var controlNode = xmlOutboundDocument.createElement("control");     
  controlNode.setAttribute("id", id);    
  var eventNode = xmlOutboundDocument.createElement("event");    
  eventNode.setAttribute("eventtype", event);
  controlNode.appendChild(eventNode);
  return controlNode;
}

Package.packValueEvent = function(formId, id, event, value) {
  var  xmlOutboundDocument = Framework.getXMLOutboundDocument(formId);    
  var controlNode = xmlOutboundDocument.createElement("control");     
  controlNode.setAttribute("id", id);    
  var eventNode = xmlOutboundDocument.createElement("event");    
  eventNode.setAttribute("eventtype", event); 
  eventNode.setAttribute("value", value);
  controlNode.appendChild(eventNode);    
  return controlNode;
}

Package.packSubmitEvent = function(formId, inboundtDoc) {
  var  xmlOutboundDocument = Framework.getXMLOutboundDocument(formId);    
  var instanceNode = null;
  if (inboundtDoc != null) {
    var instanceNode = xmlOutboundDocument.createElement("instance");     
    instanceNode.appendChild(inboundtDoc);
    }
  return instanceNode;
}