
function XFormsINode100(node, formid) {
  var ri;
  var xid;
  var uniqueId
  var size;
  var value;  
  var ctype;
  var events;
  var formid;
  var eventArray;
  var valid;
  var readonly;
  var relevant;
  var required;
  var constraint;
  var inrange;
  var accessKey;
  
  var eventPriorities;
  this.eventPriorities = new Array();

  var dataRef;
  var uiRef;
  var style;
  var dataChanged;

  this.isReadOnly = XFormsINode100_isReadOnly;
  this.isRelevant = XFormsINode100_isRelevant;
  this.isRequired = XFormsINode100_isRequired;
  this.isInRange  = XFormsINode100_isInRange;
  this.isValid    = XFormsINode100_isValid;

  this.isDataChanged = XFormsINode100_isDataChanged;
  this.resetDataChanged = XFormsINode100_resetDataChanged;

  this.getDataValue = XFormsINode100_getDataValue;
  this.getDataRef = XFormsINode100_getDataRef;
  
  this.getValue= XFormsINode100_getValue;
  this.getEncodedValue= XFormsINode100_getEncodedValue;
  this.setValue= XFormsINode100_setValue;
  this.destruct = XFormsINode100_destruct;
  this.updateINode = XFormsINode100_updateINode;
  this.updateUINode = XFormsINode100_updateUINode;
  this.setINode = XFormsINode100_setINode;
  this.setUIRef = XFormsINode100_setUIRef;
  this.getUIRef = XFormsINode100_getUIRef;
  this.getEventPriorities = XFormsINode100_getEventPriorities;
  this.value = "";
  this.eventArray = new Array();
  this.getType = XFormsINode100_getType;
  this.getUniqueId = XFormsINode100_getUniqueId;
  this.getRi = XFormsINode100_getRi;
  this.getXid = XFormsINode100_getXid;
  
  this.dataChanged = false;
  this.getAccessKey = XFormsINode100_getAccessKey;
  this.formid= formid;
  this.setINode(node);
}

function XFormsINode100_getAccessKey() {
  return this.accessKey;
}


function XFormsINode100_getValue() { 
  return this.value;
}

function XFormsINode100_getEncodedValue() { 
  return escape(escape(this.value));
}

function XFormsINode100_getType() { 
  return this.ctype;
}

function XFormsINode100_getUniqueId() { 
  return this.uniqueId;
}

function XFormsINode100_getRi() { 
  return this.ri;
}
function XFormsINode100_getXid() { 
  return this.xid;
}

function XFormsINode100_setValue(val) { 
  this.value=val;
}
function XFormsINode100_setUIRef(element) { 
  this.uiRef=element;
}
function XFormsINode100_getUIRef() { 
  return this.uiRef;
}

function XFormsINode100_destruct(){
  xformsfw[this.formid].unregisterINode(this.uniqueId);
}

function XFormsINode100_updateINode(node){
  var attrList = node.attributes;
  var j;
  
  for (j = 0; j < attrList.length; j++) {
    var attrName = attrList.item(j).nodeName;
    var attrVal = attrList.item(j).nodeValue;
    //alert(attrName + " = " + attrVal);
    if (attrName == "id") {  // get xid 
      this.xid = attrVal; 
    }
    if (attrName == "ri") {  // get repeatindex 
      this.ri = attrVal;
    }
    if (attrName == "value") {
      this.value = unescape(attrVal);
      //alert("Decoding: " + attrVal + " to " + this.value);
    }
    if (attrName == "readonly") {
      this.readonly = attrVal=="true";
    }

    if (attrName == "relevant") {
      this.relevant = attrVal=="true";
    }
    if (attrName == "required") {
      this.required = attrVal=="true";
    }
    if (attrName == "valid") {
      this.valid = attrVal=="true";
    }
    if (attrName == "constraint") {
      this.constraint = attrVal=="true";
    }
    if (attrName == "help") {
      this.helpText = attrVal;
    }
    if (attrName == "hint") {
      this.hintText = attrVal;
    }
    if (attrName == "ctype") {
      this.ctype = attrVal;
    }
  }
  this.uniqueId = this.xid + this.ri;
  //alert("Creating inode with uid:" + this.uniqueId);
}


function XFormsINode100_updateUINode(node){
  var attrList = node.attributes;
  var j;
  for (j = 0; j < attrList.length; j++) {
    var attrName = attrList.item(j).nodeName;
    var attrVal = attrList.item(j).nodeValue;
    if (attrName == "accesskey") {
      this.accessKey = attrVal;
    }
    if (attrName == "events") {
      var tmpArray = new Array();
      this.events = attrVal;
      tmpArray = this.events.split(";");
      for (i=0; i<tmpArray.length; i++) {
        var tmpArray1 = tmpArray[i].split("=");
        this.eventPriorities[tmpArray1[0]] = tmpArray1[1];
      }  
    }
  }
}

function XFormsINode100_setINode(node){
  var ctype = node.attributes.getNamedItem("ctype");
  if (ctype != null) {
    this.ctype = ctype;
  }
  this.updateINode(node);
  xformsfw[this.formid].registerINode(this.uniqueId, this);
  
  
  var nodeChilds = node.childNodes;
  var i;
  for (i = 0; i < nodeChilds.length; i++) {
    
    var currNode = nodeChilds.item(i); 
    if (currNode.nodeName == "aui") {
      
      this.updateUINode(currNode);
      var auiChildren = currNode.childNodes;
      for (k = 0; k < auiChildren.length; k++) {
        var cNode = auiChildren.item(k);
        if (cNode.nodeName == "message") {
          xformsfw[this.formid].performMessage(cNode);
        }
        if (cNode.nodeName == "data") {
          var dataNode = cNode;
          this.dataRef = dataNode;
          this.dataChanged = true;
        }
      }  
    }
    var newNode;
    if (currNode.nodeName == "inode") {
      // Hack to preserve repeat-item in inode structure
      if (currNode.attributes.getNamedItem("id")!=null) {
        var id = currNode.attributes.getNamedItem("id").nodeValue;
        var ri = currNode.attributes.getNamedItem("ri").nodeValue;
        
        newNode = xformsfw[this.formid].getINode(id + ri);
        //alert("new inode " + newNode);
        if (newNode==null) {
          newNode = new XFormsINode100(currNode, this.formid);
          
        } else {
          newNode.setINode(currNode);
        }
      }
    }
  }
}   

function XFormsINode100_isReadOnly() {
  return this.readonly;
}
function XFormsINode100_isRelevant() {
  return this.relevant;
}
function XFormsINode100_isRequired() {
  return this.required;
}
function XFormsINode100_isInRange(){
  return this.inrange;
}
function XFormsINode100_isValid(){
  return this.valid;
}
function XFormsINode100_isDataChanged() {
  return this.dataChanged;
}

function XFormsINode100_resetDataChanged() {
  this.dataChanged=false;;
}

function XFormsINode100_getDataValue() {
  var dataNode = this.dataRef;
  if (dataNode != null) {
    return dataNode.firstChild.nodeValue;
  } else return null;
}
function XFormsINode100_getDataRef() {
  return this.dataRef;
}

function XFormsINode100_getEventPriorities(){
  return this.eventPriorities;
}
