@rem $Novell: bldlibc.bat,v 1.4 2003/01/14 20:06:05 $
@echo off

rem   A batch file for building LDAP samples or test programs for NetWare
rem   running LIBC, using the Metrowerks CodeWarrior C compiler

rem   You may need to customize settings marked with "***".

rem   To build LIBC LDAP programs for NetWare, you must download and install
rem   from Novell's NDK:
rem     - Libraries for C (LIBC)


if "%1"=="" goto Usage

rem *** Base path for Novell NDK
set _NDK_BASE=C:\Novell\NDK

rem *** Base path for the Metrowerks compiler.
rem *** This path should contain directories:  Bin, "Novell Support", etc
set _CODEWAR_BASE=C:\CodeWarrior

rem   *** Set directory containing mwccnlm.exe and mwldnlm.exe.
rem   *** This may change with compiler versions.
set _CWTOOL_PATH=%_CODEWAR_BASE%\Other Metrowerks tools\command line tools

rem *** A debug version of your program will be built if the environment
rem     variable DEBUG is defined.   i.e. SET DEBUG=Y


rem   Set LDAP symbols relative to base
set _LDAP_LIB_PATH=%_NDK_BASE%\cldapsdk\NetWare\libc\imports

rem   Set path to NetWare import files.
set _NW_LIB_PATH=%_NDK_BASE%\libc\imports

rem C compiler and flags
set _COMPILER="%_CWTOOL_PATH%\mwccnlm.exe"
set _COMP_FLAGS=-c -DN_PLAT_NLM -DLIBC -nodefaults -opt all -o %1.obj 
if NOT "%DEBUG%" == ""  set _COMP_FLAGS=-c -DN_PLAT_NLM -DLIBC -nodefaults -opt off -g -o %1.obj

rem Linker and flags
set _LINKER="%_CWTOOL_PATH%\mwldnlm.exe"
set _LINK_FLAGS=-screenname %1 -nodefaults -zerobss -flags multiple,pseudopreemption -entry _LibCPrelude -exit _LibCPostlude -commandfile %1.def
if NOT "%DEBUG%" == ""  set _LINK_FLAGS=%_LINK_FLAGS% -sym internal -osym %1.sym

rem *** Create an XDC file to specify that this NLM is multiprocessor-safe.  
rem If you don't specify an XDC file during the link, the NLM will be 
rem forced to run on processor 0 on a multiprocessor machine.
set _MPKXDC="%_NDK_BASE%\nwsdk\tools\mpkxdc.exe"
%_MPKXDC% -n mpsafe.xdc

rem ***  Select which LDAP libraries to use.
rem   All LDAP programs require LDAPSDK. 
rem   LDAPSSL is needed only if your program uses SSL encryption.
rem   LDAPX is needed only if your program uses novell LDAP extensions.
rem   This sample uses all three.

echo # Dynamically generated command file for metrowerks build > %1.def
echo DESCRIPTION %1                          >> %1.def
echo IMPORT @%_LDAP_LIB_PATH%\lldapsdk.imp   >> %1.def
echo IMPORT @%_LDAP_LIB_PATH%\lldapx.imp     >> %1.def
echo IMPORT @%_LDAP_LIB_PATH%\lldapssl.imp   >> %1.def
echo IMPORT @%_NW_LIB_PATH%\libc.imp         >> %1.def
echo XDCDATA mpsafe.xdc                      >> %1.def
echo MODULE lldapsdk, lldapx, lldapssl, libc >> %1.def

set _INC_PATHS=-nosyspath -I%_NDK_BASE%\cldapsdk\NetWare\libc\inc -I%_NDK_BASE%\libc\include -I%_NDK_BASE%\libc\include\winsock
set _PRELUDE_OBJ="%_NDK_BASE%\libc\imports\libcpre.o"
@rem  libcaux is necessary if using older versions of LIBC.
set _STATIC_LIBS="%_NW_LIB_PATH%\libcaux.lib"

echo.
echo   Building LDAP program for LIBC ...
%_COMPILER%  %_COMP_FLAGS%  %_INC_PATHS%  %1.c
if ERRORLEVEL 1 goto done


%_LINKER%  %_LINK_FLAGS% %1.obj %_PRELUDE_OBJ% %_STATIC_LIBS%
if ERRORLEVEL 1 goto done

echo   Build complete.

:done
del %1.obj 2>nul
del %1.def 2>nul
set _NDK_BASE=
set _CODEWAR_BASE=
set _LDAP_LIB_PATH=
set _NW_LIB_PATH=
set _CWTOOL_PATH=
set _INC_PATHS=
set _COMPILER=
set _COMP_FLAGS=
set _LINKER=
set _LINK_FLAGS=
set _PRELUDE_OBJ=
set _MPKXDC=
set _STATIC_LIBS=
exit /B %ERRORLEVEL%

:Usage
echo.
echo Usage:  bldlibc filename  (with no extension.  Assumes .c)
echo      Builds a LIBC program with Novell's LDAP Libraries for C for NetWare.
echo.
echo      You may need to edit this script to set some environment variables
echo      appropriate to your system.

